<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: bug_admin_field_values_list.php,v 1.8 2005/06/30 17:19:34 toddy Exp $
#
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2004      (c) ...
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


require "../include/pre.php";

help_header("Bug Administration -  Bug Field Values List");

?>

<p>The Bug Tracking System allows you to define your own values for
most of the fields you have decided to use (see Field Usage menu
item). To customize a value, simply click on the corresponding field.


<p>This page shows you a list of Active and Hidden values for a given field.

<p>Information displayed on this page:
<ul type="compact">

<li><b>ID</b>: the ID column is only shown for fields which have a
'System' scope. For this type of field the ID often carry a semantic
meaning and if you redefine the value label associated with a given ID
it is important that you know about the ID.

<br /> As an example the Severity field has 9 possible values and the
bugs with the highest ID are always considered as the most critical
bug by the system. So it would be bad idea for instance to redefine
the value label for ID 9 to something like 'Very Minor' :-) but it is
ok to redefine it as 'Fatal'.

<li><b>Value Label</b>: the text label of the value as shown in the select box

<li><b>Description</b>: meaning of the value

<li><b>Rank</b>: allows you to define the order of the field values in
the select box. The smaller values appear first in the select box.

<li><b>Status</b>: 
<ul>
<li><i><u>Active</u></i> : these values are currently visible in your
bug field select box.

<li><i><u>Hidden</u></i> : these values are not visible in your bug
field select box.

<li><i><u>Permanent</u></i> : these values are permanent and cannot be
removed from the list of possible values. They always appear in the
select box.
</ul>
<p>You can decide to activate/hide a value at any time in the life of
the project.

</ul>

<p>For fields with a 'Project' scope you also have the ability to
define a new value by filling out the form at the bottom of the
screen.
