#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Download.pm,v 1.2 2005/06/30 16:46:00 toddy Exp $
#
#  Copyright 2003-2005 (c) Mathieu Roy <yeupou--gnu.org>
#                          Sylvain Beucler <beuc--beuc.net>
#                          Free Software Foundation, Inc.
# 
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


##
## Desc: any subs related to Download area.
## 

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(GetScriptDownloadInit );
our $version = 1;

## Make a download area
sub DownloadMakeArea {
    my ($name,$dir_download,$is_public) = @_;
    my $warning = "";

    # %PROJECT is not mandatory, but if it is missing, it may well be 
    # a major misconfiguration.
    # It should only happen if a directory has been set for a specific 
    # project.
    unless ($dir_download =~ s/\%PROJECT/$name/) {
	$warning = " (The string \%PROJECT was not found, there may be a group type serious misconfiguration)";
    }

    unless (-e $dir_download) {
	
	my $mode = $is_public ? 2775 : 2770;
	system("mkdir", "-p", $dir_download);
	system("chmod", $mode, $dir_download);
	system("chgrp", $name, $dir_download);
	return " ".$dir_download.$warning;
    } 
    return;
}


## Make a gatekeeper download area at Savannah
## This is temporary
sub DownloadMakeAreaSavannah {
    my ($name,$dir_download,$is_public) = @_;

    if (-e "/savannah/download/$name" || !$is_public) {
	return 1;
    }

    # print LOG strftime "[$script] %c ---- created download $name\n", localtime;

    mkdir ("/savannah/download/$name");
    chmod (00755, "/savannah/download/$name");
    system (('/bin/chown', "gatekpr.gatekpr", "/savannah/download/$name"));

    mkdir ("/home/upload/incoming/savannah/$name");
    chmod (00770, "/home/upload/incoming/savannah/$name");
    system (('/bin/chown', 'upload.gatekpr', "/home/upload/incoming/savannah/$name"));

    # print LOG strftime "[$script] %c ---- created upload $name\n", localtime;

    # create the incoming ftp dir
    mkdir ("/home/upload/incoming/savannah/$name");
    chmod (00770, "/home/upload/incoming/savannah/$name");
    system (('/bin/chown', 'upload.gatekpr', "/home/upload/incoming/savannah/$name"));

    # print LOG strftime "[$script] %c ---- created ftp-in $name\n", localtime;

    # ..and the ftp-in tmp dir
    mkdir ("/var/tmp/ftp-in/$name");
    chmod (00770, "/var/tmp/ftp-in/$name");
    system (('/bin/chown', 'gatekpr.gatekpr', "/var/tmp/ftp-in/$name"));

    # print LOG strftime "[$script] %c ---- created ftp-out $name\n", localtime;

    # ..and the ftp-out tmp dir
    mkdir ("/var/tmp/ftp-out/$name");
    chmod (00770, "/var/tmp/ftp-out/$name");
    system (('/bin/chown', 'gatekpr.gatekpr', "/var/tmp/ftp-out/$name"));

    # ..and the gatekeeper project directory
    mkdir("/home/gatekpr/projects/$name");
    chmod (00755, "/home/gatekpr/projects/$name");
    system('/bin/chown', 'gpg-writer:nogroup', "/home/gatekpr/projects/$name");
    return;
}
