#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_extra_import_data.pl,v 1.1 2005/09/15 15:11:04 yeupou Exp $
#
#
# Copyright (c) 2004 Mathieu Roy <yeupou@gnu.org>
# http://yeupou.coleumes.org
#
#   The Savane project is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   The Savane project is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with the Savane project; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#

use strict;
use Getopt::Long;
use Savane;

# Import     
our $sys_dbhost;
our $sys_dbname;





my ($getopt, $help, $project);

eval {
    $getopt = GetOptions("project=s" => \$project,
			 "help" => \$help);
};

if ($help) {
    print "$0 --project <unix_group_name>";

}

die "No project name given. Exiting" unless $project;


my $id = GetGroupSettings($project, "group_id");
my ($uid) = GetGroupAdmins($project); # assume that the project got only 
                                    # one admin, which should be the case
                                    # at group creation.
die "No group id found. Exiting" unless $id;
die "No admin user id found. Exiting" unless $uid;



# this is site specific:
my $sourcecode = "/chroot/cvs/var/cvs/".$project;
my $homepage = "/chroot/cvs/var/cvs/".$project.".homepage";
my $download = "/chroot/download/var/ftp/".$project;
my $tarball = "/tmp/svdata_".$project;
my $tarballgz = "/tmp/svdata_".$project.".tar.gz";


die "No tarball here" unless -e $tarballgz;
`tar xfz $tarballgz`;

# we assume that the package have been correctly built

if (-e $tarball."/sql") {
     # we must replace the string  ----GROUPID---- by the actual group_id
    open(SQLORIG, "< $tarball/sql");
    open(SQLNEW, "> $tarball/sql2");
    while (<SQLORIG>) {
	s/----GROUPID----/$id/g;
	s/----ADMINID----/$uid/g;
	print SQLNEW $_;
    }
    close(SQLORIG);
    close(SQLNEW);
    `mysql -h $sys_dbhost -p $sys_dbname < $tarball/sql2`;
    print "sql imported\n";
}

if (-e $tarball."/sourcecode") {
    `cp -a $tarball/sourcecode/* $sourcecode/`;
    print "sourcecode imported\n";
}


if (-e $tarball."/homepage") {
    `cp -a $tarball/homepage/* $homepage/`;
    print "homepage imported\n";
}


if (-e $tarball."/download") {
    `cp -a $tarball/download/* $download/`;
    print "download imported\n";
}


print "Make sure the groups are appropriately set!\n";
