<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: user_home.php 6020 2006-10-02 07:39:21Z yeupou $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2001 (c) Free Software Foundation
#
#  Copyright 2003-2006 (c) Mathieu Roy <yeupou--gnu.org>
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

register_globals_off();
require_directory("my");

# Assumes $res_user result handle is present

if (!$res_user || db_numrows($res_user) < 1)
{
  exit_error('No Such User','No Such User');
}

site_header(array('title'=>sprintf(_("%s Profile"),db_result($res_user, $i, 'realname')),
		  'context'=>'people'));

# For suspended account, we will print only very basic info:
# accound id, login + description as deleted account
$is_suspended = 0;
if (db_result($res_user,0,'status') == 'S')
{ $is_suspended = 1; }


print '<p>'.sprintf(_("Follows the Profile of %s."), utils_user_link(db_result($res_user, $i, 'user_name'),db_result($res_user, $i, 'realname'))).'</p>';


print html_splitpage("start");


if (!$is_suspended)
{

  # List items:
  #  - ignore recipes, it is less personal
  #  - ignore closed items, it would make a page that dont scale for
  #    very active developers
  #  - ignore private items

  $sql = "SELECT groups.group_name,"
    . "groups.group_id,"
    . "groups.unix_group_name,"
    . "groups.status "
    . "FROM groups,user_group "
    . "WHERE groups.group_id=user_group.group_id "
    . "AND user_group.user_id='".user_getid()."' "
    . "AND groups.status='A' "
    . "GROUP BY groups.unix_group_name "
    . "ORDER BY groups.unix_group_name";

  $result = db_query($sql);
  $rows = db_numrows($result);
  $usergroups = array();
  $usergroups_groupid = array();
  if ($result && $rows > 0)
    {
      for ($j=0; $j<$rows; $j++)
	{
	  unset($nogroups);
	  $unixname = db_result($result,$j,'unix_group_name');
	  $usergroups[$unixname] = db_result($result,$j,'group_name');
	  $usergroups_groupid[$unixname] = db_result($result,$j,'group_id');
	}
    }
  else
    { $nogroups = 1; }


  print $HTML->box_top(sprintf(_("Open Items submitted by %s"),db_result($res_user,0,'realname')),'',1);
  # FIXME: News item are missing

  my_item_list("submitter", "0", "open", $user_id, true);
  print $HTML->box_bottom(1);

  print "<br />\n";

  print $HTML->box_top(sprintf(_("Open Items assigned to %s"),db_result($res_user,0,'realname')),'',1);
  # FIXME: News item are missing
  my_item_list("assignee", "0", "open", $user_id, true);
  print $HTML->box_bottom(1);

}

print html_splitpage(2);



print $HTML->box_top(_("General Information"));

print '
<br />
<table width="100%" cellpadding="0" cellspacing="0" border="0">
<tr valign="top">
	<td>'
	._("Real Name:").' </td>
	<td><strong>'.db_result($res_user,0,'realname').'</strong></td>
</tr>
<tr valign="top">
	<td>'._("Login Name:").' </td>
	<td><strong>'.db_result($res_user,0,'user_name').'</strong></td>
</tr>
<tr valign="top">
	<td>'
	._("Id:").' </td>
	<td><strong>#'.db_result($res_user,0,'user_id').'</strong></td>
</tr>';


print '
   <tr valign="top">
	<td>'._("Email Address:").' </td>
	<td>
	<strong><a href="'.$GLOBALS['sys_home'].'sendmessage.php?touser='.db_result($res_user,0,'user_id').'">';
  
  # Do not print email address to anonymous user
if (db_result($res_user,0,'email_hide') == "1")
{
  print _("Send him/her a mail");
  
} 
else 
{
  print utils_email(db_result($res_user,0,'email'));
}

print '</a></strong>
	</td>
</tr>
<tr valign="top">
	<td>'
    ._("Site Member Since").':
	</td>
	<td>
		<strong>'.format_date(false,db_result($res_user,0,'add_date')).'</strong>
	</td>
</tr>
<tr valign="top">
	 <td></td>
	 <td>';
  
if (db_result($res_user,0,'people_view_skills') != 1) {
  print _("This user deactivated his/her Resume & Skills").'.';
} else {
  print '<a href="'.$GLOBALS['sys_home'].'people/resume.php?user_id='.db_result($res_user,0,'user_id').'"><strong>'._("View Resume & Skills").'</strong></a>';
}

print '
	</td>
</tr>
';

if (db_result($res_user,0,'gpg_key') != "") {
  print '<tr valign="top"><td></td><td>';
  print	'<a href="'.$GLOBALS['sys_home'].'people/viewgpg.php?user_id='.db_result($res_user,0,'user_id').'"><strong>'._("Download GPG Key").'</strong></a>';
  print '</td></tr>';
  
}

print '</table>';

print $HTML->box_bottom();


if (!$is_suspended)
{
  
  print "<br />\n";
# FIXME: it could reuse the arrays built before to generate
# the items lists.

  print $HTML->box_top(_("Project/Group Information"),'',1);
# now get listing of groups for that user

  $sql = "SELECT groups.group_name,"
    . "groups.group_id,"
    . "groups.unix_group_name,"
    . "groups.status,"
    . "user_group.admin_flags, "
    . "group_history.date "
    . "FROM groups,user_group,group_history "
    . "WHERE groups.group_id=user_group.group_id "
    . "AND user_group.user_id='".$user_id."' "
    . "AND groups.status='A' "
    . "AND groups.is_public='1' "
    . "AND (group_history.field_name='Added User' OR group_history.field_name='Approved User' OR user_group.admin_flags='P')"
    . "AND group_history.group_id=user_group.group_id "
    . "AND group_history.old_value='".db_result($res_user,0,'user_name')."' "
    . "GROUP BY groups.unix_group_name "
    . "ORDER BY groups.unix_group_name";

  $result = db_query($sql);
  $rows = db_numrows($result);

# Alternative sql that do not use group_history, just in case this history
# would be flawed (history usage has been inconsistent over Savane history)
$sql_without_history = "SELECT groups.group_name,"
. "groups.group_id,"
. "groups.unix_group_name,"
. "groups.status,"
. "user_group.admin_flags "
. "FROM groups,user_group "
. "WHERE groups.group_id=user_group.group_id "
. "AND user_group.user_id='".$user_id."' "
. "AND groups.status='A' "
. "GROUP BY groups.unix_group_name "
. "ORDER BY groups.unix_group_name";

$result_without_history = db_query($sql_without_history);
$rows_without_history = db_numrows($result_without_history);

// The history is often broken, as soon as you have an old install or
// rename a user. This has nothing to do with the 1.0.6 upgrade - we
// need to convert the project history to machine-readable data.

if ($rows_without_history != $rows)
{
  # If number of rows differ, assume that history is flawed.
  $result = $result_without_history;
  $rows = $rows_without_history;
}


  $j = 1;
  unset($content);
  for ($i=0; $i<$rows; $i++)
    {
      $content .= '<li class="'.utils_get_alt_row_color($j).'">';
      $content .= '<a href="'.$GLOBALS['sys_home'].'projects/'. db_result($result,$i,'unix_group_name') .'/">'.db_result($result,$i,'group_name').'</a><br />';
      $date_joined = db_result($result, $i, 'date');
      if ($date_joined)
	{
# If the group history is flawed (site install problem), the
# date may be unavailable
	  $content .= '<span class="smaller">'.
	    sprintf(_("Member since %s"),
		    format_date('', $date_joined)).
	    '</span>';
	}
      $content .= '</li>';
      $exists=1;
      $j++;
    }

  if (!$exists)
    {
      print _("This user is not a member of any Project/Group");
    }
  else
    {
      print '<ul class="boxli">'.$content.'</ul>';
    }
  unset($exists);

  print $HTML->box_bottom(1);


  print html_splitpage(3).'<p class="clearr">&nbsp;</p>';

  if (user_isloggedin()) 
    {
      sendmail_form_message($GLOBALS['sys_home'].'sendmessage.php', $user_id);
    
    } 
  else 
    {
      print '<p class="warn">'._("You Could Send a Message if you were logged in").'.</p>';

    }

}

$HTML->footer(array());

?>
