# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__docformat__ = 'plaintext'# Contributor: "Dinesh Joshi" <dinesh.joshi@yahoo.com>

import math
import sys
import getopt
from time import *
from gnowsysTable import *
from datatypes import *

"""
	Class diagram generator for GNOWSYS
"""
class storageSpec:
	def __init__( self ):
		self.gnowTableList = []
		self.debug = 0


		self.nidinidTableName            = 'gbnidinid'
		self.inidssidTableName           = 'gbinidssid'
		
		self.gbMetaTypesTableName        = 'gbmetatypes'
		self.gbObjectTypeTableName       = 'gbobjecttypes'
		self.gbObjectsTableName          = 'gbobjects'
		self.gbAttributeTypeTableName    = 'gbattributetypes'
		self.gbAttributesTableName       = 'gbattributes'
		
		self.gbRelationTypeTableName     = 'gbrelationtypes'
		self.gbRelationsTableName        = 'gbrelations'
		
		self.gbUserTypeTableName         = 'gbusertypes'
		self.gbUsersTableName            = 'gbusers'
		self.gbVocabularyTableName       = 'gbvocabulary'
		self.gbSelectionListTableName    = 'gbselectionlist'
		
		self.roleTypesTableName          = 'gbroletypes'
		self.gbDataTypeTableName         = 'gbdatatypes'
		self.regularExpressionsTableName = 'gbregularexpressions'
		self.valueRestrictionsTableName  = 'gbvaluerestrictions'
		
		# Please specify the fields in the following format:
		#	f = list[ 'name', 'type', 'constraint', 'ft', 'comment' ]
		# 			'ft' specifies the primary key type of the field table
		#			'constraint' specifies the constraint on the field
		#				it can be a simple 'PRIMARY KEY' or
		#				it can be a list specifying the reference [ 'tblname', 'tblcol' ]
		
		# snapshot fields
		self.ssidField =				[ 'ssid', 'int8' , "", "", "" ]			# int8, fk
		self.inidField =				[ 'inid', 'int8' , "NOT NULL", "", "" ]			# int8, fk
		self.uidField  =				[ 'uid' , 'int8' , "NOT NULL", "", "It is actually inid" ]			# int8, fk


		self.timestampField = [ 'gbtimestamp', 'timestamptz', 'DEFAULT now()', '', '' ]
		
		# version fields
		self.modificationsField =		[ 'noofchanges'      , 'int4'       , "NOT NULL", "", "" ]	# int       <- no of fields changed
		self.fieldschangedField =		[ 'fieldschanged'      , 'varchar[]'  , "NOT NULL", "", "" ] 	# varchar[] <- list of names of fields changed
		self.changetypeField =			[ 'changetype'         , 'int8[]'        , "NOT NULL", "", "" ]	# int       <- 0='DELETE', 1='INSERT', 2='UPDATE' put restriction
		self.numofcommitsField =		[ 'noofcommits'       , 'int4'        , "NOT NULL", "", "" ] 	# int		<-
		self.numofmodificationsField =	[ 'noofchangesaftercommit' , 'int4'        , "NOT NULL", "", "" ]	# int		<- no.of times a given snapshot has 
		self.historyField =				[ 'history'            , 'int8[]'     , "NOT NULL", "", "" ]	# int8[]	<- array of ssids ( ssids of only commits are stored )
		
		
		# node specific properties
		self.titleField =				[ 'title'          , 'varchar[]'      , "", "int8", "" ]		# varchar[]
		self.descriptionField = 		[ 'description'    , 'text'           , "", "int8", "" ]		# text
		self.statusField = 				[ 'status'             , 'varchar'    , "", "int8", "" ]	# value is one from the status vocab list ( configurable in the main class )
		self.uriField =					[ 'uri'                , 'varchar'    , "", "int8", "" ]	# varchar
		
		
		# network properties
		self.attributeTypesField =	[ 'attributetypes' , 'int8[]'     ,"", "int8", "array of ssids" ]	# int8[] <- array of ssids
		self.attributesField = 		[ 'attributes'     , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.relationtypesField = 	[ 'relationtypes'  , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.relationsField = 		[ 'relations'      , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.subtypeofField = 		[ 'subtypeof'      , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.subtypesField =		[ 'subtypes'       , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.instanceofField =		[ 'instanceof'     , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.instancesField = 		[ 'instances'      , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.roleTypesField  =		[ 'roletypes'      , 'int8[]'     ,"", "int8", "array of ssids" ]
		self.contentField  =		[ 'content'        , 'varchar'    ,"", "int8", "" ]
		self.subjectTypesField  =	[ 'subjecttypes'   , 'int8[]'     ,"", "int8", "array of ssids" ]
		
		self.nidField =				[ 'nid'                , 'int8'    ,  "NOT NULL", "", "UNIQUE with nodetype" ]	# varchar
		self.ssidField_pk =			[ 'ssid'               , 'serial8' , 'PRIMARY KEY', "", "" ]	# serial8
		self.inidField_pk =			[ 'inid'               , 'serial8' , 'PRIMARY KEY', "", "" ]	# serial8
		
		# TODO: document this
		self.ssidField_fk =			[ 'ssid'               , 'int8'       ,  [ ['NOT NULL UNIQUE'], [ self.inidssidTableName, self.ssidField_pk ] ], "", "" ]	# serial8
		self.inidField_fk =			[ 'inid'               , 'int8'       ,  [ ['NOT NULL'], [ self.nidinidTableName , self.inidField_pk ] ], "", "" ]	# serial8
		
		
		
		
		self.snapshotfields = [ self.ssidField_fk, self.inidField_fk, self.uidField, self.statusField ]
		
		self.versionfields = [ 
							self.modificationsField, 
							self.fieldschangedField, 
							self.changetypeField, 
							self.numofcommitsField, 
							self.numofmodificationsField, 
							self.historyField,
							self.timestampField
						]
		
		self.nodespecificprops = [ self.titleField, self.descriptionField ]
		
		self.networkprops = [
							self.attributeTypesField, 
							self.attributesField, 
							self.relationtypesField, 
							self.relationsField, 
							self.subtypeofField, 
							self.subtypesField,
							self.instanceofField, 
							self.instancesField, 
						]
		
		# common type fields
		self.commontypefields = [ 
									self.snapshotfields, 
									self.uriField, 
									self.versionfields, 
									self.nodespecificprops, 
									self.networkprops 
								]
		
		# object types
		self.mandatoryprops =		[ 'mandatoryprops'     , 'int8[]'     ,"", "int8", "array of ssids" ]
		
		
		# attribute types
		
		self.datatypeField =		[ 'datatype_dtid'      , 'int4'   ,   "", "int8", "" ]
		self.restrictionField =		[ 'restrictionref'     , 'int8'  ,   "", "int8", "points to either restriction table or selection list table depending on restrictiontype field" ]
		self.restrictionTypeField =	[ 'restrictiontype'    , 'int8'  ,   "", "int8", "0 = selection\n 1 = datatype" ]
		
		
		self.sentenceField =		[ 'sentence'     , 'varchar'     ,  "", "", "" ]
		self.subjectField =			[ 'subject'      ,  'int8'        ,  "", "int8", "" ]
		self.valueField =			[ 'valueid'      ,  'int8'        ,  "", "int8", "id from one of the value tables. Datatype id tells which value table to look at" ]
		
		self.isTransitiveField  =	[ 'istransitive'     , 'boolean'     ,  "", "", "" ]
		self.isReflexiveField   =	[ 'isreflexive'      , 'boolean'     ,  "", "", "" ]
		self.isSymmetricalField =	[ 'issymmetrical'    , 'boolean'     ,  "", "", "" ]
		
		
		# IMPORTANT NOTE:
		# the uid in any table refers to the inid of the user
		
		# vocabulary table
		self.vocabidField =			 [ 'vocabid'               , 'serial8' , 'PRIMARY KEY', "", "" ]
		self.vocabNameField =		 [ 'vocabname'             , 'varchar'    , '', "", "" ]
		self.vocabdescriptionField = [ 'vocabdescription'      , 'text'       , '', "", "" ]
		
		# selection list table
		self.selidField =		[ 'selid'               , 'serial8' , 'PRIMARY KEY', "", "" ]
		self.selListField =		[ 'sellist'             , 'int8[]'     , '', "", "" ]
		
		
		# tables

		# metatypes tables
		self.metatypesTable  = 		[
									self.snapshotfields,
									self.uriField,
									self.versionfields,
									self.nodespecificprops,
									self.attributeTypesField,
									self.attributesField,
									self.relationtypesField,
									self.relationsField,
									self.subtypeofField,
									self.subtypesField,
									self.instancesField,
									self.contentField,
								]
		
		self.otStructureField  = [ 'structure'               , 'int8[]' , '', 'int8', '' ]
		
		self.objectTypeTable = [ 
									self.commontypefields, 
									self.otStructureField, 
									self.mandatoryprops, 
									self.contentField 
								]
		
		self.attributeTypeTable = [ 
									self.commontypefields,  
									self.restrictionTypeField, 
									self.restrictionField, 
									self.subjectTypesField 
								]
		
		self.attributesTable = [
							# snapshot fields
							self.ssidField_fk,
							self.inidField_fk,
							self.uidField,
							
							# version fields
							self.versionfields,

							# misc
							self.statusField,
							self.sentenceField,
							
							# nbh
							self.attributeTypesField,
							self.attributesField,
							self.relationtypesField,
							self.relationsField,
							self.instanceofField,
		
							self.uriField,
							self.subjectField,
							self.valueField
						]

		self.inverseNameField = [ 'inversename'      , 'varchar[]'       , '', "", "" ]
		
		self.relationTypeTable = [
								self.ssidField_fk,
								self.inidField_fk,
								self.uidField,
								self.statusField,
								self.uriField,
								
								self.modificationsField,
								self.fieldschangedField,
								self.changetypeField,
								self.numofcommitsField,
								self.numofmodificationsField,
								self.timestampField,
								self.inverseNameField,
								
								self.titleField,
								self.descriptionField,
								
								self.attributeTypesField,
								
								self.attributesField,
								self.relationtypesField,
								self.relationsField,
								self.subtypeofField,
								self.subtypesField,
								self.instanceofField,
								self.instancesField,
								
								self.roleTypesField,
								
								self.isTransitiveField,
								self.isReflexiveField,
								self.isSymmetricalField,
								
								self.mandatoryprops,
							]
		
		#---------------------------------------------------------------------------------------------------
		# Relations table
		#---------------------------------------------------------------------------------------------------
		
		# relations table
		self.subject1Field =			[ "subject1"            ,  "int8", "", "", "" ]
		self.subject2Field =			[ "subject2"            ,  "int8", "", "", "" ]
		
		self.relationsTable = [
								self.ssidField_fk,
								self.inidField_fk,
								self.uidField,
								self.statusField,
								self.sentenceField,
								
								self.timestampField,
								self.attributeTypesField,
								self.attributesField,
								self.relationtypesField,
								self.relationsField,
								#self.subtypeofField,
								#self.subtypesField,
								self.instanceofField,
								self.instancesField,
								
								self.subject1Field,
								self.subject2Field,
							]
		#---------------------------------------------------------------------------------------------------
		
		
		self.userTypeTable = [ self.commontypefields ]
		
		
		#---------------------------------------------------------------------------------------------------
		# User table
		#---------------------------------------------------------------------------------------------------
		
		# user table
		self.firstnameField		= [ 'firstname'    , 'varchar'     ,  "", "int8", "" ]
		self.lastnameField		= [ 'lastname'     , 'varchar'     ,  "", "int8", "" ]
		self.middlenameField	= [ 'middlename'   , 'varchar'     ,  "", "int8", "" ]
		self.emailField			= [ 'email'        , 'varchar'     ,  "", "int8", "" ]
		self.domainField		= [ 'domain'       , 'varchar'     ,  "", "int8", "" ]
		self.passwordField		= [ 'password'     , 'varchar'     ,  "", "int8", "" ]
		self.contentField		= [ 'content'      , 'varchar'     ,  "", "int8", "" ]
		self.loginStatusField	= [ 'loginstatus'  , 'boolean'     ,  "",     "", "" ]
		
		self.usersTable = 	[
							self.ssidField_fk,
							self.inidField_fk,
							self.uidField,		# uid of the user modifying the user object
							self.statusField,
							self.uriField,
							self.modificationsField,
							self.fieldschangedField,
							self.changetypeField,
							self.numofcommitsField,
							self.numofmodificationsField,
							self.historyField,
							self.timestampField,

							self.loginStatusField,
							
							self.titleField,
							self.descriptionField,
							self.attributeTypesField,
							
							self.attributesField,
							self.relationtypesField,
							self.relationsField,
							self.instanceofField,
							
							self.firstnameField,
							self.lastnameField,
							self.middlenameField,
							self.emailField,
							self.domainField,
							self.passwordField,
							self.contentField
						]
		#---------------------------------------------------------------------------------------------------
		
		
		self.objectsTable = [
							self.ssidField_fk,
							self.inidField_fk,
							self.uidField,		# uid of the user modifying the user object
							self.statusField,
							self.uriField,
							self.modificationsField,
							self.fieldschangedField,
							self.changetypeField,
							self.numofcommitsField,
							self.numofmodificationsField,
							self.historyField,
							self.timestampField,
							
							self.titleField,
							self.descriptionField,
							self.attributeTypesField,
							
							self.attributesField,
							self.relationtypesField,
							self.relationsField,
							self.instanceofField,
							self.otStructureField,
							
							self.contentField
						]
						
		
		
		self.vocabularyTable =		[
									self.vocabidField,
									self.vocabNameField,
									self.vocabdescriptionField,
								]
		
		
		self.selectionListTable = 	[
									self.selidField,
									self.selListField,
								]
							
		
		#---------------------------------------------------------------------------------------------------
		# Role type tables
		#---------------------------------------------------------------------------------------------------
		
		# Role type
		self.rtidField  =		[ 'rtid'                , 'serial8' , 'PRIMARY KEY', "", "" ]
		self.role1Field =		[ 'role1'               , 'int8[]'     , '', "", "" ]
		self.role2Field =		[ 'role2'               , 'int8[]'     , '', "", "" ]
		self.card1Field =		[ 'card1'               , 'int4'        , '', "", "" ]
		self.card2Field =		[ 'card2'               , 'int4'        , '', "", "" ]
		
		self.roleTypesTable = 		[
									self.rtidField,
									self.role1Field,
									self.role2Field,
									self.card1Field,
									self.card2Field,
								]
		#---------------------------------------------------------------------------------------------------
		
		
		#---------------------------------------------------------------------------------------------------
		# data type table
		#---------------------------------------------------------------------------------------------------
		self.datatypeIdField =			[ 'datatypeid'      , 'serial8'    , "PRIMARY KEY", "", "" ]
		self.datatypeNameField =		[ 'datatypename'    , 'varchar'    , "NOT NULL UNIQUE", "", "" ]
		self.datatypeDescField =		[ 'description'    ,  'varchar'    , "", "", "" ]
		
		self.datatypeTable = [
			self.datatypeIdField,
			self.datatypeNameField,
			self.datatypeDescField,
			]
		#---------------------------------------------------------------------------------------------------
		
		
		#---------------------------------------------------------------------------------------------------
		# regex table
		#---------------------------------------------------------------------------------------------------
		self.regexIdField_pk =			[ "regexid"            ,  "serial8"    ,  "PRIMARY KEY", "", "" ]
		self.regexExpressionField = 	[ "expression"         ,  "varchar"    ,  "",        "", "" ]
		self.regexDescriptionField = 	[ 'description'        ,  'text'        ,  "",        "", "" ]
		
		self.regexTable			= 	[
									self.regexIdField_pk,
									self.regexExpressionField,
									self.regexDescriptionField,
								]
		#---------------------------------------------------------------------------------------------------
		
		
		#---------------------------------------------------------------------------------------------------
		# restriction table
		#---------------------------------------------------------------------------------------------------
		self.restrictionIdField  =	[ 'restrictionid'       , 'serial8' , 'PRIMARY KEY', "", "" ]
		self.datatypeidField =		[ 'datatypeid'          , 'int8'    , [ self.gbDataTypeTableName, self.datatypeIdField  ], "", "" ]
		self.regexIdField =			[ 'regexid'             , 'int8'    , [ self.regularExpressionsTableName, self.regexIdField_pk ], "", "" ]
		self.lengthField =			[ 'length'              , 'int8'    , '', "", "" ]
		self.rangeField =			[ 'range'               , 'varchar' , '', "", "" ]
		self.precisionField =		[ 'precision'           , 'int4'     , '', "", "" ]
		self.vrDescriptionField =   [ 'description'        ,  'text'        ,  "",        "", "" ]
		
		self.valueRestrictionTable = [
									self.restrictionIdField,
									self.datatypeidField,
									self.vrDescriptionField,
									self.regexIdField,
									self.lengthField,
									self.rangeField,
									self.precisionField,
								]
		#---------------------------------------------------------------------------------------------------

		#---------------------------------------------------------------------------------------------------
		# nodetype table
		#---------------------------------------------------------------------------------------------------
		self.ntidField = [ 'ntid', 'serial8', 'PRIMARY KEY', '', '' ]
		self.nodenameField = [ 'nodename', 'varchar', 'NOT NULL UNIQUE', '', '' ]
		self.gbNodeTypeTableName = 'gbnodetypes'

		self.nodeTypeTable = [
			self.ntidField,
			self.nodenameField
			]
		#---------------------------------------------------------------------------------------------------


# 		self.nodetypeField =		[ 'nodetype'           , 'varchar'    ,  "", "", "UNIQUE with nid" ]	# varchar
# 		self.nodetype2 =		[ 'nodetype'           , 'varchar'    ,  "", "", "" ]	# varchar

		self.nodetypeField =		[ 'ntid'       , 'int8'    ,  [ ['NOT NULL'], [ self.gbNodeTypeTableName , self.ntidField ] ], "", "" ]
		self.nodetype2 =	       	[ 'ntid'       , 'int8'    ,  "", "", "" ]	# varchar
		
		# simple tables
		self.nidinidTable  = [ self.nidField     , self.inidField_pk      , self.nodetypeField ]
		self.inidssidTable = [ self.inidField_fk , self.ssidField_pk      , self.nodetypeField ]
		

		
		# List of classes to generate! ( Please keep for legacy reasons. Do NOT delete )
		self.gen_list 	 = [ 
							[ self.gbNodeTypeTableName        ,         self.nodeTypeTable ],
							[ self.nidinidTableName           ,          self.nidinidTable ],
							[ self.inidssidTableName          ,         self.inidssidTable ],

							
							[ self.gbMetaTypesTableName       ,        self.metatypesTable ],
							
							[ self.gbObjectTypeTableName      ,       self.objectTypeTable ],
							[ self.gbObjectsTableName         ,          self.objectsTable ],
							
							[ self.gbAttributeTypeTableName   ,    self.attributeTypeTable ],
							[ self.gbAttributesTableName      ,       self.attributesTable ],
							
							[ self.gbRelationTypeTableName    ,     self.relationTypeTable ],
							[ self.gbRelationsTableName       ,        self.relationsTable ],
							
							[ self.gbUserTypeTableName        ,         self.userTypeTable ],
							[ self.gbUsersTableName           ,            self.usersTable ],
						
							[ self.gbVocabularyTableName      ,       self.vocabularyTable ],
							[ self.gbSelectionListTableName   ,    self.selectionListTable ],
							
							[ self.roleTypesTableName         ,        self.roleTypesTable ],
							[ self.gbDataTypeTableName        ,         self.datatypeTable ],
							[ self.regularExpressionsTableName,            self.regexTable ],
							[ self.valueRestrictionsTableName , self.valueRestrictionTable ],
						]

		# Convert the above list to a dict for gnowsys-wrapper
		self.dictTableNamesAndDefs = {}
		self.dictTNamesFDefs = {}

		for li in self.gen_list:
			tlist = []
			dictTmp = {}
			self.traverse( tlist, li[1] )
			for i in tlist:
				dictTmp[ i[0] ] = i
			self.dictTableNamesAndDefs[ li[0] ] = tlist
			self.dictTNamesFDefs[ li[0] ] = dictTmp


# 		tlist = []
# 		self.traverse( tlist, self.objectTypeTable )
# 		self.debug_print( tlist )
# 		sys.exit()
		
		# Populate the datatypes table
		self.dtTables = gnowsysDatatypes( self.gbDataTypeTableName, 1 )		# turn on value column prefixes TODO: what are prefixes?
		self.dtTables.createTables()
	

		for li in self.gen_list:
#			tlist = []
			tlist = self.dictTableNamesAndDefs[ li[0] ]
#			self.traverse( tlist, li[1] )
			self.debug_print( tlist )
			self.gnowTableList.append( self.addTable( li[0], tlist ) )
		
		# The ( nid, nodetype ) should be unique in nidinid table
		tmpTbl = self.findTable( self.nidinidTableName )
		tmpTbl.addUniqueConstraint( [ self.nidField, self.nodetypeField ] )

# 		tmpTbl2 = self.findTable( self.inidssidTableName )
# #		print "Debug: ", (tmpTbl.vTable.getField( self.nidField[0] )).getName()
# 		tmpTbl2.vTable.addCkeyReference( tmpTbl.vTable, [ tmpTbl.vTable.getField( self.nidField[0] ), tmpTbl.vTable.getField( self.nodetypeField[0] ) ] )


	# get the field def
	def getFieldDef( self, tblname, fldname ):
		return( self.dictTNamesFDefs[ tblname ][ fldname ] )

	
	# flatten a list
	def traverse( self, op_list, inp_list ):
		if isinstance( inp_list[0], list ):
			for li in inp_list:
				self.traverse( op_list, li )
		else:
			op_list.append( inp_list )
	
	
	def findTable( self, tblName ):
		"""
			Find a table based on name from gnowTableList
		"""
		retVal = -1
		
		for t in self.gnowTableList:
			if tblName == t.getName():
				retVal = t
		
		return retVal
	
	def debug_print( self, s ):
		if self.debug == 1:
			print s
	
	def addTable( self, tblName, lsttab ):
		t = gnowsysTable( tblName )
		
		self.debug_print( ( "Table name: ", tblName ) )
		
		for f in lsttab:
			""" 
				Logic
					if( constraint field == list ) {
						add reference field
					} else if( field type == '' ) {
						add regular field
					} else {
						add field table
					}
			"""
			# it's a list
			if isinstance( f[2], list ):
				self.debug_print( f[2] )
				if isinstance( f[2][0], list ):
					lstCnstr = f[2][1]
					thisTblCnstr = f[2][0][0]
				else:
					lstCnstr = f[2]
					thisTblCnstr = ""

				tmpTbl = self.findTable( lstCnstr[0] )
				
				if tmpTbl == -1:
					print "Error: %s table name doesn't exist!" % lstCnstr[0]
					sys.exit()

				self.debug_print( lstCnstr[1] )
				tmpFld = tmpTbl.getField( lstCnstr[1][0] )
				self.debug_print( tmpFld )
				t.addFieldWithReference( [ tmpTbl, tmpFld, thisTblCnstr ] )
			elif f[3] == '':
				self.debug_print( ( "Adding field : ", f ) )
				t.addFields( [ f ] )
			else:
				self.debug_print( ( "Adding field table : ", f ) )
				t.addFieldTables( [ f ] )
		return t
	
	
	def genHTML( self ):
		print "Autogenerated on %s" % ( strftime( "%a, %d %b %Y %H:%M:%S +0000", gmtime() ) )
		for t in self.gnowTableList:
			#t.vTable.show()
			print t.genHTML()
		
		print self.dtTables.genHTML()
		
		
	def genSQL( self ):
		
		t = ''
		
		strSQL = ""
		for t in self.gnowTableList:
			strSQL = strSQL + t.genSQL()
			
		
		schemaName = {'schema':'auth_schema'}
		
		authenSQL = """create schema %(schema)s;
		
		create table %(schema)s.users (
			name varchar(64) primary key,
			password text
		);
		
		create table %(schema)s.userroles (
			name varchar(64) not null references %(schema)s.users(name)
			on delete cascade
			on update cascade,
			role varchar(64) not null,
			constraint %(schema)s_userroles_pkey primary key (name, role)
		);
		
		create table %(schema)s.groups (
			name varchar(64) primary key,
			password text
		);
		
		create table %(schema)s.grouproles (
			name varchar(64) not null references %(schema)s.groups(name)
			on delete cascade
			on update cascade,
			role varchar(64) not null,
			constraint %(schema)s_grouproles_pkey primary key (name, role)
		);""" % schemaName
		
		
		strSQL = strSQL + self.dtTables.genSQL() + "\n\n" + authenSQL
		print strSQL

def usage():
	print "GNOWSYS v1.0 database schema generator"
	print "USAGE:"
	print "-h, --help : print help"
	print "-s, --sql  : generate SQL dump"
	print "-t, --html : generate HTML dump"
	
	
def main():
	try:
		opts, args = getopt.getopt( sys.argv[1:], "hst", [ "help", "sql", "html" ] )
	except getopt.GetoptError:
		usage()
		sys.exit(2)
	
	s = storageSpec()
	for opt, arg in opts:
		if opt in ( "-h", "--help" ):
			usage()
			sys.exit()
		elif opt in ( "-s", "--sql" ):
			s.genSQL()
		elif opt in ( "-t", "--html" ):
			s.genHTML()
		else:
			usage()
			sys.exit()
			
	source = "".join( args )


if __name__ == "__main__":
	main()
	s = storageSpec()
# 	for t in s.gnowTableList:
# 		print t
# 		tn = t.getName()
# 		flds = t[1]
# 		for f in flds:
# 			dictTemp[ f[0] ] = 'test'

# 	"""
# 	gbMetaTypes
# 	gbObjectTypes
# 	gbObjects
# 	gbAttributeTypes
# 	gbAttributes
# 	gbrelationtypes
	
# 	"""

# 	"""


# 	"""

# 	dictTemp = {}
# 	for li in s.gen_list:
# 		tlist = []
# 		s.traverse( tlist, li[1] )
# 		for f in tlist:
			
# 			dictTemp[ f[0] ] = 'test'
		

# 		t = s.findTable( li[0] )
# 		print t.vTable.genInsertSQL( dictTemp )
		
