/*
 *   $Id: LibaoDriver.cpp,v 1.11 2006/04/17 01:50:44 rhizome Exp $
 *
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/// Wrapper sur Libao bas sur un callback.

#include "LibaoDriver.h"
#include "WavFileOutput.h"

LibaoDriver::LibaoDriver(ProcessCallback processCallback, const int buf_size) 
    : AudioDriver(processCallback, buf_size),
      audio_buffer(new sample_t[buf_size]),
      active(false)
{ }

LibaoDriver::~LibaoDriver() {
    delete[] audio_buffer;
}

void LibaoDriver::run() {
    while (active) {
	audioProcessCallback(audio_buffer);
        recording_mutex.lock();
        if(recording()) {
            file_output->write(audio_buffer, buffer_size);
        }
        recording_mutex.unlock();
	ao_wrapper.play(audio_buffer, buffer_size / 2);
    }
}

void LibaoDriver::connect() {
    active = true;
    start(QThread::TimeCriticalPriority);
}

void LibaoDriver::disconnect() {
    active = false;
    wait();
}


//EOF
