/*
 *  $Id: NullDriver.cpp,v 1.7 2006/04/19 21:14:05 rhizome Exp $
 *  
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "NullDriver.h"
#include "WavFileOutput.h"

NullDriver::NullDriver(ProcessCallback processCallback, int buf_size) : 
    AudioDriver(processCallback, buf_size),
    active(0),
    audio_buffer(new sample_t[buffer_size])
{ }

NullDriver::~NullDriver() {
    delete[] audio_buffer;
}

void NullDriver::run () { 
    while(active) {
        audioProcessCallback(audio_buffer); 
        // audioProcessCallback() must be called at least as often as with a
        // real audio driver if we want the sound objects to be deleted as if
        // there where read by a true audio thread
        // 10ms is less than 1s / (44100 / 1024)
        recording_mutex.lock();
        if(recording()) {
            file_output->write(audio_buffer, buffer_size);
        }
        recording_mutex.unlock();
        // 10ms is less than 1s / (44100 / 1024)
        float time_to_wait = (static_cast<float>(buffer_size) / 44100) * 1000 / 2;
        msleep(static_cast<int>(time_to_wait));
    }
}

void NullDriver::connect()    { 
    active = 1; 
    start(); 
}

void NullDriver::disconnect() { 
    active = 0; 
    wait();
}

//EOF
