/*
 *   $Id: ChannelPtrList.h,v 1.2 2006/01/21 17:47:49 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef CHANNEL_PTR_LIST
#define CHANNEL_PTR_LIST

#include <qptrlist.h>
#include "Channel.h"

template <class T>
class ChannelPtrList : public QPtrList<T> {
    int compareItems(QPtrCollection::Item, QPtrCollection::Item);
};

template <class T>
int ChannelPtrList<T>::compareItems(QPtrCollection::Item item1, 
        QPtrCollection::Item item2) {
    if (((Channel*)item1)->rowIndex() == ((Channel*)item2)->rowIndex())
        return 0;
    else if (((Channel*)item1)->rowIndex() > ((Channel*)item2)->rowIndex())
        return 1;
    return -1;
}

#endif

//EOF 
