/*
 *   $Id: ChannelPanel.h,v 1.2 2006/02/17 16:40:55 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef CHANNEL_PANEL_H
#define CHANNEL_PANEL_H

#include "RowSet.h"

class Slag;

class ChannelPanel : public RowSet {
    Q_OBJECT
public:
    ChannelPanel(QWidget*, Slag*);
public slots:
    void renameChannel(Channel*);
signals:
    void channelMoved(Channel*);
    void channelRenamed(Channel*);
private:
    QWidget* createRow(Channel*);
    Slag* slag;
};

#endif

//EOF
