/*
 *   $Id: ChannelRow.cpp,v 1.12 2006/05/08 07:28:55 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qlayout.h>
#include <qcheckbox.h> 
#include <qslider.h>
#include <qmotifplusstyle.h>

#include "../audio_engine/Channel.h"
#include "../audio_engine/Song.h"
#include "../constants.h"

#include "ChannelRow.h"
#include "ChannelMenu.h"
#include "NamedButton.h"

ChannelRow::ChannelRow(QWidget* parent, Song* song, Channel* channel) 
    : QWidget(parent),
      channel(channel), 
      channelName(channel->name()),
      layout(new QHBoxLayout(this, 0)),
      active_box(new QCheckBox(this)),
      channel_menu(new ChannelMenu(this, song, channel)),
      channel_but(new NamedButton(channelName, this)),
      song(song)
{
    connect(channel_but,  SIGNAL(clicked(QString)),
            this,         SLOT(popupChannelMenu()));

    connect(channel_menu, SIGNAL(channelMoved(Channel*)), 
            parent,       SLOT(syncChannelPosition(Channel*)));
    connect(channel_menu, SIGNAL(channelMoved(Channel*)), 
            parent,       SIGNAL(channelMoved(Channel*)));

    connect(channel_menu, SIGNAL(channelRenamed(Channel*)), 
            parent,       SLOT(renameChannel(Channel*)));

    connect(channel, SIGNAL(indexChanged()),
            this, SLOT(syncChannelNumber()));

    QSlider* vol_slider = new QSlider(0, 100, 1, 100, Qt::Horizontal, this);
    vol_slider->setFixedWidth(100);
    vol_slider->setValue(channel->getVolumePercent());
    connect(vol_slider, SIGNAL(valueChanged(int)),
	    channel, SLOT(setVolume(int)));

    channel_but->setFixedSize(120, padButtonHeight);
    QFont f(font());
    f.setPointSize(10);
    channel_but->setFont(f);
#if defined(Q_WS_MAC)
    channel_but->setStyle(new QMotifPlusStyle);
#endif

    active_box->setChecked(0);
    active_box->setEnabled(0);
    active_box->setAccel(QKeySequence(myNumber()));

    layout->addWidget(active_box);
    layout->addWidget(vol_slider);
    layout->addWidget(channel_but);

    activate();
}

const QString ChannelRow::myNumber() {
    return QString::number(channel->rowIndex() + 1);
}

void ChannelRow::syncChannelNumber() {
    active_box->setAccel(QKeySequence(myNumber()));
}

void ChannelRow::activate() {
    active_box->setEnabled(1);

    if (channel->isActive()) active_box->setChecked(1);

    connect(active_box, SIGNAL(toggled(bool)), 
            channel,    SLOT(setActive(bool)));
}

void ChannelRow::popupChannelMenu() {
    channel_menu->exec(channel_but->mapToGlobal(QPoint(3,3)));
}

uint ChannelRow::rowIndex() {
    return channel->rowIndex();
}

void ChannelRow::setRowIndex(uint i) {
    channel->setRowIndex(i);
}

void ChannelRow::setName(QString n) {
    channelName = n;
    channel_but->setText(channelName);
}

//EOF
