/*
 * smtp.c
 * this file contains the communucation with the server
 */

/*
 * This file is part of smtpmail.
 * 
 * smtpmail is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <strings.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include "types.h"

extern int encode64 (const char *_in, unsigned inlen,
		     char *_out, unsigned outmax, unsigned *outlen);
/*
 * this function is taken from hostname 2.10
 * writen by Peter Tobias tobias@et-inf.fho-emden.de 
 */
char *
localhost (void)
{
  struct hostent *hs;
  static char *buf = 0;
  static size_t buf_len = 0;
  int myerror = 0;
  if (! buf)
    {
      do {
        errno = 0;

        if (buf) {
          buf_len += buf_len;
          buf = realloc (buf, buf_len);
        } else {
          buf_len = 128;        /* Initial guess */
          buf = malloc (buf_len);
        }

        if (! buf)
          {
            errno = ENOMEM;
            return 0;
          }
      } while (((myerror = gethostname(buf, buf_len)) == 0 && !memchr (buf, '\0', buf_len))
               || errno == ENAMETOOLONG);

      if (myerror)
        /* gethostname failed, abort.  */
        {
          free (buf);
          buf = 0;
        }
    }
  hs = gethostbyname(buf);
  return hs->h_name;
}

int
get_host (char **name)
{
  struct hostent *he;
  char str[16];
  char **ret;
  struct in_addr in;
  he = gethostbyname (*name);
  if (he == NULL)
    {
      fprintf (stderr, "gethostbyname: %s\n", *name);
      return 1;
    }
  ret = he->h_addr_list;
  memcpy (&in.s_addr, *ret, sizeof (in.s_addr));
  *name = (char *) realloc (*name, sizeof (str));
  sprintf (*name, inet_ntoa (in));
  return 0;
}

int
mod_buf (char *in, int len)
{
  int i;
  int outlen;
  outlen = strlen (in) - len;
  if (outlen < 0)
    return 1;
  for (i = 0; i < outlen; i++)
    {
      in[i] = in[len + i];
    }
  in[i + 1] = '\0';
  return 0;
}

int
send_wait (int fd, char *send, const char *search, mail_opt *opts)
{
  char buff[256];
  int n;
  size_t nbytes;
  int ok = 1;
  if (send)
    {				/* send the data */
      if(opts != NULL && opts->verbose > 1)
	fprintf(stderr, send);
      while ((nbytes = write (fd, send, strlen (send))) < strlen (send))
	{
	  if(opts != NULL && opts->verbose > 2)
	    fprintf(stderr, "%s\n\n", send);
	  mod_buf (send, nbytes);
	}
    }
  if (search)
    {
      if(opts != NULL && opts->verbose > 1)
	fprintf(stderr, "search\n");
      n = read (fd, buff, 255);
      buff[n] = '\0';
      if(opts != NULL && opts->verbose > 1)
	fprintf(stderr, buff);
      if (strncmp (buff, search, strlen (search)) == 0)
	ok = 0;
    }
  else
    {
      ok = 0;
    }
  if(opts != NULL && opts->verbose > 1)
    fprintf(stderr, "send return\n");
  return ok;
}

char *
extract_addr(char *orig)
{
  char *ret;
  int i;

  if((ret = index(orig, '<')) == NULL)
    return orig;
  ret++;
  for(i = 0; i < strlen(ret); i++)
    {
      if(ret[i] == '>')
	{
	  ret[i] = '\0';
	  break;
	}
    }
  return ret;
}

int
send_mail (mail_opt * opts)
{
  int sock;
  struct sockaddr_in srv_addr;
  char buff[1024];
  int i;
  unsigned foo;
  /* get the ip of the mailhost */
  get_host (&(opts->host));
  /* connect and search for 220 */
  sock = socket (AF_INET, SOCK_STREAM, 0);
  bzero (&srv_addr, sizeof (srv_addr));
  srv_addr.sin_family = AF_INET;
  srv_addr.sin_port = htons (25);
  inet_pton (AF_INET, opts->host, &srv_addr.sin_addr);
  if (connect (sock, (struct sockaddr *) &srv_addr, sizeof (srv_addr)) < 0)
    {
      fprintf (stderr, "connect failure\n");
      _exit (1);
    }
  if (send_wait (sock, NULL, "220", opts))
    _exit (1);
  sprintf(buff, "HELO %s\r\n", localhost());
  if(send_wait (sock, buff, "250", opts))
    {
      fprintf(stderr, "HELO failed\n");
      _exit(1);
    }
  if (opts->pass)
    {
      if (send_wait (sock, "auth login\r\n", "334", opts))
	_exit (1);
      encode64 (opts->user, strlen (opts->user), buff, 255, &foo);
      sprintf (buff, "%s\r\n", buff);
      if (send_wait (sock, buff, "334", opts))
	_exit (1);
      encode64 (opts->pass, strlen (opts->pass), buff, 255, &foo);
      sprintf (buff, "%s\r\n", buff);
      if (send_wait (sock, buff, "235", opts))
	_exit (1);
    }
  /* MAIL FROM: and search for 250 */
  sprintf (buff, "mail from: %s\r\n", extract_addr(opts->sender));
  if (send_wait (sock, buff, "250", opts))
    {
      fprintf (stderr, "mail from failed\n");
      _exit (1);
    }
  /* 
   * RCPT TO: and search for 250
   * do this for every rcpt, cc and bcc
   */
  for (i = 0; i < opts->rcpt_count; i++)
    {
      sprintf (buff, "rcpt to: %s\r\n", extract_addr(opts->rcpt_addr[i]));
      if (send_wait (sock, buff, "250", opts))
	{
	  fprintf (stderr, "%s failed\n", buff);
	  _exit (1);
	}
    }
  for (i = 0; i < opts->cc_count; i++)
    {
      sprintf (buff, "rcpt to: %s\r\n", extract_addr(opts->cc_addr[i]));
      if (send_wait (sock, buff, "250", opts))
	{
	  fprintf (stderr, "%s failed\n", buff);
	  _exit (1);
	}
    }
  for (i = 0; i < opts->bcc_count; i++)
    {
      sprintf (buff, "rcpt to: %s\r\n", extract_addr(opts->bcc_addr[i]));
      if (send_wait (sock, buff, "250", opts))
	{
	  fprintf (stderr, "%s failed\n", buff);
	  _exit (1);
	}
    }
  /* DATA and search for 354 */
  if (send_wait (sock, "data\r\n", "354", opts))
    _exit (1);
  /* send the mail */
  if (send_wait (sock, opts->msg, NULL, opts))
    _exit (1);
  /* end the mail with '.' andsearch for 250 */
  if (send_wait (sock, "\r\n.\r\n", "250", opts))
    _exit (1);
  /* QUIT */
  //send_wait (sock, "quit\r\n", NULL);
  write(sock, "quit\r\n", strlen("quit\r\n"));
  //close (sock);
  return 0;
}
