# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import string, re
import cfg

class PyScript:
    def __init__(self):
        self.cmt_re = re.compile("(\<solfege-cmt\>).*?(\</solfege-cmt\>)", re.DOTALL)
        self.script_re = re.compile("(\<script\s+type=\"text/solfegescript\"\>)(?P<scr>.*?)\</script\>", re.DOTALL)
        self.script2_re = re.compile("(\<ss\>)(?P<scr>.*?)\</ss\>", re.DOTALL)
    def evaluate(self, txt):
        txt = self.remove_comments(txt)
        txt = self.exec_scripts(txt)
        return txt
        #return self.remove_comments(self.exec_scripts(txt))
    def remove_comments(self, s):
        m = self.cmt_re.search(s)
        while m:
            s = s[:m.start()] + s[m.end():]
            m = self.cmt_re.search(s)
        return s
    def exec_scripts(self, s):
        G = {'get_string': lambda s: cfg.get_string(s)}
        m = self.script_re.search(s)
        while m:
            ret = eval(m.group("scr"), G)
            if ret:
                ret = string.replace(ret, '<', '&lt;')
                ret = string.replace(ret, '>', '&gt;')
            s = s[:m.start()] + str(ret) + s[m.end():]
            m = self.script_re.search(s)
        return s

