;; Settings handler in the 'Choose Language' dialog box

;; Copyright (C) 2004  Sylvain Beucler
;; Copyright (C) 2004  Julien Charles
;; Copyright (C) 2004  Pierre Chtel
;; Copyright (C) 2004  Cyril Rodas

;; This file is part of SpcialK.

;; SpcialK is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SpcialK is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SpcialK; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(module settings
 mzscheme
  (require (lib "string.ss" "mzlib"))
  
  (provide (all-defined))
  (define (make-k-settings jpr-opt)
    (list '*special-k-settings* 0.1 (list 'jpr-opt jpr-opt)))
  (define (get-jpr-opt-setting x)
    (and (k-settings? x)
         (let ((res (assoc 'jpr-opt (cddr x))))
           (if (null? res) #f
               (cadr res)))))
  (define (k-settings? x)
    (and (pair? x) (equal? (car x) '*special-k-settings*)))
  
  (define (k-settings-marshall x)
    (expr->string x))
  (define (k-settings-unmarshall x)
    (read-from-string x))
  (define (k-default-settings)
    '(*special-k-settings* 0.1 (jpr-opt #f))))
