;; SpcialK Classic to Scheme translation

;; Copyright (C) 2004  Sylvain Beucler
;; Copyright (C) 2004  Julien Charles
;; Copyright (C) 2004  Pierre Chtel
;; Copyright (C) 2004  Cyril Rodas

;; This file is part of SpcialK.

;; SpcialK is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SpcialK is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SpcialK; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(module special-k-translator
  mzscheme
  (require "special-k-structs.ss" "settings.ss" 
           "special-k-grammar.ss" "special-k-opt.ss"
	   "basic-translator.ss" "l10n.ss")
  (require (lib "lex.ss" "parser-tools"))

  ;;SpcialK->Scheme translation 
  
  (define dump? #f)
  (define p-out null)
  (define settings #t)
  
  (define (translator program file)
    (define (internal program output)
      (if (or (null? program) (not (pair? program)))
          output
          (let ((entity (car program)))
            (cond ((expr_top?  entity) 
                   ;(printf "~a ~n" entity)
                   
                   (internal (cdr program) 
                             (rhsHandler entity output file)
                             ;(list "original-k-prgm" #f #f #f #f)
                             ))
                  (else ;(fonction? (car entity)) 
                   (let* ((clauses (get_clauses entity))
                          (pos (get_start_pos_clause (car clauses)))
                          (res (fonctionHandler entity output file))
                          )
                     ;(printf "~a ~n"a)
                     
                     (internal (cdr program) res)))))))
    
    ;(else '())))));(error "error during translation: unknown entity!" entity))))))
    (begin (piHandler program) 
           (reverse (internal program '()))))
  
  ;;intermediate structure's composants handlers
  
  ;no output argument, cause it ain't needed !
  (define (piHandler entity)
    (cond ((dumpModePI? entity)
           (set! dump? "a.scm")
           (if dump?
               (call-with-output-file "a.scm" ;(cadddr entity) 
                 
                 (lambda (descriptor)
                   (set! p-out descriptor))
                 'replace)))
          (else (void))));(error "error during translation: unknown pi!" entity))))
  
  (define (dumpModePI? entity) #f)
 
  
  (define (fonctionHandler entity output file)
    ;; donne le code des clauses d'une fun...
    ; fun-name le nom de la fonction
    ; fun-aux le nom de la fonction auxiliaire (fonction interne  la fonction
    ; clauses la liste de clauses
    ; nb-args le nombre d'arguments de la fonction
    ; cont le nom de la variable de continuation
    (define (get-fun-code fun-name fun-aux clauses  nb-args cont done match-res) 
      ; regroupe les clauses ayant le mme nombre d'arguments. L est la liste des clauses  regrouper
      ; res et suite doivent tre '()
      ; retourne (res . suite) o res est un ensemble de clauses regroupes
      ; et suite le reste des clauses non regroupes
      (define (regroupe-clauses L res suite) 
        (cond ((null? L) (cons res suite))
              ((null? res) (regroupe-clauses (cdr L) (cons (car L) res) suite))
              ((equal? (get_args (car L)) (get_args (car res)))
               (regroupe-clauses (cdr L) (cons (car L) res) suite))
              (else (regroupe-clauses (cdr L) res (cons (car L) suite)))))
      
      ; donne le code du if: L est la liste de clauses  mettre dans le if
      ; var est le nom du fail dans le match et cont le nom de la variable de continuation
      ; done la variable pour indiquer que c fait
      (define (get-if-code L var cont done res)
        (define (get-call/cc-code cont-sym done-sym else-exec normal-exec)
          (let ((k (gensym)))
            `(begin (call/cc (lambda(,k) (set! ,cont-sym (cons ,k ,cont-sym))
                               (set! ,done-sym #t) ,else-exec)) ,normal-exec)))
        (define (get-lists clauses guards exprs)
          (if (null? clauses)
              (cons guards exprs)
              (get-lists (cdr clauses) 
                         (cons (get-guard-code fun-name fun-aux (get_garde (car clauses)) nb-args) 
                               guards) 
                         (cons (get-expr-code fun-name fun-aux (get_partie_droite (car clauses)) nb-args)
                               exprs))))
        (define (if-interne guards exprs)
          (cond ((null? guards) `(,var))
                ((eq? (length L) 2)
                 (let* ((guard1 (car guards))
                        (guard2 (cadr guards))
                        (expr1 (car exprs))
                        (expr2 (cadr exprs)))
                   (if (or (equal? guard1 `(not ,guard2))
                           (equal? guard2 `(not ,guard1)))
                       `(if ,guard1 
                            ,(get-call/cc-code cont done `(,var) `(set! ,res ,expr1))
                            ,(get-call/cc-code cont done `(,var) `(set! ,res ,expr2)))
                       (let ((match-b-code `(if ,guard2 
                                                ,(get-call/cc-code cont done `(,var) `(set! ,res ,expr2))
                                                (,var)))
                             (match-b-sym (gensym)))
                         `(let ((,match-b-sym (lambda () ,match-b-code)))
                            (if ,guard1 
                                ,(get-call/cc-code cont done `(,match-b-sym) `(set! ,res ,expr1))
                                (,match-b-sym)))))))
                (else
                 (let* ((match-b-code (if-interne (cdr guards) (cdr exprs)))
                        (match-b-sym (gensym))
                        (guard1 (car guards))
                        (expr1 (car exprs)))
                   `(let ((,match-b-sym (lambda () ,match-b-code)))
                      (if ,guard1 
                          ,(get-call/cc-code cont done `(,match-b-sym) `(set! ,res ,expr1))
                          (,match-b-sym)))))))
        (define (build-let L) 
          (if (null? L)
              '()
              (let ((curr (car L)))
                (cons (list (cadr curr) (car curr)) (build-let (cdr L))))))
        (let* ((clauses-guards-list (get-lists L '() '()))
               (facteurs (factorization (cdr clauses-guards-list)))
               (defs-let (car facteurs)) 
               (guards (car clauses-guards-list))
               (exprs (cadr facteurs)))
          (if (null? defs-let)
              (if-interne guards exprs)
              `(let ,(build-let defs-let) ,(if-interne guards exprs)))))
      ; corps de get-fun-code
      (let* ((res (regroupe-clauses clauses '() '()))
             (suite (cdr res))
             (pareils (car res)))
        (if (null? pareils) `((_'()))
            (let ((var (gensym)))
              `((,(get-match-code fun-name fun-aux (get_args (car pareils))  nb-args)
                  (=> ,var) (begin ,(get-if-code pareils var cont done match-res)))
                ,@(get-fun-code fun-name fun-aux suite  nb-args cont done match-res))))))
    ;; le dbut de la fonction principale (fonctionHandler...)
    (let* ((nb-args (get_nb_args entity))
           (clauses (get_clauses entity))
           (clauses-args (generate-args nb-args))
           (fun-name (get_nom entity))
           (param-aux (gensym))
           (cont (gensym))
           (cont-save (gensym))
           (done (gensym))
           (res (gensym))
           (func (let* ((old-fun (gensym))
                        (fun-aux (gensym))
                        (L (gensym))
                        (match-code `(match (car ,L)
                                       ,@(get-fun-code fun-name fun-aux
                                                       clauses nb-args cont done res))))
                   ;(display match-code)
                   ;(display (expand match-code))
                   `(let  ((,old-fun ,fun-name))
                      (set! ,fun-name 
                            (lambda ,L
                              (define ,fun-aux
                                (lambda ,L
                                  (let* ((,cont '())
                                         (,done #f)
                                         (,res '()))
                                    ,match-code
                                    (cond ((= (length ,cont) 1) 
                                           (let ((,cont-save (car ,cont)))
                                             (set! ,cont '())
                                             (,cont-save)))
                                          ((> (length ,cont) 1) 
					   (error 
					    (localized-message 'translator-non-unique-match
							       ,(symbol->string fun-name)
							       ,(number->string nb-args)
							       (number->string (length ,cont))
							       (car ,L))))
                                          ((not ,done)
                                           (error
					    (localized-message 'translator-no-match
							       ,(symbol->string fun-name)
							       ,(number->string nb-args)
							       (car ,L))))
                                          (else ,res)))))
                              (if (= (length ,L) ,nb-args)
                                  (,fun-aux ,L)
                                  (apply ,old-fun ,L)))))))
           (pre-funk (let ((args (gensym)))
                       `(define ,fun-name 
                            (with-handlers 
                                ((exn:variable? (lambda exn
                                                  (lambda ,args
                                                    (error 
                                                     (localized-message 'translator-undefined-function
									,(symbol->string fun-name)
									(number->string (length ,args))
									,args))))))
                              (eval ',fun-name))))))
      ;(printf "~a~n" pre-funk)
      ;(printf "~a~n" func)
      ;(write pre-funk)
      ;(write func)
      (let ((pos (get-pos-fun-span entity)))
        `(,(datum->syntax-object #f func (list file (position-line (car pos)) 
                                               (position-col (car pos))
                                               (position-offset (car pos))
                                               (add1 (- (position-offset (cdr pos)) 
                                                        (position-offset (car pos))))) #f)
           ,(datum->syntax-object #f pre-funk 
                                  (list file (position-line (car pos)) 
                                        (position-col (car pos))
                                        (position-offset (car pos))
                                        (add1 (- (position-offset (cdr pos)) 
                                                 (position-offset (car pos)))))#f)
           . ,output))))
  

  
  
  (define (special-k->scheme op file s)
    (set-opt-jpr-enabled (get-jpr-opt-setting s))
    (translator (special-k-parser op file) file))
  
  (provide special-k->scheme)
  
  ;global-dict
  
  ;semantic_errors
  ;(translator global-dict)
  )
;
;(define truc
;  (string-append 
;   "{1, 2, 3} [0 <-> 1]."
;
;
;
;;2 + 4.
;;n < m -> print(n, m) = print(n + 1, m, fac(n));
;;n >= m -> print(n, m) = void().
;;print(n, m, fun) = begin(display(fac(n)), newline(), print(n, m)).
;;print(1, 20).
;;n > 1 -> foo(n, 3) = 2;
;;n == 3 -> foo(n, 3) = 2;
;;n == 2 -> foo(n, 3) = 2;
;;foo(2, 3) = 3.
;;foo(2, 3).
;   ))
;(require special-k-translator)
;;(display truc)
;
;(special-k->scheme (open-input-string truc) "hello")
