;; Bindings with DrScheme so as to integrate SpcialK as a new
;; language

;; Copyright (C) 2004  Sylvain Beucler
;; Copyright (C) 2004  Julien Charles
;; Copyright (C) 2004  Pierre Chtel
;; Copyright (C) 2004  Cyril Rodas

;; This file is part of SpcialK.

;; SpcialK is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SpcialK is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SpcialK; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(module tool mzscheme
  (require (lib "tool.ss" "drscheme")
           (lib "pretty.ss" "mzlib")
           (lib "unitsig.ss")
           (lib "string.ss" "mzlib")
           (lib "class.ss")
           (lib "mred.ss" "mred")
           (lib "embed.ss" "compiler")
	   (lib "string-constant.ss" "string-constants"))
  (require "private/fast-k-translator.ss"
           "private/special-k-translator.ss"
           "private/special-k-gui.ss"
           "private/settings.ss"
	   "private/l10n.ss"
           "lib.ss")
  (provide tool@)
  
  
  (define tool@
    (unit/sig drscheme:tool-exports^
      (import drscheme:tool^)
      
      ;; Fonctions d'init d'un tool...
      (define (phase1) (void))
      (define (phase2) 
        (drscheme:language-configuration:add-language
         (make-object special-k-classic-lang%))
        (drscheme:language-configuration:add-language
         (make-object special-k-light-lang%)))
      
      ;; Fonction de cration du mode 'special-k'
      (define (make-mode)
        (drscheme:modes:add-mode (localized-message 'text-mode)
                                 mode-surrogate
                                 repl-submit 
                                 matches-language)
        (register-colors))
      
      (make-mode)

      
      ;; La classe reprsentant le langage
      (define special-k-classic-lang%
        (class* object% (drscheme:language:language<%>)
          (define choice-box (default-settings))
          (define/public (config-panel parent)
            (let* ((canvas (new group-box-panel% 
                                (label (localized-message 'options-title))
                                (parent parent)
                                (alignment '(left center))))
                   (choice (new check-box% (label (localized-message 'option-call-internal)) (parent canvas) 
                                (callback (lambda (x y) '())))))
              (send choice set-value (get-jpr-opt-setting choice-box))
                   
              (case-lambda
                [()
                 (make-k-settings (send choice get-value))]
                [(settings)
                 (send choice set-value (get-jpr-opt-setting settings))])))
                       
          (define/public (default-settings) 
            (k-default-settings))
          (define/public (default-settings? x) 
            (equal? x (default-settings)))
          (define/public (marshall-settings x) 
            (if (k-settings? x)
                (k-settings-marshall x)
                (k-settings-marshall (default-settings))))
          (define/public (unmarshall-settings x)
            (let ((expr (k-settings-unmarshall x)))
              (if (k-settings? expr)
                  expr
                  (default-settings))))
          ;; Fonction de traduction du code k
          (define/public (front-end input settings canvas)
            (error-print-source-location #f)
            (let ((text (drscheme:language:text/pos-text input)))
              (let ((res (special-k->scheme 
                          (open-input-string
                           (send text
                                 get-text
                                 (drscheme:language:text/pos-start input)
                                 (drscheme:language:text/pos-end input)))
                          text settings)))
                (lambda () (if (null? res)
                               eof
                               (if (pair? res)
                                   (let ((tmp (car res) ))
                                     (set! res (cdr res))
                                     (namespace-syntax-introduce tmp))
                                   (let ((tmp res))
                                     (set! res '())
                                     tmp)))))))
          ;; Fonctions de traduction du code SpecialK:
          (define/public (front-end/complete-program input settings teachpack-cache) 
            (front-end input settings drscheme:unit:definitions-canvas%))
          (define/public (front-end/interaction input settings teachpack-cache) 
            (front-end input settings drscheme:unit:interactions-canvas%))
          
          
          (define/public (get-style-delta) #f)
          (define/public (get-language-position)
	    (list (string-constant experimental-languages)
		  (localized-message 'language-name)
		  (localized-message 'classic-name)))
          (define/public (order-manuals x) 
            (values 
             (list "drscheme" "tour" "help")
             #f))
          (define/public (get-language-name) (localized-message 'classic-name))
          (define/public (get-one-line-summary) 
            (localized-message 'classic-summary))
          (define/public (get-language-url) #f)
          (define/public (get-language-numbers) (list 1000 100 10))
          (define/public (get-teachpack-names) null)
 
          (define (get-dynamic-require lib-list)
            (if (null? lib-list) '()
                `((dynamic-require ',(car lib-list) #f)
                  ,@(get-dynamic-require (cdr lib-list)))))
          
          (define (get-ns-require lib-list)
            (if (not (null? lib-list))
                (begin (namespace-require `',(car lib-list))
                  (get-ns-require (cdr lib-list)))))
          ;; L'environnement d'excution du code k
          (define/public (on-execute settings run-in-user-thread) 
            (dynamic-require '(lib "lib.ss" "specialk") #f)
            (run-in-user-thread 
              (lambda ()
                (namespace-require 'mzscheme)
                (namespace-require '(lib "lib.ss" "specialk"))
                (error-display-handler 
                 (drscheme:debug:make-debug-error-display-handler (error-display-handler)))
                (current-eval 
                 (drscheme:debug:make-debug-eval-handler (current-eval)))
                (error-print-source-location #f))))
          
 
          ;; Les fonctions pour afficher les rsultats du code k
          (define/public (render-value value settings port port-write)
            (nasty-print value port))
          (define/public (render-value/format value settings port port-write width)
            (pretty-print-columns width)
            (nasty-print value port))
          
	  (define/public (create-executable settings parent src-file cache) 
            (message-box (localized-message 'classic-executable-error-title)
                         (localized-message 'classic-executable-error)
			 parent))
      
          (super-instantiate ())))
      
      
       (define special-k-light-lang%
        (class* special-k-classic-lang% ()
          ;; Fonction de traduction du code k
          (define/override (front-end input settings canvas)
            (error-print-source-location #f)
            (let ((text (drscheme:language:text/pos-text input)))
              (let ((res (fast-k->scheme 
                          (open-input-string
                           (send text
                                 get-text
                                 (drscheme:language:text/pos-start input)
                                 (drscheme:language:text/pos-end input)))
                          text settings)))
                (lambda () (if (null? res)
                               eof
                               (if (pair? res)
                                   (let ((tmp (car res) ))
                                     (set! res (cdr res))
                                     (namespace-syntax-introduce tmp))
                                   (let ((tmp res))
                                     (set! res '())
                                     tmp)))))))
   
          (define/override (get-language-position)
	    (list (string-constant experimental-languages)
		  (localized-message 'language-name)
		  (localized-message 'light-name)))
          (define/override (get-language-name) (localized-message 'light-name))
          (define/override (get-one-line-summary) 
	    (localized-message 'light-summary))
          (define/override (get-language-numbers) (list 1000 100 10))
     
	  (define/override (create-executable settings parent src-file cache) 
          	    (let ([dst-file (drscheme:language:put-executable
          			     parent src-file #f #f
          			     (string-constant save-a-mzscheme-stand-alone-executable))])
          	      (when dst-file
          		(let* ([src (open-input-file src-file)]
                               [code (fast-k->scheme src src settings)])
          		  (make-embedding-executable dst-file
          					     #t #f
          					     '((#f (lib "lib.ss" "specialk")))
          					     null
          					     (compile
          					     `(begin (require (lib "lib.ss" "specialk")) ,@code))
          					     (list "-mvq"))))))
      
          (super-instantiate ()))))))
