! srend_namelist_tiles.F90

! This is designed to handle cubical data volumes of dimension Vdim^3

! this file generates executable called by srend_namelist_tiles.py

! NOTE: OpenMP is optional below

! build tiles  : mpif90 Srend.F90 -O3 -fopenmp -c
!              : gcc sleep.c -c
!              : mpif90 srend_namelist_tiles.F90 Srend.o sleep.o -O3 -fopenmp -o srend_namelist_tiles

! set threads  : export OMP_NUM_THREADS=4 ! or 1, or 2, ...

program srend_namelist_tiles

#ifdef _OPENMP
      USE OMP_LIB
#endif
      USE Srend
      
      IMPLICIT none

      include 'mpif.h'

      integer :: srend_nV, srend_nV_out
      integer :: srend_Vdim
      real :: srend_E(1:3),srend_V(1:3),srend_U(1:3)
      real :: srend_Alpha,srend_Beta
      real :: srend_EyeRight
      real :: srend_clipx0,srend_clipx1,srend_clipy0
      real :: srend_clipy1,srend_clipz0,srend_clipz1
      real :: srend_pclip1
      real :: srend_pt(1:3), srend_pt_r
      real :: srend_clip0, srend_clip1
      integer :: srend_nsh
      integer :: srend_perspective, srend_srendtype
      real :: srend_dt
      character*256 :: srend_bytedata_filename ! a trailing '/' if multiple MPI blocks
      character*1,dimension(:,:,:),allocatable :: bytedata ! data array for rendering
      integer :: srend_XN, srend_YN, srend_ZN
      integer :: srend_Bd
      integer :: srend_iX, srend_iY, srend_iZ
      integer :: srend_W, srend_H
      integer :: srend_nR
      integer :: srend_cotab_offset
      character*200 :: srend_filenames
      integer :: srend_tiles_right, srend_tiles_down
!      integer,save :: srend_n_rgb_knot, srend_n_alpha_knot
!      character*256,save :: srend_alpha_knot(1:32), srend_rgb_knot(1:32)
      integer,dimension(:,:),allocatable :: srend_TARGid
      
      namelist /namelist_srend/  srend_nV, srend_nV_out,   & 
            srend_Vdim, srend_E, srend_V,                  & ! Vdim^3 volume
            srend_U, srend_alpha, srend_beta,              &
            srend_eyeright,                                &
            srend_clipx0, srend_clipx1,                    &
            srend_clipy0, srend_clipy1,                    &
            srend_clipz0, srend_clipz1,                    &
            srend_pclip1, srend_pt, srend_pt_r,            &
            srend_clip0, srend_clip1,                      &
            srend_nsh, srend_perspective, srend_srendtype, &
            srend_dt,                                      &
            srend_bytedata_filename,                       &
            srend_XN, srend_YN, srend_ZN,                  & ! dimension of each block in volume, all the same
            srend_Bd,                                      & ! uniform boundary
            srend_iX, srend_iY, srend_iZ,                  & ! MPI topology: iNX*iNY*iNZ workers = MPI ranks
            srend_W, srend_H,                              &
            srend_nR, srend_cotab_offset,                  &
            srend_filenames,                               &
            srend_tiles_right, srend_tiles_down!,           &
!                                srend_n_alpha_knot, srend_alpha_knot,          &
!                                srend_n_rgb_knot, srend_rgb_knot,              &

      namelist /namelist_srend_targid/ srend_TARGid
            

      integer :: MYer, MYid, MYn

      integer :: vdim
      integer :: xn, yn, zn, bd ! dimensions of each block and uniform boundary
      integer :: inx, iny, inz  ! offset for each block

      integer :: nx, ny, nz     ! blocks in each dimension
      integer :: nb             ! number of blocks
      integer :: i              ! counter
      character*256 :: fname, fnum
! --------------------------------------------------------------------

      call MPI_INIT( MYer )
      call MPI_COMM_RANK( MPI_COMM_WORLD, MYid, MYer )
      call MPI_COMM_SIZE( MPI_COMM_WORLD, MYn, MYer )

      open(unit=20,file='namelist.srend',form='formatted',status='old',access='sequential')
      read(20,nml=namelist_srend) ! get rendering parameters
! now, allocate srend_TARGid and read it in
      allocate( srend_TARGid(1:srend_tiles_right,1:srend_tiles_down) )
      read(20,nml=namelist_srend_targid)
      close(20)
      
      print *,'MYid=', MYid, 'targid=', srend_TARGid
      
! working info for rendering
      vdim = srend_Vdim
      xn = srend_XN; yn = srend_YN; zn = srend_ZN ! dimension of block in each direction
      bd = srend_Bd                               ! boundary thickness, uniform

      nx = vdim/xn; ny = vdim/yn; nz = vdim/zn    ! num blocks in each dimension
      nb = nx*ny*nz                               ! total number of blocks
      
 
! allocate array to hold 1 block
      allocate( bytedata(1-bd:xn+bd,1-bd:yn+bd,1-bd:zn+bd) )
      
      do i= 0+MYid, nb-1, MYn
      
! open and load data file
      write(fnum,'(I6.6)') i
      fname = trim(srend_bytedata_filename) // trim(fnum)
      
      open(unit=21,file=trim(fname),status='unknown',access='stream')
      read(21) bytedata
      close(21)
      
!determine offset for block
      inz = xn * (i / (nx*ny))
      iny = yn * (mod(i,nx*ny) / nx)
      inx = zn * (mod(i,nx))

!$omp parallel default(shared)
      call srend_render_load(srend_nV,srend_nV_out, & ! view index: nV and nV_out
         srend_Vdim,                           & ! usually max dimension of entire volume
         srend_E,                              & ! eye
         srend_V,                              & ! Ev
         srend_U,                              & ! Up
         srend_alpha, srend_beta,              & ! alpha, beta
         srend_eyeright,                       & ! stereo right
         srend_clipx0,srend_clipx1,            & ! x plane near and far clip
         srend_clipy0,srend_clipy1,            & ! y plane near and far clip
         srend_clipz0,srend_clipz1,            & ! z plane near and far clip
         srend_pclip1,                         & ! far polar clip
         srend_pt, srend_pt_r,                 & ! center(x,y,z) and radius of sphere to clip about
         srend_clip0, srend_clip1,             & ! spherical: clip near, clip far
         srend_nsh,                            & ! nshells
         srend_perspective,srend_srendtype,    & ! perspective=1, srendtype=0
         srend_dt,                             & ! dt sampling depth in cell widths
         bytedata,                             & ! data bytes
         xn,yn,zn,                             & ! data dimensions x,y,z
         bd,                                   & ! boundary
         inx,iny,inz,                          & ! xyz offsets
         srend_W,srend_H,                      & ! W, H
         srend_nR,(/srend_cotab_offset/),      & ! number of vars to render, offsets color table
!         srend_n_alpha_knot,srend_alpha_knot,  & ! number alpha keys, and alpha keys
!         srend_n_rgb_knot,srend_rgb_knot,      & ! number rgb keys, and rgb keys
         srend_filenames,                      & ! output filenames
         srend_tiles_right,srend_tiles_down,   & ! tiling geometry
         srend_TARGid)                           ! MPI rank of target
!$omp end parallel

      end do


      call srend_render_flush(srend_nV)
      
      call MPI_barrier(MPI_COMM_WORLD,MYer)
      call srend_tile_finish(srend_nV, srend_nV_out)

      call MPI_barrier(MPI_COMM_WORLD,MYer)
      call MPI_finalize(MYer)

end program srend_namelist_tiles


