! t_data_ipy.F90
! -----------------------------------------------------------------------
! This is free and unencumbered software released into the public domain.
!
! Anyone is free to copy, modify, publish, use, compile, sell, or 
! distribute this software, either in source code form or as a compiled 
! binary, for any purpose, commercial or non-commercial, and by any 
! means.
!
! In jurisdictions that recognize copyright laws, the author or authors 
! of this software dedicate any and all copyright interest in the 
! software to the public domain. We make this dedication for the benefit 
! of the public at large and to the detriment of our heirs and 
! successors. We intend this dedication to be an overt act of 
! relinquishment in perpetuity of all present and future rights to this 
! software under copyright law.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
! EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
! MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
! IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
! OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
! ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
! OTHER DEALINGS IN THE SOFTWARE.
!
! For more information, please refer to http://unlicense.org/
! ----------------------------------------------------------------------

! This creates a data directory with NB^3 blocks of data
! spanning a NNN^3 volume.  Data is set by formula.

! This also creates a single data block for the ipython srend_namelist
! example.


! 0. Set the NNN and NB definitions just below
! define voxel dim for entire volume at coarsest level
#define NNN 256
! number blocks per dimension
#define NB 8

! 1. compile then run:
!    gfortran  t_data_ipy.F90 -O3 -o t_data_ipy
!    ./t_data_ipy



! ---- these will calculate the rest ---------------------------------
! wid of data block, without boundaries
#define NN NNN/NB
! totaL NUMBER OF BLOCKS
#define NBB NB*NB*NB

! ********************************************************************
      program t_data

      IMPLICIT NONE

      character*1,dimension(0:NN+1,0:NN+1,0:NN+1) :: fv        ! data array, little blocks for MPI tests
      character*1,dimension(0:NNN+1,0:NNN+1,0:NNN+1) :: fv_smp ! single block for SMP tests
      character*60 :: fname ! output filenames
! timing
      integer*8 it1, it2, itc, total0, total1
      real*4 rc
! AMR data and loop vars
      integer*4 :: jj,i,j,k,tt
      real*4 :: x,y,z,cr
! block offsets
      integer*4 :: ix,iy,iz
! ccccccccc end variable declarations cccccccccccccccccccccccccccccccc

      call system_clock(it1,itc)
      rc = 1.0 / itc
      
!make directory
      write(fname,'("mkdir -p Blocks",I6.6,"Vdim",I6.6)') NBB,NNN
      call system(trim(fname))
      
! make data, little blocks for MPI test
      do jj=1,NBB
          ix = mod(jj-1,NB)           ! block offset in zero based form
          iy = mod(jj-1,NB*NB) / NB
          iz = (jj-1) / (NB*NB)  
          
          do k=0, NN+1
            z = 1. - (2.* (k+NN*iz)) /NNN
            do j=0, NN+1
              y = 1. - (2.* (j+NN*iy))/NNN
              do i=0, NN+1
                x = 1. - (2.*(i+NN*ix))/NNN
                cr = 4.0 + min(1.,1./(x*x+y*y+z*z + .1)**4)* & 
                     (124.+124./3.*(sin(1./(x*y+.1))+cos(1./(x+y*z+.1))+sin(1.0/(z*x+y+.1))**2) )
                fv(i,j,k) = char(floor(cr))
              end do
            end do
          end do 
          
          write(fname,'("Blocks",I6.6,"Vdim",I6.6,"/",I6.6)') NBB,NNN,jj-1
          open(unit=111,status='unknown', file=fname,access='stream')
          write(111) fv
          close(111)
      end do
      
      do k=0, NNN+1
         z = 1. - (2.* k) /NNN
         do j=0, NNN+1
            y = 1. - (2.* j)/NNN
            do i=0, NNN+1
               x = 1. - (2.*i)/NNN
               cr = 4.0 + min(1.,1./(x*x+y*y+z*z + .1)**4)* & 
                  (124.+124./3.*(sin(1./(x*y+.1))+cos(1./(x+y*z+.1))+sin(1.0/(z*x+y+.1))**2) )
               fv_smp(i,j,k) = char(floor(cr))
            end do
         end do
      end do 
      
      write(fname,'("Vdim",I6.6,".raw")') NNN
      open(unit=112,status='unknown', file=fname,access='stream')
      write(112) fv_smp
      close(112)
      

      call system_clock(it2)
      total1 = it2
      print *,'total runtime =', (it2-it1)*rc, 'seconds'
      

      end program t_data! program main
! ********************************************************************

