#!/usr/bin/env python

# this file is t_python_call.py

# build        : gfortran Srend.F90 -DSREND_NOMPI -fPIC -shared -o Srend.so
# check names  : nm  Srend.so

from Tkinter import *
from ctypes import *

# ----- open the library first
try:
	srend = CDLL("./Srend.so") #load
except (NameError,OSError): print "Srend.so not found"
else: print "loaded Srend.so"

# ----- variables to pass to srend_render
nV_in = c_int(1)
nV_out = c_int(1)
Vdim = c_int(39)

VecFloat = c_float*3
E = VecFloat(0.5,0.5,1.0)
V = VecFloat(0.0,0.0,-1.0)
U = VecFloat(0.0,1.0,0.0)

Alpha = c_float(90.0)
Beta = c_float(90.0)
EyeRight = c_float(0.0)
clipx0 = c_float(-10.0)
clipx1 = c_float(10.0)
clipy0 = c_float(-10.0)
clipy1 = c_float(10.0)
clipz0 = c_float(-10.0)
clipz1 = c_float(10.0)
pclip1 = c_float(180.0)
pt = VecFloat(0.5,0.5,0.5)
pt_r = c_float(0.5)
clip0 = c_float(0.5)
clip1 = c_float(10.0)
nsh = c_int(1)

perspective = c_int(1)
srendtype = c_int(0)
dt = c_float(0.5)

# 41^3 = 68921
ByteArray = c_byte*68921
bytedata = ByteArray()

XN = c_int(39)
YN = c_int(39)
ZN = c_int(39)
Bd = c_int(1)
iNX = c_int(0)
iNY = c_int(0)
iNZ = c_int(0)

W = c_int(512)
H = c_int(512)
nR = c_int(1)
offset_cotab = c_int(1)

#NOTE 2: pass the c_type pointer for strings, not a byref
filename_stringin = 'nucleon.ppm, '
filenames = c_char_p(filename_stringin)

tiles_right = c_int(1)
tiles_down = c_int(1)
TARGid = c_int(0)

# ---------------- open and read the data file ------------------
FVhiret = open("nucleon.raw","rb")
FVhiret.readinto(bytedata)
FVhiret.close()

# render, a very long parameter list
srend.__srend_MOD_srend_render(byref(nV_in),byref(nV_out),byref(Vdim),byref(E),
   byref(V),byref(U),byref(Alpha), byref(Beta),byref(EyeRight),
   byref(clipx0),byref(clipx1),byref(clipy0),byref(clipy1),
   byref(clipz0),byref(clipz1),byref(pclip1),byref(pt),byref(pt_r),
   byref(clip0),byref(clip1),byref(nsh),
   byref(perspective),byref(srendtype),byref(dt),
   byref(bytedata),byref(XN),byref(YN),byref(ZN),byref(Bd),byref(iNX),
   byref(iNY),byref(iNZ),byref(W),byref(H),byref(nR),
   byref(offset_cotab),filenames,byref(tiles_right),byref(tiles_down),
   byref(TARGid) )

# ********** create GUI *************************************
root = Tk()

open_screen = PhotoImage(file='nucleon.ppm')
im_b = Label(image=open_screen).grid(row=0,column=0)

def quitter():
	quit()
quit_but = Button(root,text="Quit", command=quitter).grid(row=1,column=0)
# ************************** wait for user requests ************************************
root.mainloop()
