/* sleep.c */
/* --------------------------------------------------------------------
 This is free and unencumbered software released into the public domain.

 Anyone is free to copy, modify, publish, use, compile, sell, or 
 distribute this software, either in source code form or as a compiled 
 binary, for any purpose, commercial or non-commercial, and by any 
 means.

 In jurisdictions that recognize copyright laws, the author or authors 
 of this software dedicate any and all copyright interest in the 
 software to the public domain. We make this dedication for the benefit 
 of the public at large and to the detriment of our heirs and 
 successors. We intend this dedication to be an overt act of 
 relinquishment in perpetuity of all present and future rights to this 
 software under copyright law.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
 IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
 OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
 OTHER DEALINGS IN THE SOFTWARE.

 For more information, please refer to http://unlicense.org/
 ------------------------------------------------------------------- */
/* This routine is used by srend because Fortran does not     */
/* have a standard split-second sleep interval.  The sleep    */
/* call does the crucial function of releasing the running    */
/* application so that the MPI daemon can do some processing. */
/* This context switch neables good behavior where srend is   */
/* testing to complete prior MPI_isend calls.                 */
/* -------- Ted Wetherbee : ted@fdltcc.edu ------------------ */
/* sleep_u1: sleep for 1 micro second */
/* sleep_0 : yields time slice        */
/* sleep_n1: sleep for 1 nano second  */
#include <unistd.h>
#include <time.h>
int sleep_u1_     (){ usleep(1)            ; return 0;}
int sleep_0_      (){ sleep(0)             ; return 0;}
int sleep_n1_     (){ struct timespec tim,rem; tim.tv_sec = 0; tim.tv_nsec = 1; 
                      nanosleep(&tim, &rem); return 0;}
                      
                      