/*
 * $Id: st-stream-bag.h,v 1.44 2004/03/27 21:34:29 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_STREAM_BAG_H
#define _ST_STREAM_BAG_H

#include <gtk/gtk.h>
#include "st-stream-api.h"
#include "st-handler-api.h"
#include "st-category-bag.h"

#define ST_TYPE_STREAM_BAG		(st_stream_bag_get_type())
#define ST_STREAM_BAG(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_STREAM_BAG, STStreamBag))
#define ST_STREAM_BAG_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_STREAM_BAG, STStreamBagClass))
#define ST_IS_STREAM_BAG(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_STREAM_BAG))
#define ST_IS_STREAM_BAG_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_STREAM_BAG))
#define ST_STREAM_BAG_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_STREAM_BAG, STStreamBagClass))

#define ST_STREAM(bag) \
  ((bag)->stream)
#define ST_STREAM_BAG_IS_FROM(bag, name) \
  (! strcmp((bag)->category_name, (name)))

typedef struct _STStreamBagPrivate	STStreamBagPrivate;

typedef struct
{
  GObject		object;

  STStream		*stream;
  STHandler		*handler;

  GtkTreeIter		iter;

  STStreamBagPrivate	*priv;
} STStreamBag;

typedef struct
{
  GObjectClass		parent_class;

  /* signals */
  void (*changed)	(STStreamBag *bag);
  void (*state_changed)	(STStreamBag *bag, gboolean running);
  void (*deleted)	(STStreamBag *bag);
} STStreamBagClass;

GType		st_stream_bag_get_type		(void);

STStreamBag	*st_stream_bag_new		(STHandler         *handler);
STStreamBag	*st_stream_bag_new_from_stream	(STHandler         *handler,
						 STStream          *stream);

void		st_stream_bag_set_running	(STStreamBag       *bag,
						 gboolean          running);

/* event wrappers */

void		st_stream_bag_get_field		(STStreamBag       *bag,
						 STHandlerField    *field,
						 GValue            *value);
void		st_stream_bag_set_field		(STStreamBag       *bag,
						 STHandlerField    *field,
						 const GValue      *value);
void		st_stream_bag_get_stock_field	(STStreamBag       *bag,
						 STHandlerStockField stock_field,
						 GValue            *value);

gboolean	st_stream_bag_resolve		(STStreamBag       *bag,
						 GError            **err);
gboolean	st_stream_bag_tune_in_multiple	(GSList            *bags,
						 GError            **err);
gboolean	st_stream_bag_tune_in		(STStreamBag       *bag,
						 GError            **err);
gboolean	st_stream_bag_record		(STStreamBag       *bag,
						 GError            **err);
gboolean	st_stream_bag_browse		(STStreamBag       *bag,
						 GError            **err);

gboolean	st_stream_bag_modify		(STStreamBag       *bag,
						 GSList            *fields,
						 GSList            *values,
						 GError            **err);
gboolean	st_stream_bag_delete		(STStreamBag       *bag,
						 GError            **err);

#endif /* _ST_STREAM_BAG_H */
