/*
 * $Id: sgtk-blinking-image.h,v 1.4 2004/03/08 05:54:51 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SGTK_BLINKING_IMAGE_H
#define _SGTK_BLINKING_IMAGE_H

#include <gtk/gtk.h>

#define SGTK_TYPE_BLINKING_IMAGE		(sgtk_blinking_image_get_type())
#define SGTK_BLINKING_IMAGE(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), SGTK_TYPE_BLINKING_IMAGE, sGtkBlinkingImage))
#define SGTK_BLINKING_IMAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), SGTK_TYPE_BLINKING_IMAGE, sGtkBlinkingImageClass))
#define SGTK_IS_BLINKING_IMAGE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), SGTK_TYPE_BLINKING_IMAGE))
#define SGTK_IS_BLINKING_IMAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), SGTK_TYPE_BLINKING_IMAGE))
#define SGTK_BLINKING_IMAGE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), SGTK_TYPE_BLINKING_IMAGE, sGtkBlinkingImageClass))

typedef struct _sGtkBlinkingImagePrivate sGtkBlinkingImagePrivate;

typedef struct
{
  GtkImage			image;

  sGtkBlinkingImagePrivate	*priv;
} sGtkBlinkingImage;

typedef struct
{
  GtkImageClass			parent_class;
} sGtkBlinkingImageClass;

GType     sgtk_blinking_image_get_type		(void);

void      sgtk_blinking_image_set_from_pixbuf	(sGtkBlinkingImage  *image,
						 GdkPixbuf          *pixbuf);
void      sgtk_blinking_image_set_blinking	(sGtkBlinkingImage  *image,
						 gboolean           blinking);
GtkWidget *sgtk_blinking_image_new		(void);

#endif /* _SGTK_BLINKING_IMAGE_H */
