/*
 * $Id: st-stream-view.h,v 1.39 2004/03/27 21:48:10 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_STREAM_VIEW_H
#define _ST_STREAM_VIEW_H

#include <gtk/gtk.h>
#include "st-handler.h"
#include "st-stream-menu-items.h"

#define ST_TYPE_STREAM_VIEW		(st_stream_view_get_type())
#define ST_STREAM_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_STREAM_VIEW, STStreamView))
#define ST_STREAM_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_STREAM_VIEW, STStreamViewClass))
#define ST_IS_STREAM_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_STREAM_VIEW))
#define ST_IS_STREAM_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_STREAM_VIEW))
#define ST_STREAM_VIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_STREAM_VIEW, STStreamViewClass))

typedef struct _STStreamViewPrivate STStreamViewPrivate;

typedef struct
{
  GtkTreeView		view;

  STStreamViewPrivate	*priv;
  GtkWidget		*columns_menu;
} STStreamView;

typedef struct
{
  GtkTreeViewClass	parent_class;

  /* signals */
  void (*selection_changed) (STStreamView *view);
} STStreamViewClass;

GType		st_stream_view_get_type		   (void);
GtkWidget	*st_stream_view_new		   (STHandler     *handler);
void		st_stream_view_set_menu_items      (STStreamView  *view,
						    STStreamMenuItems *items);
void		st_stream_view_update_sensitivity  (STStreamView  *view);

void		st_stream_view_select_stream       (STStreamView  *view,
						    STStreamBag   *bag);
void		st_stream_view_present_stream      (STStreamView  *view,
						    STStreamBag   *bag);

gboolean	st_stream_view_can_select_previous (STStreamView  *view);
void		st_stream_view_select_previous     (STStreamView  *view);
gboolean	st_stream_view_can_select_next     (STStreamView  *view);
void		st_stream_view_select_next         (STStreamView  *view);

void		st_stream_view_set_store           (STStreamView  *view,
						    STStreamStore *store);

GSList		*st_stream_view_get_selected_streams	(STStreamView *view);
gboolean	st_stream_view_has_selected_streams	(STStreamView *view);

#endif /* _ST_STREAM_VIEW_H */
