/*
 * $Id: st-settings.c,v 1.27.2.2 2004/05/11 15:40:42 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <stdlib.h>
#include <glib.h>
#include "gettext.h"
#include "st-dialog-api.h"
#include "st-settings.h"
#include "st-transfer.h"
#include "st-shell.h"

/*** variable declarations ***************************************************/

STSettings st_settings;
G_LOCK_DEFINE(st_settings);

/*** API implementation ******************************************************/

const char *
st_settings_get_private_dir (void)
{
  return st_settings.private_dir;
}

/*** private implementation **************************************************/

void
st_settings_init (const char *custom_private_dir)
{
  const char *home;
  
  if (! (home = g_get_home_dir()))
    {
      st_error_dialog(_("A fatal error has occurred."),
		      _("Couldn't find your home directory."));
      exit(1);
    }

  st_settings.private_dir = custom_private_dir
    ? custom_private_dir
    : g_build_filename(home, ".streamtuner", NULL);

  st_settings.config_file = g_build_filename(st_settings.private_dir, "config", NULL);
  st_settings.cache_file = g_build_filename(st_settings.private_dir, "cache", NULL);
  st_settings.accels_file = g_build_filename(st_settings.private_dir, "accels", NULL);
  st_settings.splash_disabled_file = g_build_filename(st_settings.private_dir, "splash-disabled", NULL);
  st_settings.images_dir = g_build_filename(st_settings.private_dir, "images", NULL);

  /*
   * We don't store this setting into the config file because we need
   * it earlier in the initialization phase.
   */
  st_settings.splash_enabled = ! g_file_test(st_settings.splash_disabled_file, G_FILE_TEST_EXISTS);

  st_settings.view_toolbar = TRUE;
  st_settings.view_tabs = TRUE;
  st_settings.view_tab_icons = TRUE;
  st_settings.view_statusbar = TRUE;

  st_settings.save_automatic = FALSE;
  
  st_settings.toolbar_style = ST_SHELL_TOOLBAR_STYLE_GTK;
  st_settings.toolbar_size = ST_SHELL_TOOLBAR_SIZE_GTK;

  st_settings.main_window_width = 600;
  st_settings.main_window_height = 300;

  st_settings.preferences_window_width = -1;
  st_settings.preferences_window_height = -1;

  st_settings.stream_properties_window_width = -1;

  st_settings.selected_preferences_page = 0;

  st_settings.proxy_enabled = FALSE;
  st_settings.proxy_type = ST_TRANSFER_PROXY_HTTP;
  st_settings.proxy_server = NULL;
  st_settings.proxy_port = 8080; /* a good default for a HTTP proxy */

  st_settings.proxy_auth_enabled = FALSE;
  st_settings.proxy_auth_name = NULL;
  st_settings.proxy_auth_password = NULL;

  st_settings.selected_handler_name = NULL;
  
  st_settings.always_refresh = FALSE;
}
