/*
 * $Id: sgtk-util.c,v 1.14.2.3 2004/07/24 16:17:26 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <gtk/gtk.h>
#include "gettext.h"
#include "sgtk-util.h"

/*** function declarations ***************************************************/

static void sgtk_widget_activate_h (GtkWidget *widget, gpointer data);

/*** implementation **********************************************************/

void
sgtk_flush (void)
{
  while (gtk_events_pending())
    gtk_main_iteration();
}

char *
sgtk_translate_func (const char *path, gpointer data)
{
  return _(path);
}

GdkPixbuf *
sgtk_pixbuf_scale (GdkPixbuf *pixbuf, GtkIconSize size)
{
  int width;
  int height;
  gboolean status;

  g_return_val_if_fail(pixbuf != NULL, NULL);

  status = gtk_icon_size_lookup(size, &width, &height);
  g_return_val_if_fail(status == TRUE, NULL);

  return gdk_pixbuf_scale_simple(pixbuf, width, height, GDK_INTERP_BILINEAR);
}

void
sgtk_widget_set_next_widget (GtkWidget *widget, GtkWidget *next)
{
  g_return_if_fail(GTK_IS_WIDGET(widget));
  g_return_if_fail(GTK_IS_WIDGET(next));

  g_object_set_data(G_OBJECT(widget), "focus-next", next);
  g_signal_connect(G_OBJECT(widget), "activate",
		   G_CALLBACK(sgtk_widget_activate_h), next);
}

static void
sgtk_widget_activate_h (GtkWidget *widget, gpointer data)
{
  GtkWidget *next = data;

  while (! GTK_WIDGET_IS_SENSITIVE(next))
    {
      next = g_object_get_data(G_OBJECT(next), "focus-next");
      g_return_if_fail(next != NULL);
    }

  gtk_widget_grab_focus(next);
}

gboolean
sgtk_tree_model_get_iter_last (GtkTreeModel *model, GtkTreeIter *iter)
{
  gboolean status;
  gboolean valid;
  GtkTreeIter tmp_iter;

  g_return_val_if_fail(GTK_IS_TREE_MODEL(model), FALSE);
  g_return_val_if_fail(iter != NULL, FALSE);

  status = valid = gtk_tree_model_get_iter_first(model, &tmp_iter);
  while (valid)
    {
      *iter = tmp_iter;
      valid = gtk_tree_model_iter_next(model, &tmp_iter);
    }

  return status;
}

gboolean
sgtk_tree_model_iter_prev (GtkTreeModel *model, GtkTreeIter *iter)
{
  GtkTreePath *path;
  gboolean status;

  g_return_val_if_fail(GTK_IS_TREE_MODEL(model), FALSE);
  g_return_val_if_fail(iter != NULL, FALSE);
  
  path = gtk_tree_model_get_path(model, iter);
  status = gtk_tree_path_prev(path);
  if (status)
    {
      status = gtk_tree_model_get_iter(model, iter, path);
      g_return_val_if_fail(status == TRUE, FALSE);
    }
  gtk_tree_path_free(path);

  return status;
}

gboolean
sgtk_tree_model_iter_move (GtkTreeModel *model,
			   GtkTreeIter *iter,
			   sGtkDirection direction)
{
  g_return_val_if_fail(GTK_IS_TREE_MODEL(model), FALSE);
  g_return_val_if_fail(iter != NULL, FALSE);
  
  switch (direction)
    {
    case SGTK_PREVIOUS:
      return sgtk_tree_model_iter_prev(model, iter);

    case SGTK_NEXT:
      return gtk_tree_model_iter_next(model, iter);

    default:
      g_return_val_if_reached(FALSE);
    }
}
