/*
 * $Id: st-handler.h,v 1.62.2.1 2004/08/06 00:36:30 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_HANDLER_H
#define _ST_HANDLER_H

#include <gtk/gtk.h>
#include "st-handler-api.h"
#include "st-category-bag.h"
#include "st-stream-bag.h"
#include "st-category-store.h"
#include "st-stream-store.h"

#define ST_HANDLER_HAS_CATEGORIES(handler) \
  ((st_handler_get_flags((handler)) & ST_HANDLER_NO_CATEGORIES) == 0)
#define ST_HANDLER_MUST_CONFIRM_DELETION(handler) \
  ((st_handler_get_flags((handler)) & ST_HANDLER_CONFIRM_DELETION) != 0)

#define ST_HANDLER_EVENT_HAS_RELOAD(handler) 				\
  (st_handler_event_is_bound((handler), ST_HANDLER_EVENT_RELOAD) 	\
   || st_handler_event_is_bound((handler), ST_HANDLER_EVENT_RELOAD_MULTIPLE))
#define ST_HANDLER_EVENT_HAS_TUNE_IN(handler) 					\
  (st_handler_event_is_bound((handler), ST_HANDLER_EVENT_STREAM_TUNE_IN) 	\
   || st_handler_event_is_bound((handler), ST_HANDLER_EVENT_STREAM_TUNE_IN_MULTIPLE))

void		st_handler_complete		(STHandler	*handler);
gboolean	st_handler_validate		(STHandler	*handler,
						 GError		**err);

gboolean	st_handler_reload		(STHandler	*handler,
						 STCategoryBag	*category_bag,
						 GNode		**categories,
						 STStreamStore	**stream_store,
						 GError		**err);

STCategoryStore	*st_handler_get_categories	(STHandler	*handler);

void		st_handler_set_streams		(STHandler	*handler,
						 const char	*category_name,
						 STStreamStore	*streams);
STStreamStore	*st_handler_get_streams		(STHandler	*handler,
						 const char	*category_name);

STCategoryBag	*st_handler_get_stock_category	(STHandler	*handler,
						 const char	*name);

void		st_handler_select_category	(STHandler	*handler);

gboolean	st_handler_event_is_bound	(STHandler	*handler,
						 STHandlerEvent	event);

const char	*st_handler_get_name		(STHandler	*handler);
const char	*st_handler_get_label		(STHandler	*handler);
const char	*st_handler_get_copyright	(STHandler	*handler);
const char	*st_handler_get_description	(STHandler	*handler);
const char	*st_handler_get_home		(STHandler	*handler);
GdkPixbuf	*st_handler_get_pixbuf		(STHandler	*handler);
unsigned int	st_handler_get_flags		(STHandler	*handler);

void		st_handler_set_paned_position	(STHandler	*handler,
						 int		paned_position);
int		st_handler_get_paned_position	(STHandler	*handler);

GSList		*st_handler_get_fields		(STHandler	*handler);
int		st_handler_count_fields		(STHandler	*handler,
						 unsigned int	flags);
void		st_handler_set_fields_sort_index (STHandler	*handler,
						  int		sort_index);
int		st_handler_get_fields_sort_index (STHandler	*handler);
void		st_handler_set_fields_sort_order (STHandler	*handler,
						  int		sort_order);
int		st_handler_get_fields_sort_order (STHandler	*handler);

void		st_handler_add_remarkable_category	(STHandler     *handler,
							 STCategoryBag *category_bag);
void		st_handler_remove_remarkable_category	(STHandler     *handler,
							 STCategoryBag *category_bag);

STCategoryBag	*st_handler_get_selected_category	(STHandler     *handler);

/* events */

gboolean	st_handler_event_reload            (STHandler	*handler,
						    STCategory	*category,
						    GNode	**categories,
						    GList	**streams,
						    GError	**err);
gboolean	st_handler_event_reload_multiple   (STHandler	*handler,
						    GNode	**categories,
						    GHashTable	**streams,
						    GError	**err);
STCategory	*st_handler_event_category_new	   (STHandler	*handler);
void		st_handler_event_category_free	   (STHandler	*handler,
						    STCategory	*category);
STStream	*st_handler_event_stream_new	   (STHandler	*handler);
void		st_handler_event_stream_field_get  (STHandler	*handler,
						    STStream	*stream,
						    STHandlerField *field,
						    GValue	*value);
void		st_handler_event_stream_field_set  (STHandler	*handler,
						    STStream	*stream,
						    STHandlerField *field,
						    const GValue *value);
void		st_handler_event_stream_stock_field_get (STHandler *handler,
							 STStream  *stream,
							 STHandlerStockField stock_field,
							 GValue    *value);
gboolean	st_handler_event_stream_modify     (STHandler	*handler,
						    STStream	*stream,
						    GSList	*fields,
						    GSList	*values,
						    GError	**err);
gboolean	st_handler_event_stream_delete     (STHandler	*handler,
						    STStream	*stream,
						    GError	**err);
void		st_handler_event_stream_free	   (STHandler	*handler,
						    STStream	*stream);
gboolean	st_handler_event_stream_resolve	   (STHandler	*handler,
						    STStream	*stream,
						    GError	**err);
gboolean	st_handler_event_stream_tune_in	   (STHandler	*handler,
						    STStream	*stream,
						    GError	**err);
gboolean	st_handler_event_stream_tune_in_multiple (STHandler *handler,
							  GSList    *streams,
							  GError    **err);
gboolean	st_handler_event_stream_record	   (STHandler	*handler,
						    STStream	*stream,
						    GError	**err);
gboolean	st_handler_event_stream_browse	   (STHandler	*handler,
						    STStream	*stream,
						    GError	**err);
gpointer	st_handler_event_thread_begin	   (STHandler	*handler);
void		st_handler_event_thread_end	   (STHandler	*handler,
						    gpointer	data);

#endif /* _ST_HANDLER_H */
