/*
 * $Id: st-settings.h,v 1.20.2.3 2004/08/06 00:36:30 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_SETTINGS_H
#define _ST_SETTINGS_H

#include <glib.h>
#include "st-settings-api.h"
#include "st-transfer.h"

#define ST_SETTINGS_FIND_HISTORY_MAX_LENGTH	10

/*
 * All strings are expected to be always dynamically allocated.
 * They must be g_free()d before assigning a new value to them.
 *
 * The only exceptions are write-once strings (such as private_dir):
 * since there'll never be the need to reassign a value to them, they
 * can point to eitheir the stack or the heap.
 */
typedef struct
{
  const char		*private_dir;			/* write-once */

  const char		*config_file;			/* write-once */
  const char		*cache_file;			/* write-once */
  const char		*accels_file;			/* write-once */
  const char		*splash_disabled_file;		/* write-once */
  const char		*images_dir;			/* write-once */

  gboolean		splash_enabled;

  gboolean		view_toolbar;
  gboolean		view_tabs;
  gboolean		view_tab_icons;
  gboolean		view_statusbar;

  int			toolbar_style;
  int			toolbar_size;

  gboolean		save_automatic;

  int			main_window_width;
  int			main_window_height;

  int			preferences_window_width;
  int			preferences_window_height;

  int			stream_properties_window_width;
  
  int			selected_preferences_page;

  gboolean		proxy_enabled;
  STTransferProxy	proxy_type;
  char			*proxy_server;
  int			proxy_port;
  
  gboolean		proxy_auth_enabled;
  char			*proxy_auth_name;
  char			*proxy_auth_password;

  char			*selected_handler_name;

  gboolean		always_reload;

  char			*find_token;
  GSList		*find_history;
  gboolean		find_case_sensitive;
  gboolean		find_wrap_around;
} STSettings;

extern STSettings st_settings;
G_LOCK_EXTERN(st_settings);

void			st_settings_init     (const char *custom_private_dir);

#endif /* _ST_SETTINGS_H */
