/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SGTK_CELL_RENDERER_PIXBUF_H
#define _SGTK_CELL_RENDERER_PIXBUF_H

#include <gtk/gtk.h>

#define SGTK_TYPE_CELL_RENDERER_PIXBUF			(sgtk_cell_renderer_pixbuf_get_type())
#define SGTK_CELL_RENDERER_PIXBUF(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), SGTK_TYPE_CELL_RENDERER_PIXBUF, sGtkCellRendererPixbuf))
#define SGTK_CELL_RENDERER_PIXBUF_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), SGTK_TYPE_CELL_RENDERER_PIXBUF, sGtkCellRendererPixbufClass))
#define SGTK_IS_CELL_RENDERER_PIXBUF(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), SGTK_TYPE_CELL_RENDERER_PIXBUF))
#define SGTK_IS_CELL_RENDERER_PIXBUF_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), SGTK_TYPE_CELL_RENDERER_PIXBUF))
#define SGTK_CELL_RENDERER_PIXBUF_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), SGTK_TYPE_CELL_RENDERER_PIXBUF, sGtkCellRendererPixbufClass))

typedef struct _sGtkCellRendererPixbufPrivate sGtkCellRendererPixbufPrivate;

typedef struct
{
  GtkCellRendererPixbuf		cell;

  sGtkCellRendererPixbufPrivate	*priv;
} sGtkCellRendererPixbuf;

typedef struct
{
  GtkCellRendererPixbufClass	parent_class;
} sGtkCellRendererPixbufClass;

GType sgtk_cell_renderer_pixbuf_get_type (void);
GtkCellRenderer *sgtk_cell_renderer_pixbuf_new (void);

#endif /* _SGTK_CELL_RENDERER_PIXBUF_H */
