# $Id: python.m4,v 1.8 2004/01/31 17:08:26 jylefort Exp $
#
# This file is part of streamtuner-python.
#
# Copyright (c) 2003, 2004 Jean-Yves Lefort.
#
# As a special exception to the streamtuner-python licensing terms,
# Jean-Yves Lefort gives unlimited permission to copy, distribute and
# modify this file.
#
# Based upon:
#
# Python file handling
# 	From Andrew Dalke
# 	Updated by James Henstridge

dnl AM_PATH_EMBEDDED_PYTHON([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN(AM_PATH_EMBEDDED_PYTHON,
[found=no
PYTHON_VERSION=""
PYTHON_PREFIX=""
EMBEDDED_PYTHON_CFLAGS=""
EMBEDDED_PYTHON_LIBS=""

AC_PATH_PROGS(PYTHON, [python python2.3 python2.2 python2.1 python2.0 python1.6 python1.5], no)

if test "x$PYTHON" != "xno"; then
	minver=ifelse([$1],, 1.5.0, [$1])

	AC_MSG_CHECKING([Python version])

	changequote(<<, >>)dnl
	PYTHON_VERSION=`$PYTHON -c "
import sys, string

minver = '$minver'
pyver = string.split(sys.version)[0]

minver = map(string.atoi, string.split(minver, '.'))
pyver = map(string.atoi, string.split(pyver, '.'))

print sys.version[:3]

if pyver >= minver:
	sys.exit(0)
else:
	sys.exit(1)" 2>&AS_MESSAGE_LOG_FD`
	changequote([, ])dnl

	verstatus=$?

	if test -z "$PYTHON_VERSION"; then
		AC_MSG_RESULT([not found])
	else
		AC_MSG_RESULT([$PYTHON_VERSION])

		if test $verstatus -eq 0; then
			found=yes

			PYTHON_PREFIX=`AS_DIRNAME(["$PYTHON"])`
			PYTHON_PREFIX=`AS_DIRNAME(["$PYTHON_PREFIX"])`
			EMBEDDED_PYTHON_CFLAGS="-I$PYTHON_PREFIX/include/python$PYTHON_VERSION"
			EMBEDDED_PYTHON_LIBS="-L$PYTHON_PREFIX/lib/python$PYTHON_VERSION/config -lutil -lpython$PYTHON_VERSION"
		else
			PYTHON_VERSION=""
			AC_MSG_WARN([the installed Python is too old (version $minver required)])
		fi
	fi
fi

if test $found = yes; then
	ifelse([$2],, :, [$2])
else
	ifelse([$3],, :, [$3])
fi

AC_SUBST(PYTHON_VERSION)
AC_SUBST(PYTHON_PREFIX)
AC_SUBST(EMBEDDED_PYTHON_CFLAGS)
AC_SUBST(EMBEDDED_PYTHON_LIBS)])
