# $Id: ST.py,v 1.42 2004/01/27 13:52:34 jylefort Exp $
#
# Copyright (c) 2003, 2004 Jean-Yves Lefort
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import G
from streamtuner import *

### private sauce #############################################################

# credits to Alex Martelli for this trick
# (http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/52304)
class _Callable:
    def __init__ (self, anycallable):
        self.__call__ = anycallable

### the API ###################################################################

MAJOR_VERSION			= ST_MAJOR_VERSION
MINOR_VERSION			= ST_MINOR_VERSION
MICRO_VERSION			= ST_MICRO_VERSION

API_MAJOR_VERSION		= ST_API_MAJOR_VERSION
API_MINOR_VERSION		= ST_API_MINOR_VERSION

class Action:
    register = _Callable(st_action_register)
    run = _Callable(st_action_run)

class Category:
    def __init__ (self, o=None):
        if o is None:
            o = st_category_new()
        self.o = o

    def __setattr__ (self, key, value):
        if key == "name":			st_category_set_name(self.o, value)
        elif key == "label":			st_category_set_label(self.o, value)
        elif key == "url_postfix":		st_category_set_url_postfix(self.o, value)
        else:					self.__dict__[key] = value

    def __getattr__ (self, key):
        if key == "name":			return st_category_get_name(self.o)
        elif key == "label":			return st_category_get_label(self.o)
        elif key == "url_postfix":		return st_category_get_url_postfix(self.o)
        elif self.__dict__.has_key(key):	return self.__dict__[key]

notice	= st_notice
class Dialog:
    error = _Callable(st_error_dialog)
    search = _Callable(st_search_dialog)

# Deprecated
warning	= st_warning
error	= st_error

class Handler:
    EVENT_REFRESH			= ST_HANDLER_EVENT_REFRESH
    EVENT_RELOAD			= ST_HANDLER_EVENT_REFRESH	# Deprecated
    EVENT_STREAM_TUNE_IN		= ST_HANDLER_EVENT_STREAM_TUNE_IN
    EVENT_STREAM_TUNE_IN_MULTIPLE	= ST_HANDLER_EVENT_STREAM_TUNE_IN_MULTIPLE
    EVENT_STREAM_RECORD			= ST_HANDLER_EVENT_STREAM_RECORD
    EVENT_STREAM_BROWSE			= ST_HANDLER_EVENT_STREAM_BROWSE
    
    def __init__ (self, name, o=None):
        if o is None:
            o = st_handler_new(name)
        self.o = o

    def __setattr__ (self, key, value):
        if key == "label":		st_handler_set_label(self.o, value)
        elif key == "copyright":	st_handler_set_copyright(self.o, value)
        elif key == "description":	st_handler_set_description(self.o, value)
        elif key == "home":		st_handler_set_home(self.o, value)
        elif key == "stock_categories":	st_handler_set_stock_categories(self.o, value.o)
        elif key == "icon":		st_handler_set_icon_from_file(self.o, value)
        else:				self.__dict__[key] = value

    def add_field (self, field):
        st_handler_add_field(self.o, field.o)

    def bind (self, event, cb, data=None):
        if event == Handler.EVENT_REFRESH:		STcb = _refresh_cb
        elif event == Handler.EVENT_STREAM_TUNE_IN	\
          or event == Handler.EVENT_STREAM_RECORD	\
          or event == Handler.EVENT_STREAM_BROWSE:	STcb = _stream_cb
    	elif event == Handler.EVENT_STREAM_TUNE_IN_MULTIPLE:
            STcb = _stream_tune_in_multiple_cb
    	else: STcb = None	# st_handler_bind() will raise an exception
	
        st_handler_bind(self.o, event, STcb, (cb, data))

def _refresh_cb (category, categories, streams, binding):
    o_category = Category(o=category)
    o_categories = G.Node(o=categories)
    o_streams = []

    status = apply(binding[0], (o_category, o_categories, o_streams, binding[1]))

    if status is not None:
        for stream in o_streams:
            streams.append(stream.o)

    return status

def _stream_cb (stream, binding):
    return apply(binding[0], (Stream(o=stream), binding[1]))

def _stream_tune_in_multiple_cb (o_streams, binding):
    streams = []
    for o in o_streams:
        streams.append(Stream(o=o))
    return apply(binding[0], (streams, binding[1]))

class HandlerField:
    def __init__ (self, id, label, type, visible, o=None):
        if o is None:
            o = st_handler_field_new(id, label, type, visible)
        self.o = o

class Handlers:
    def add (handler):
        st_handlers_add(handler.o)
    add = _Callable(add)

class M3U:
    mktemp = _Callable(st_m3u_mktemp)
        
class PLS:
    parse = _Callable(st_pls_parse)

# Deprecated
class Programs:
    register = _Callable(st_programs_register)
    run = _Callable(st_programs_run)

is_aborted = st_is_aborted

class Stream:
    def __init__ (self, o=None):
        if o is None:
            o = st_stream_new()
        self.o = o

    def __setattr__ (self, key, value):
        if key == "name":			st_stream_set_name(self.o, value)
        else:					self.__dict__[key] = value

    def __getattr__ (self, key):
        if key == "name":			return st_stream_get_name(self.o)
        elif self.__dict__.has_key(key):	return self.__dict__[key]

    def set_field (self, id, data):
        st_stream_set_field(self.o, id, data)

    def get_field (self, id):
        return st_stream_get_field(self.o, id)

class Transfer:
    class Session:
        def __init__ (self):
            self.o = st_transfer_session_new()

        def get (self, url, flags, fetch_headers):
            return st_transfer_session_get(self.o, url, flags, fetch_headers)

        def get_by_line (self, url, flags, header_cb, header_data, body_cb, body_data):
            return st_transfer_session_get_by_line(self.o, url, flags, header_cb, header_data, body_cb, body_data)
        
    escape = _Callable(st_transfer_escape)

    # Deprecated
    get_full = _Callable(st_transfer_get_full)
    get_lines = _Callable(st_transfer_get_lines)

def check_api_version (required_major_version, minimum_minor_version):
    return API_MAJOR_VERSION == required_major_version \
           and API_MINOR_VERSION >= minimum_minor_version

find_icon = st_find_icon
