// Java source code generated by SCC (StateChart Compiler) 0.3, written by Thomas Feng
//   Source: sample.des
//   Date:   April 12, 2004
//   Time:   21:17:35

// Header Section -- definition and module importation used by the following parts
import java.io.*;

class State {
  public int StateID;
  public State Next=null;
}

class History {
  public int[] States;
  public long[] Times;
  public StateMachine Submodel;
}

class EventList {
  public String Event;
  public EventList Next=null;
  public void Append(String e) {
    EventList el=new EventList();
    el.Event=e;
    EventList cur=this;
    while (cur.Next!=null && cur.Event!=e)
      cur=cur.Next;
    if (cur.Event!=e)
      cur.Next=el;
  }
  public void Append(EventList el) {
    while (el!=null) {
      Append(el.Event);
      el=el.Next;
    }
  }
}

class StringList {
  public String str;
  public StringList Next=null;
  public StringList() {
    this("");
  }
  public StringList(String str) {
    this.str=str;
  }
}

class Hierarchy {
  public String StateName;
  public String PathName;
  public int StateNum;
  public int Level;
  public Hierarchy Next;
}

class StateMachine {
  protected int eventStr2Int(String event) {
    return -1;
  }
  protected StringList getCurrentStateList() {
    return null;
  }
  protected void topLevelHistory() {
  }
  public boolean handleEvent(String se) {
    return false;
  }
  public String getCurrentState() {
    return "[]";
  }
  public EventList getEnabledEvents() {
    return null;
  }
  public void initModel() {
  }
  public boolean isInState(int s) {
    return false;
  }
  public boolean isInState(String s) {
    return false;
  }
  public int getParentState(int state) {
    return -1;
  }
  public boolean isHistoryState(int state) {
    return false;
  }
  public boolean isLeafState(String state) {
    return true;
  }
  public Hierarchy getHierarchy() {
    return getHierarchy(0, null);
  }
  public Hierarchy getHierarchy(int start_level, String state_prefix) {
    return null;
  }
  protected void runActionCode(int code_num) {
  }
}

// Main Class -- the top level model that is executed from the command line
public class sample extends StateMachine {
  // Constants for this model
  private static final int StateNum=9;
  private static final String[] EventNames={"to S1",
                                            "to S1 hs",
                                            "to S2",
                                            "to S7" 
                                           };
  private static final String[] StateNames={"S1",
                                            "S1.S2",
                                            "S1.S2.S3",
                                            "S1.S2.S4",
                                            "S1.S2.S5",
                                            "S1.S6",
                                            "S7",
                                            "S7.S8",
                                            "S7.S9" 
                                           };
  private static final int[] ParentTable={-1,  // S1 -- parent (None)
                                          0,  // S1.S2 -- parent S1
                                          1,  // S1.S2.S3 -- parent S1.S2
                                          1,  // S1.S2.S4 -- parent S1.S2
                                          1,  // S1.S2.S5 -- parent S1.S2
                                          0,  // S1.S6 -- parent S1
                                          -1,  // S7 -- parent (None)
                                          6,  // S7.S8 -- parent S7
                                          6   // S7.S9 -- parent S7
                                         };
  private static final int[] HistoryStateTable={2,
                                                0,
                                                0,
                                                0,
                                                0,
                                                0,
                                                0,
                                                0,
                                                0 
                                               };
  private static final String[] LeafStateTable={null,
                                                null,
                                                "S1.S2.S3",
                                                "S1.S2.S4",
                                                "S1.S2.S5",
                                                "S1.S6",
                                                null,
                                                "S7.S8",
                                                "S7.S9" 
                                               };
  private static final boolean[][] OrthogonalInBetween={{false, false, true , true , false, false, false, false, false},
                                                        {false, false, true , true , false, false, false, false, false},
                                                        {false, false, true , true , false, false, false, false, false},
                                                        {false, false, false, false, false, false, false, false, false},
                                                        {false, false, false, false, false, false, false, false, false},
                                                        {false, false, false, false, false, false, false, false, false},
                                                        {false, false, false, false, false, false, false, false, false},
                                                        {false, false, false, false, false, false, false, false, false},
                                                        {false, false, false, false, false, false, false, false, false},
                                                        {false, false, false, false, false, false, false, false, false} 
                                                       };
  private static final boolean[][] Hierarchy={{false, true , true , true , true , true , false, false, false},  // children for state S1
                                              {false, false, true , true , true , false, false, false, false},  // children for state S1.S2
                                              {false, false, false, false, false, false, false, false, false},  // children for state S1.S2.S3
                                              {false, false, false, false, false, false, false, false, false},  // children for state S1.S2.S4
                                              {false, false, false, false, false, false, false, false, false},  // children for state S1.S2.S5
                                              {false, false, false, false, false, false, false, false, false},  // children for state S1.S6
                                              {false, false, false, false, false, false, false, true , true },  // children for state S7
                                              {false, false, false, false, false, false, false, false, false},  // children for state S7.S8
                                              {false, false, false, false, false, false, false, false, false}   // children for state S7.S9
                                             };
  private static final int[][] CommonStateTable={{-1, 0, 0, 0, 0, 0, -1, -1, -1},
                                                 {0, 0, 1, 1, 1, 0, -1, -1, -1},
                                                 {0, 1, 1, 1, 1, 0, -1, -1, -1},
                                                 {0, 1, 1, 1, 1, 0, -1, -1, -1},
                                                 {0, 1, 1, 1, 1, 0, -1, -1, -1},
                                                 {0, 0, 0, 0, 0, 0, -1, -1, -1},
                                                 {-1, -1, -1, -1, -1, -1, -1, 6, 6},
                                                 {-1, -1, -1, -1, -1, -1, 6, 6, 6},
                                                 {-1, -1, -1, -1, -1, -1, 6, 6, 6} 
                                                };
  private static final String Description=null;

  // Variables
  private State state;
  private StateMachine[] Submodels=new StateMachine[StateNum];
  private History[] history=new History[StateNum];

  // Constructor
  public sample() {
    for (int i=0; i<StateNum; i++) {
      history[i]=new History();
      history[i].States=new int[StateNum];
      history[i].Times=new long[StateNum];
      for (int j=0; j<StateNum; j++) {
        history[i].States[j]=-1;
        history[i].Times[j]=-1;
      }
    }
  }

  // Methods
  private boolean isParent(int sp, int sc) {
    return sc>=0 && (sp<0 || Hierarchy[sp][sc]);
  }
  public boolean isInState(int s) {
    State st=state;
    while (st!=null) {
      if (st.StateID==s || isParent(s, st.StateID))
        return true;
      else
        st=st.Next;
    }
    return false;
  }
  public boolean isInState(String s) {
    for (int i=0; i<StateNum; i++)
      if (s.compareTo(StateNames[i])==0)
        return isInState(i);
    for (int i=0; i<StateNum; i++)
      if (Submodels[i]!=null && s.startsWith(StateNames[i]+".")) {
        String SubmodelState=s.substring(StateNames[i].length()+1);
        return isInState(i) && Submodels[i].isInState(SubmodelState);
      }
    return false;
  }
  public static void main(String[] argv) {
    sample model=new sample();
    String cmd="";
    model.initModel();
    if (sample.Description!=null)
      System.out.println(sample.Description);
    InputStreamReader isr=new InputStreamReader(System.in);
    BufferedReader br=new BufferedReader(isr);
    while (cmd!=null && cmd.compareTo("exit")!=0) {
      try {
        System.out.print(model.getCurrentState()+" > ");
        cmd=br.readLine();
        if (cmd==null || cmd.compareTo("exit")==0)
          break;
        model.handleEvent(cmd);
      }
      catch (IOException e1) {
        System.out.println("Input error!");
      }
    }
  }
  public void initModel() {
    addInState(5); // init state "S1.S6"
  }
  public boolean handleEvent(String se) {
    int e=eventStr2Int(se);
    switch (e) {
      case 0: // event "to S1"
        if (isInState(7)) {
          changeState(7, 0);
          return true;
        }
        break;
      case 1: // event "to S1 hs"
        if (isInState(7)) {
          changeState(7, 0, true);
          return true;
        }
        break;
      case 2: // event "to S2"
        if (isInState(5)) {
          changeState(5, 1);
          return true;
        }
        break;
      case 3: // event "to S7"
        if (isInState(1)) {
          if (isInState(4) && Submodels[4].handleEvent(se))
            return true;
          changeState(1, 6);
          return true;
        }
        break;
    }
    if (isInState(4) && Submodels[4].handleEvent(se))
      return true;
    return false;
  }
  public void forceIntoState(int s) {
    boolean changed=false;
    State s2=state;
    while (s2!=null) {
      boolean HasCommonParent=false;
      for (int i=0; i<StateNum; i++) {
        if (isParent(i, s2.StateID) && isParent(i, s)) {
          HasCommonParent=true;
          if (!hasOrthogonalStateInBetween(i, s2.StateID)) {
            changeState(s2.StateID, s);
            changed=true;
          }
        }
      }
      if (!HasCommonParent) {
        changeState(s2.StateID, s);
        changed=true;
      }
      s2=s2.Next;
    }
    if (!changed)
      addInState(s);
  }
  public void changeState(int s1, int s2) {
    changeState(s1, s2, false);
  }
  public void changeState(int s1, int s2, boolean check_history) {
    // t1=common(s1, s2)
    int t1=CommonStateTable[s1][s2];
    recordHistory(t1);
    if (t1>=0)
      removeOutStates(t1);
    else
      state=null;
    // t2=history(s2)
    int t2=HistoryStateTable[s2];
    if (t2==0) // no history
      generateStates(t1, s2);
    else if (t2==1) // normal history
      if (!check_history)
        generateStates(t1, s2);
      else if (hasHistoryRecorded(s2))
        generateStates(t1, history[s2].States[s2]);
      else
        generateStates(t1, s2, 1);
    else if (t2==2) // deep history
      if (check_history && hasHistoryRecorded(s2))
        for (int i=0; i<StateNum; i++) {
          int hs=history[s2].States[i];
          if (hs>=0 && isLeafState(hs))
            addInState(hs);
        }
      else
        generateStates(t1, s2);
  }
  private boolean addInState(int s) {
    if (!isInState(s)) {
      State st=new State();
      st.StateID=s;
      st.Next=state;
      state=st;
      return true;
    }
    else
      return false;
  }
  private void generateStates(int common, int dest) {
    generateStates(common, dest, 0);
  }
  private void generateStates(int common, int dest, int history_type) {
    switch (common) {
      case -1:
        switch (dest) {
          case 0:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(5)) {
            addInState(5);  // move into leaf state "S1.S6"
            }
            }
            }
            break;
          case 1:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            }
            break;
          case 2:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            }
            break;
          case 3:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            }
            break;
          case 4:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            }
            break;
          case 5:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(5)) {
            addInState(5);  // move into leaf state "S1.S6"
            }
            }
            }
            break;
          case 6:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(6)) {
            if (history_type!=2 || check_history(7)) {
            addInState(7);  // move into leaf state "S7.S8"
            }
            }
            }
            break;
          case 7:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(6)) {
            if (history_type!=2 || check_history(7)) {
            addInState(7);  // move into leaf state "S7.S8"
            }
            }
            }
            break;
          case 8:
            if (history_type!=2 || check_history(-1)) {
            if (history_type!=2 || check_history(6)) {
            if (history_type!=2 || check_history(8)) {
            addInState(8);  // move into leaf state "S7.S9"
            }
            }
            }
            break;
        }
        break;
      case 0:
        switch (dest) {
          case 0:
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(5)) {
            addInState(5);  // move into leaf state "S1.S6"
            }
            }
            break;
          case 1:
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            break;
          case 2:
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            break;
          case 3:
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            break;
          case 4:
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            }
            break;
          case 5:
            if (history_type!=2 || check_history(0)) {
            if (history_type!=2 || check_history(5)) {
            addInState(5);  // move into leaf state "S1.S6"
            }
            }
            break;
        }
        break;
      case 1:
        switch (dest) {
          case 1:
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            break;
          case 2:
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            break;
          case 3:
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            break;
          case 4:
            if (history_type!=2 || check_history(1)) {
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            }
            break;
        }
        break;
      case 2:
        switch (dest) {
          case 2:
            if (history_type!=2 || check_history(2)) {
            addInState(2);  // move into leaf state "S1.S2.S3"
            }
            break;
        }
        break;
      case 3:
        switch (dest) {
          case 3:
            if (history_type!=2 || check_history(3)) {
            addInState(3);  // move into leaf state "S1.S2.S4"
            }
            break;
        }
        break;
      case 4:
        switch (dest) {
          case 4:
            if (history_type!=2 || check_history(4)) {
            addInState(4);  // move into leaf state "S1.S2.S5"
            if (history_type==1 && Submodels[4]!=null)
              Submodels[4].topLevelHistory();
            else if (history_type!=2 || Submodels[4]==null) {
              Submodels[4]=new sample();
              Submodels[4].initModel();
            }
            }
            break;
        }
        break;
      case 5:
        switch (dest) {
          case 5:
            if (history_type!=2 || check_history(5)) {
            addInState(5);  // move into leaf state "S1.S6"
            }
            break;
        }
        break;
      case 6:
        switch (dest) {
          case 6:
            if (history_type!=2 || check_history(6)) {
            if (history_type!=2 || check_history(7)) {
            addInState(7);  // move into leaf state "S7.S8"
            }
            }
            break;
          case 7:
            if (history_type!=2 || check_history(6)) {
            if (history_type!=2 || check_history(7)) {
            addInState(7);  // move into leaf state "S7.S8"
            }
            }
            break;
          case 8:
            if (history_type!=2 || check_history(6)) {
            if (history_type!=2 || check_history(8)) {
            addInState(8);  // move into leaf state "S7.S9"
            }
            }
            break;
        }
        break;
      case 7:
        switch (dest) {
          case 7:
            if (history_type!=2 || check_history(7)) {
            addInState(7);  // move into leaf state "S7.S8"
            }
            break;
        }
        break;
      case 8:
        switch (dest) {
          case 8:
            if (history_type!=2 || check_history(8)) {
            addInState(8);  // move into leaf state "S7.S9"
            }
            break;
        }
        break;
    }
  }
  private void removeOutStates(int common_state) {
    State s=state, prev=null;
    while (s!=null) {
      if (isParent(common_state, s.StateID)) {
        if (prev==null)
          state=state.Next;
        else
          prev.Next=s.Next;
      }
      else
        prev=s;
      s=s.Next;
    }
  }
  protected int eventStr2Int(String event) {
    for (int i=0; i<4; i++)
      if (event.compareTo(EventNames[i])==0)
        return i;
    return -1;
  }
  private String stateInt2Str(int state) {
    if (state==-1)
      return "";
    else
      return StateNames[state];
  }
  protected StringList getCurrentStateList() {
    StringList sl=new StringList(), slend=sl;
    State s=state;
    while (s!=null) {
      StateMachine sm=Submodels[s.StateID];
      String curstate=stateInt2Str(s.StateID);
      if (sm!=null) {
        slend.Next=sm.getCurrentStateList();
        while (slend.Next!=null) {
          slend.Next.str=curstate+"."+slend.Next.str;
          slend=slend.Next;
        }
      }
      else {
        slend.Next=new StringList(curstate);
        slend=slend.Next;
      }
      s=s.Next;
    }
    return sl.Next;
  }
  public String getCurrentState() {
    return getCurrentState(null);
  }
  private String getCurrentState(StringList states) {
    String strst;
    if (states==null) {
      states=getCurrentStateList();
      if (states!=null)
        strst="["+getCurrentState(states)+"\'"+states.str+"\'"+"]";
      else
        strst="[]";
    }
    else {
      if (states.Next!=null)
        strst=getCurrentState(states.Next)+"\'"+states.Next.str+"\'"+", ";
      else
        strst="";
    }
    return strst;
  }
  public int getParentState(int state) {
    return ParentTable[state];
  }
  public boolean isHistoryState(int state) {
    return HistoryStateTable[state]>0;
  }
  private boolean isLeafState(int state) {
    return LeafStateTable[state]!=null;
  }
  public boolean isLeafState(String state) {
    for (int i=0; i<StateNum; i++) {
      if (LeafStateTable[i]==null)
        continue;
      if (state.compareTo(LeafStateTable[i])==0 && Submodels[i]==null)
        return true;
      else if (state.startsWith(LeafStateTable[i]+".") && Submodels[i]!=null) {
        String SubmodelState=state.substring(LeafStateTable[i].length()+1);
	return Submodels[i].isLeafState(SubmodelState);
      }
    }
    return false;
  }
  private boolean isHistoryUp2Date(int state, long time) {
    for (int i=0; i<StateNum; i++)
      if (history[state].Times[i]>=time)
        return true;
    return false;
  }
  private void mergeHistory(int state, int[] states, long[] times) {
    long max=-1;
    for (int i=0; i<StateNum; i++)
      if (times[i]>max)
        max=times[i];
    if (isHistoryUp2Date(state, max)) {
      for (int i=0; i<StateNum; i++)
        if (times[i]>history[state].Times[i]) {
          history[state].States[i]=states[i];
          history[state].Times[i]=times[i];
        }
    }
    else {
      history[state].States=(int[])states.clone();
      history[state].Times=(long[])times.clone();
    }
  }
  private void recordHistory(int top_state) {
    long time=(new java.util.Date()).getTime();
    State s=state;
    while (s!=null) {
      int child=s.StateID;
      int[] states=new int[StateNum];
      long[] times=new long[StateNum];
      for (int i=0; i<StateNum; i++) {
        states[i]=-1;
        times[i]=-1;
      }
      states[child]=child;
      times[child]=time;
      if (top_state<0 || isParent(top_state, child)) {
        int parent=getParentState(child);
        if (isHistoryState(child))
          history[child].Submodel=Submodels[child];
        while (parent!=top_state && times[parent]!=time) {
          states[parent]=child;
          times[parent]=time;
          if (isHistoryState(parent))
            mergeHistory(parent, states, times);
          child=parent;
          parent=getParentState(child);
        }
      }
      s=s.Next;
    }
  }
  private boolean hasHistoryRecorded(int state) {
    for (int i=0; i<StateNum; i++) {
      if (history[state].States[i]!=-1)
        return true;
      if (Submodels[state]!=null)
        return true;
    }
    return false;
  }
  private boolean hasOrthogonalStateInBetween(int parent, int leaf) {
    return OrthogonalInBetween[parent+1][leaf];
  }
  private boolean check_history(int dest) {
    State s=state;
    while (s!=null) {
      if (isParent(dest, s.StateID) && !hasOrthogonalStateInBetween(dest, s.StateID))
        return false;
      s=s.Next;
    }
    return true;
  }
  public EventList getEnabledEvents() {
    EventList events=new EventList();
    if (isInState(7))
      events.Append("to S1");
    if (isInState(7))
      events.Append("to S1 hs");
    if (isInState(5))
      events.Append("to S2");
    if (isInState(1))
      events.Append("to S7");
    if (isInState(4))
      events.Append(Submodels[4].getEnabledEvents());
    return events.Next;
  }
  public Hierarchy getHierarchy(int start_level, String state_prefix) {
    Hierarchy h=new Hierarchy(), lasth=h;
    // Generate state "S1" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S1";
    lasth.Next.PathName=state_prefix==null?"S1":state_prefix+".S1";
    lasth.Next.StateNum=0;
    lasth.Next.Level=start_level+0;
    lasth=lasth.Next;
    // Generate state "S1.S2" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S2";
    lasth.Next.PathName=state_prefix==null?"S1.S2":state_prefix+".S1.S2";
    lasth.Next.StateNum=1;
    lasth.Next.Level=start_level+1;
    lasth=lasth.Next;
    // Generate state "S1.S2.S3" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S3";
    lasth.Next.PathName=state_prefix==null?"S1.S2.S3":state_prefix+".S1.S2.S3";
    lasth.Next.StateNum=2;
    lasth.Next.Level=start_level+2;
    lasth=lasth.Next;
    // Generate state "S1.S2.S4" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S4";
    lasth.Next.PathName=state_prefix==null?"S1.S2.S4":state_prefix+".S1.S2.S4";
    lasth.Next.StateNum=3;
    lasth.Next.Level=start_level+2;
    lasth=lasth.Next;
    // Generate state "S1.S2.S5" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S5";
    lasth.Next.PathName=state_prefix==null?"S1.S2.S5":state_prefix+".S1.S2.S5";
    lasth.Next.StateNum=4;
    lasth.Next.Level=start_level+2;
    lasth=lasth.Next;
    if (Submodels[4]!=null) {
      lasth.Next=Submodels[4].getHierarchy(start_level+2+1, lasth.PathName);
      while (lasth.Next!=null)
        lasth=lasth.Next;
    }
    // Generate state "S1.S6" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S6";
    lasth.Next.PathName=state_prefix==null?"S1.S6":state_prefix+".S1.S6";
    lasth.Next.StateNum=5;
    lasth.Next.Level=start_level+1;
    lasth=lasth.Next;
    // Generate state "S7" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S7";
    lasth.Next.PathName=state_prefix==null?"S7":state_prefix+".S7";
    lasth.Next.StateNum=6;
    lasth.Next.Level=start_level+0;
    lasth=lasth.Next;
    // Generate state "S7.S8" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S8";
    lasth.Next.PathName=state_prefix==null?"S7.S8":state_prefix+".S7.S8";
    lasth.Next.StateNum=7;
    lasth.Next.Level=start_level+1;
    lasth=lasth.Next;
    // Generate state "S7.S9" in the hierarchy table
    lasth.Next=new Hierarchy();
    lasth.Next.StateName="S9";
    lasth.Next.PathName=state_prefix==null?"S7.S9":state_prefix+".S7.S9";
    lasth.Next.StateNum=8;
    lasth.Next.Level=start_level+1;
    lasth=lasth.Next;
    return h.Next;
  }
  protected void topLevelHistory() {
    int s=state.StateID, t;
    do {
      t=getParentState(s);
      if (t!=-1)
        s=t;
    } while (t!=-1);
    changeState(s, s);
  }
  protected void runActionCode(int code_num) {
  }
}

