#!/usr/bin/env python

#---------------------------------------------------------------------
#    SVM (Statechart Virtual Machine)
#         -- an interpreter for an extended statechart formalism
#---------------------------------------------------------------------
#
# Copyright (C) 2003 Thomas Huining Feng
#
#---------------------------------------------------------------------
# Address:      MSDL, SOCS, McGill Univ., Montreal, Canada
# HomePage:     http://msdl.cs.mcgill.ca/people/tfeng/
# SVM HomePage: http://msdl.cs.mcgill.ca/people/tfeng/?research=svm
# Download:     http://savannah.nongnu.org/files/?group=svm
# CVS:          :pserver:anoncvs@subversions.gnu.org:/cvsroot/svm
#               (projects "svm" and "jsvm")
# Email:        hfeng2@cs.mcgill.ca
#---------------------------------------------------------------------
#
# This file is part of SVM.
#
#---------------------------------------------------------------------
# SVM is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your
# option) any later version.
#
# SVM is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
# License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SVM; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#---------------------------------------------------------------------


""" An example of a client using the naming service. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA

# Naming Service modules.
from Fnorb.cos.naming import CosNaming

# Stubs generated by 'fnidl'.
sys.path=['./svmwork/serverif/test_0/SVMMODULE']+sys.path
import test

def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Get a reference to the initial naming service context.
    ctx = CORBA.ORB_init().resolve_initial_references("NameService")

    # The 'pathname' of the context that holds the thermometer references.
    path = [CosNaming.NameComponent('SVM', ''),
	    CosNaming.NameComponent('SVMMODULE', ''),
	    CosNaming.NameComponent('test', '')]

    # Lookup the temperatures of the thermometers in rooms 101-105, and then
    # force a lookup on a non-existent name "106"!
    for room in ["inf_0"]:
	# Create a naming service 'name' for the thermometer.
	name = path + [CosNaming.NameComponent(room, '')]

	try:
	    # Lookup the thermometer in the naming service.
	    thermometer = ctx.resolve(name)

	    # Make sure the object implements the expected interface!
	    if not thermometer._is_a(CORBA.id(test.inf_0)):
		raise 'This is not a Thermometer!'

	    # Call the server!
	    thermometer.p('e', [CORBA.Any(CORBA.TC_string, 'hello')])

	except CosNaming.NamingContext.NotFound:
	    print 'No thermometer in room', room

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
