import java.awt.Color;
import java.util.Iterator;
import java.util.ArrayList;
public class Prisoner {
    private Payoffs payoffs = null;
    private Location location = null;
    private Strategy strategy = null;
    private Strategy strategy_new = null;
    public double payoff = Double.NaN;
    public int move = Integer.MIN_VALUE;
    public int numSteps = Integer.MIN_VALUE;

    public Prisoner(Payoffs p, Strategy s, Location l, int n) 
        throws PrisonerException {
        if (p == null || s == null || l == null) 
            throw new PrisonerException("Construction problem in "+this);
        payoffs = p;
        strategy_new = s;
        strategy = strategy_new;
        numSteps = n;
        location = l;
        l.set_object(this);
    }

    public void set_location(Location l) {
        if (location != null) location.set_object(null);
        location = l;
        l.set_object(this);
    }

    public void set_strategy(Strategy s) {
        strategy_new = s;
        strategy = s;
    }

    public void set_payoffs(Payoffs p) {
        payoffs = p;
    }

    public void set_numSteps(int n) {
        numSteps = n;
    }

    public Object mimicBest() {
        try {
            Prisoner best_neighbor = findBestNeighbor();
            strategy_new = best_neighbor.get_strategy();
        } catch (PrisonerException pe) {
            System.err.println(pe+" caught by Prisoner::mimicBest()");
            pe.printStackTrace();
            System.exit(-1);
        }
        return this;
    }

    public Object reset() {
        // Swap strategy
        strategy = strategy_new;
        // Clear payoff
        payoff = 0.0d;

        return this;
    }

    public int initial() throws PrisonerException {
        if (strategy == null) {
            throw new PrisonerException("Strategy is null in "+this);
        }
        move = strategy.initial();
        return move;
    }

    public int move(int o) {
        // Record payoff
        payoff += payoffs.evaluate(move,o);
        // Play strategy
        move = strategy.move(o);
        return move;
    }

    public Object playNeighbors() {
        try {
            Iterator ndx = location.get_neighbors().iterator();
            while (ndx.hasNext()) {
                Prisoner neighbor = (Prisoner)
                    ((Location)ndx.next()).get_object();
                if (neighbor != null) {
                    int move_neighbor = neighbor.initial();
                    int move_self = strategy.initial();

                    // Get moves on remaining steps
                    for (int step=1; step<(numSteps-1); step++) {
                        // Save previous move
                        int init_self = move_self;
                        int init_neighbor = move_neighbor;
                        // Get each player's reaction
                        move_neighbor = neighbor.move(init_self);
                        move_self = strategy.move(init_neighbor);
                    }
                    // Record last payoff
                    payoff += payoffs.evaluate(move_self, move_neighbor);
                }
            }
        } catch (PrisonerException pe) {
            System.err.println(pe+": caught by Prisoner::playNeighbors()");
            pe.printStackTrace();
            System.exit(-1);
        }
        return this;
    }

    public Prisoner findBestNeighbor() throws PrisonerException {
        if (payoff == Double.NaN || location == null)
            throw new PrisonerException("payoff||location = null "+this);
        double payoff_best = payoff;
        Prisoner neighbor_best = this;
        Iterator ndx = location.get_neighbors().iterator();
        while (ndx.hasNext()) {
            Prisoner neighbor = (Prisoner)
                ((Location)ndx.next()).get_object();
            if (neighbor != null) {
                if (neighbor.get_payoff() > payoff_best) {
                    payoff_best = neighbor.get_payoff();
                    neighbor_best = neighbor;
                }
            }
        }
        return neighbor_best;
    }

    public double get_payoff() {
        return payoff;
    }

    public Strategy get_strategy() {
        return strategy;
    }

    public Location get_location() {
        return location;
    }

    public Color get_color() {
        return strategy.get_color();
    }

    public int get_attribute() {
        return strategy.get_number();
    }
}
