/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_aligned.c

	This convenience widget is a box which contains a widget and a label,
	aligning them at the specified value
*/

#include "libkiazma.h"
#include "kiazma_aligned.h"

/**
	@internal

	Init the class for KiazmaAligned

	@param	klass	Instance of the class to init
*/
static void kiazma_aligned_class_init ( KiazmaAlignedClass *klass ) {
	return;
}

/**
	@internal

	Init the internals of KiazmaAligned

	@param	ttt	The KiazmaAligned to init
*/
static void kiazma_aligned_init ( KiazmaAligned *ttt ) {
	gtk_box_set_homogeneous ( GTK_BOX ( ttt ), FALSE );
	gtk_container_set_border_width ( GTK_CONTAINER ( ttt ), 1 );
}

/**
	Register the GType for KiazmaAligned

	@return		The newly registered type for the widget
*/
GType kiazma_aligned_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaAlignedClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_aligned_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaAligned ),
			0,
			( GInstanceInitFunc ) kiazma_aligned_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_HBOX, "KiazmaAligned", &ttt_info, 0 );
	}

	return ttt_type;
}

/**
	Builds a new KiazmaAligned

	@param	sg	Alignement group in which the widget must be aligned
	@param	title	Text of the label which appears together the widget
	@param	item	Widget to put into the KiazmaAligned

	@return		The newly created KiazmaAligned
*/
GtkWidget* kiazma_aligned_new ( GtkSizeGroup *sg, gchar *title, GtkWidget *item ) {
	GtkWidget *new_item;
	GtkWidget *label;

	new_item = GTK_WIDGET ( g_object_new ( kiazma_aligned_get_type (), NULL ) );
	label = gtk_label_new ( title );
	gtk_label_set_justify ( GTK_LABEL ( label ), GTK_JUSTIFY_LEFT );
	gtk_size_group_add_widget ( sg, label );
	gtk_box_pack_start ( GTK_BOX ( new_item ), label, FALSE, FALSE, 0 );

	gtk_box_pack_start ( GTK_BOX ( new_item ), item, TRUE, TRUE, 0 );

	return new_item;
}
