/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_ENUMERATION_COMBO_H
#define KIAZMA_ENUMERATION_COMBO_H

#include "libkiazma.h"

#define KIAZMA_ENUMERATION_COMBO_TYPE			( kiazma_enumeration_combo_get_type () )
#define KIAZMA_ENUMERATION_COMBO(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_ENUMERATION_COMBO_TYPE, KiazmaEnumerationCombo ) )
#define KIAZMA_ENUMERATION_COMBO_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_ENUMERATION_COMBO_TYPE, KiazmaEnumerationComboClass ) )
#define IS_KIAZMA_ENUMERATION_COMBO(obj)		( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_ENUMERATION_COMBO_TYPE ) )
#define IS_KIAZMA_ENUMERATION_COMBO_CLASS(klass)	( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_ENUMERATION_COMBO_TYPE ) )

typedef struct _KiazmaEnumerationCombo			KiazmaEnumerationCombo;
typedef struct _KiazmaEnumerationComboClass		KiazmaEnumerationComboClass;

struct _KiazmaEnumerationCombo {
	GtkComboBox			combo;
};

struct _KiazmaEnumerationComboClass {
	GtkComboBoxClass			parent_class;
	void ( *kiazma_enumeration_combo )	( KiazmaEnumerationCombo *synp );
};

GType		kiazma_enumeration_combo_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_enumeration_combo_new				( HYPPO_ENUMERATIONS enumeration );

#endif /* KIAZMA_ENUMERATION_COMBO_H */
