/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
	GTK - The GIMP Toolkit
	Copyright (C) 2000 Red Hat, Inc.
	Modified by the GTK+ Team and others 1997-2003
*/

/**
	@file		kiazma_input_dialog.c
*/

#include "libkiazma.h"
#include "kiazma_input_dialog.h"

/**
	@internal

	@param	klass	Instance of the class to init
*/
static void kiazma_input_dialog_class_init ( KiazmaInputDialogClass *klass ) {
}

/**
	Init components for a KiazmaInputDialog

	@param	ttt		The KiazmaInputDialog to init
*/
static void kiazma_input_dialog_init ( KiazmaInputDialog *ttt ) {
	GtkWidget *main_box;
	GtkWidget *vbox;

	main_box = gtk_hbox_new ( FALSE, 2 );
	gtk_box_pack_start ( GTK_BOX ( ttt->main_win.vbox ), main_box, TRUE, TRUE, 0 );

	ttt->icon = gtk_image_new_from_stock ( NULL, GTK_ICON_SIZE_DIALOG );
	gtk_misc_set_alignment ( GTK_MISC ( ttt->icon ), 0.5, 0.0 );
	gtk_box_pack_start ( GTK_BOX ( main_box ), ttt->icon, TRUE, TRUE, 0 );

	vbox = gtk_vbox_new ( FALSE, 2 );
	gtk_box_pack_start ( GTK_BOX ( main_box ), vbox, FALSE, FALSE, 0 );

	ttt->text = gtk_label_new ( NULL );
	gtk_label_set_line_wrap ( GTK_LABEL ( ttt->text ), TRUE );
	gtk_label_set_selectable ( GTK_LABEL ( ttt->text ), TRUE );
	gtk_misc_set_alignment ( GTK_MISC ( ttt->text ), 0.0, 0.0 );
	gtk_box_pack_start ( GTK_BOX ( vbox ), ttt->text, FALSE, FALSE, 0 );

	ttt->user_container = gtk_hbox_new ( TRUE, 5 );
	gtk_box_pack_start ( GTK_BOX ( vbox ), ttt->user_container, FALSE, FALSE, 0 );
}

/**
	Registers a new type for the KiazmaInputDialog class

	@return			The registered type for the widget
*/
GType kiazma_input_dialog_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaInputDialogClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_input_dialog_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaInputDialog ),
			0,
			( GInstanceInitFunc ) kiazma_input_dialog_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_DIALOG, "KiazmaInputDialog", &ttt_info, 0 );
	}

	return ttt_type;
}

/**
*/
GtkWidget* kiazma_input_dialog_new ( gchar *title, gchar *text, GtkMessageType type,
					GtkButtonsType buttons, GtkWidget *input, ... ) {

	va_list widgets;
	GtkWidget *new_item;
	GtkWidget *in;
	KiazmaInputDialog *dialog;

	new_item = GTK_WIDGET ( g_object_new ( kiazma_input_dialog_get_type (), NULL ) );
	dialog = KIAZMA_INPUT_DIALOG ( new_item );
	gtk_window_set_title ( GTK_WINDOW ( &( dialog->main_win ) ), title );

	switch ( type ) {
		case GTK_MESSAGE_INFO:
			gtk_image_set_from_stock ( GTK_IMAGE ( dialog->icon ),
							"GTK_STOCK_DIALOG_INFO", GTK_ICON_SIZE_DIALOG );
			break;

		case GTK_MESSAGE_WARNING:
			gtk_image_set_from_stock ( GTK_IMAGE ( dialog->icon ),
							"GTK_STOCK_DIALOG_WARNING", GTK_ICON_SIZE_DIALOG );
			break;

		case GTK_MESSAGE_QUESTION:
			gtk_image_set_from_stock ( GTK_IMAGE ( dialog->icon ),
							"GTK_STOCK_DIALOG_QUESTION", GTK_ICON_SIZE_DIALOG );
			break;

		case GTK_MESSAGE_ERROR:
			gtk_image_set_from_stock ( GTK_IMAGE ( dialog->icon ),
							"GTK_STOCK_DIALOG_ERROR", GTK_ICON_SIZE_DIALOG );
			break;

		default:
			g_warning ( "Unknown GtkMessageType\n" );
			break;
	}

	switch ( buttons ) {
		case GTK_BUTTONS_NONE:
			/* nothing */
			break;

		case GTK_BUTTONS_OK:
			gtk_dialog_add_button ( &( dialog->main_win ), GTK_STOCK_OK, GTK_RESPONSE_OK );
			break;

		case GTK_BUTTONS_CLOSE:
			gtk_dialog_add_button ( &( dialog->main_win ), GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE );
			break;

		case GTK_BUTTONS_CANCEL:
			gtk_dialog_add_button ( &( dialog->main_win ), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL );
			break;

		case GTK_BUTTONS_YES_NO:
			gtk_dialog_add_button ( &( dialog->main_win ), GTK_STOCK_NO, GTK_RESPONSE_NO );
			gtk_dialog_add_button ( &( dialog->main_win ), GTK_STOCK_YES, GTK_RESPONSE_YES );
			break;

		case GTK_BUTTONS_OK_CANCEL:
			gtk_dialog_add_button ( &( dialog->main_win ), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL );
			gtk_dialog_add_button ( &( dialog->main_win ), GTK_STOCK_OK, GTK_RESPONSE_OK );
			break;

		default:
			g_warning ( "Unknown GtkButtonsType\n" );
			break;
	}

	gtk_label_set_text ( GTK_LABEL ( dialog->text ), text );

	gtk_box_pack_start ( GTK_BOX ( dialog->user_container ), input, TRUE, TRUE, 0 );
	va_start ( widgets, input );

	while ( ( in = va_arg ( widgets, GtkWidget* ) ) != NULL )
		gtk_box_pack_start ( GTK_BOX ( dialog->user_container ), in, TRUE, TRUE, 0 );

	va_end ( widgets );
	return new_item;
}
