/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_metadata_collector.c
*/

#include "libkiazma.h"
#include "kiazma_metadata_collector.h"

enum {
	KIAZMA_MC_ADD,
	KIAZMA_MC_DEL,
	KIAZMA_MC_END_SIGNALS
};

static guint KiazmaMetadataCollectorSignals [ KIAZMA_MC_END_SIGNALS ];

/**
	@internal

	Init the class for KiazmaMetadataCollector

	@param	klass		Instance of the class to init
*/
static void kiazma_metadata_collector_class_init ( KiazmaMetadataCollectorClass *klass ) {
	GObjectClass *gobject_class;

	gobject_class = ( GObjectClass* ) klass;

	KiazmaMetadataCollectorSignals [ KIAZMA_MC_ADD ] = g_signal_new ( g_intern_static_string ( "item_added" ),
						G_TYPE_FROM_CLASS ( gobject_class ), G_SIGNAL_RUN_FIRST, 0, NULL, NULL,
						g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0 );

	KiazmaMetadataCollectorSignals [ KIAZMA_MC_DEL ] = g_signal_new ( g_intern_static_string ( "item_removed" ),
						G_TYPE_FROM_CLASS ( gobject_class ), G_SIGNAL_RUN_FIRST, 0, NULL, NULL,
						g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0 );
}

/**
*/
static GtkWidget* do_edit_dialog ( UINT64 init_meta, gchar *init_value, GtkWidget **chooser ) {
	GtkWidget *dialog;

	dialog = gtk_dialog_new_with_buttons ( _( "Edit Collected Metadata" ), NULL, GTK_DIALOG_MODAL,
						GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL );

	*chooser = kiazma_metadata_chooser_new ();
	kiazma_metadata_chooser_fill_with_complete_range ( KIAZMA_METADATA_CHOOSER ( *chooser ) );

	if ( init_value )
		kiazma_metadata_chooser_set ( KIAZMA_METADATA_CHOOSER ( *chooser ), init_meta, init_value );

	gtk_box_pack_start ( GTK_BOX ( GTK_DIALOG ( dialog )->vbox ), *chooser, TRUE, TRUE, 0 );
	gtk_widget_show_all ( dialog );
	return dialog;
}

/**
*/
static void add_metadata_in_collection ( GtkButton *button, KiazmaMetadataCollector *ttt ) {
	UINT64 meta;
	gchar *value;
	GtkWidget *dialog;
	GtkWidget *sel;
	GtkTreeIter iter;

	dialog = do_edit_dialog ( 0LL, NULL, &sel );
	if ( gtk_dialog_run ( GTK_DIALOG ( dialog ) ) == GTK_RESPONSE_OK ) {
		if ( kiazma_metadata_chooser_get ( KIAZMA_METADATA_CHOOSER ( sel ), &meta, &value ) ) {
			gtk_tree_store_append ( ttt->list_model, &iter, NULL );
			gtk_tree_store_set ( ttt->list_model, &iter, 0, hyppo_metadata_translate_in_string ( meta ),
						1, value, 2, meta, -1 );

			g_free ( value );
			g_signal_emit ( ttt, KiazmaMetadataCollectorSignals [ KIAZMA_MC_ADD ], 0 );
		}
	}

	gtk_widget_destroy ( dialog );
}

/**
*/
static void remove_metadata_from_collection ( GtkButton *button, KiazmaMetadataCollector *ttt ) {
	GtkTreeIter child;

	if ( gtk_tree_selection_get_selected ( ttt->list_selector, ( GtkTreeModel** ) &( ttt->list_model ), &child ) ) {
		gtk_tree_store_remove ( ttt->list_model, &child );
		g_signal_emit ( ttt, KiazmaMetadataCollectorSignals [ KIAZMA_MC_DEL ], 0 );
	}
}

/**
*/
static void edit_metadata_in_collection ( GtkButton *button, KiazmaMetadataCollector *ttt ) {
	UINT64 meta;
	gchar *value;
	GtkWidget *dialog;
	GtkWidget *sel;
	GtkTreeIter child;

	if ( gtk_tree_selection_get_selected ( ttt->list_selector, ( GtkTreeModel** ) &( ttt->list_model ), &child ) ) {
		gtk_tree_model_get ( ( GtkTreeModel* ) ttt->list_model, &child, 1, &value, 2, &meta, -1 );
		dialog = do_edit_dialog ( meta, value, &sel );
		g_free ( value );

		if ( gtk_dialog_run ( GTK_DIALOG ( dialog ) ) == GTK_RESPONSE_OK ) {
			if ( kiazma_metadata_chooser_get ( KIAZMA_METADATA_CHOOSER ( sel ), &meta, &value ) ) {
				gtk_tree_store_set ( ttt->list_model, &child, 0, hyppo_metadata_translate_in_string ( meta ),
							1, value, 2, meta, -1 );

				g_free ( value );
			}
		}

		gtk_widget_destroy ( dialog );
	}
}

/**
	@internal

	@param	ttt
*/
static void kiazma_metadata_collector_init ( KiazmaMetadataCollector *ttt ) {
	GtkWidget *buttons;

	gtk_container_set_border_width ( GTK_CONTAINER ( ttt ), 0 );
	gtk_box_set_homogeneous ( GTK_BOX ( ttt ), FALSE );

	/*** lista medatati ***/

	ttt->list_model = gtk_tree_store_new ( 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT64 );
	ttt->list = gtk_tree_view_new_with_model ( GTK_TREE_MODEL ( ttt->list_model ) );

	ttt->list_selector = gtk_tree_view_get_selection ( GTK_TREE_VIEW ( ttt->list ) );
	gtk_tree_selection_set_mode ( ttt->list_selector, GTK_SELECTION_BROWSE );
	gtk_tree_view_insert_column_with_attributes ( GTK_TREE_VIEW ( ttt->list ), 0, _( "Metadata" ),
							gtk_cell_renderer_text_new (), "text", 0, NULL );
	gtk_tree_view_insert_column_with_attributes ( GTK_TREE_VIEW ( ttt->list ), 1, _( "Value" ),
							gtk_cell_renderer_text_new (), "text", 1, NULL );
	gtk_box_pack_start ( GTK_BOX ( ttt ), ttt->list, TRUE, TRUE, 0 );

	/*** pulsanti ***/

	buttons = gtk_vbox_new ( TRUE, 2 );

	ttt->add_button = kiazma_button_stock_new ( GTK_STOCK_ADD );
	gtk_box_pack_start ( GTK_BOX ( buttons ), ttt->add_button, FALSE, FALSE, 0 );
	g_signal_connect ( G_OBJECT ( ttt->add_button ), "clicked", G_CALLBACK ( add_metadata_in_collection ), ttt );
	ttt->remove_button = kiazma_button_stock_new ( GTK_STOCK_REMOVE );
	gtk_box_pack_start ( GTK_BOX ( buttons ), ttt->remove_button, FALSE, FALSE, 0 );
	g_signal_connect ( G_OBJECT ( ttt->remove_button ), "clicked", G_CALLBACK ( remove_metadata_from_collection ), ttt );
	ttt->edit_button = kiazma_button_stock_new ( GTK_STOCK_EDIT );
	gtk_box_pack_start ( GTK_BOX ( buttons ), ttt->edit_button, FALSE, FALSE, 0 );
	g_signal_connect ( G_OBJECT ( ttt->edit_button ), "clicked", G_CALLBACK ( edit_metadata_in_collection ), ttt );

	gtk_box_pack_start ( GTK_BOX ( ttt ), buttons, FALSE, FALSE, 0 );
}

/**
	@return
*/
GType kiazma_metadata_collector_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaMetadataCollectorClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_metadata_collector_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaMetadataCollector ),
			0,
			( GInstanceInitFunc ) kiazma_metadata_collector_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_HBOX, "KiazmaMetadataCollector", &ttt_info, 0 );
	}

	return ttt_type;
}

/**
	@return
*/
GtkWidget* kiazma_metadata_collector_new () {
	return GTK_WIDGET ( g_object_new ( kiazma_metadata_collector_get_type (), NULL ) );
}

/**
	@param	item
	@param	meta
*/
void kiazma_metadata_collector_add_item ( KiazmaMetadataCollector *item, UINT64 meta, gchar *value ) {
	GtkTreeIter iter;

	gtk_tree_store_append ( item->list_model, &iter, NULL );
	gtk_tree_store_set ( item->list_model, &iter, 0, hyppo_metadata_translate_in_string ( meta ), 1, value, 2, meta, -1 );
}

/**
	@param	item
	@param	meta
	@param	value

	@return
*/
gboolean kiazma_metadata_collector_get_first ( KiazmaMetadataCollector *item, UINT64 *meta, gchar **value ) {
	if ( gtk_tree_model_get_iter_first ( GTK_TREE_MODEL ( item->list_model ), &( item->current ) ) ) {
		gtk_tree_model_get ( GTK_TREE_MODEL ( item->list_model ), &( item->current ), 1, value, 2, meta, -1 );
		return TRUE;
	}
	else
		return FALSE;
}

/**
	@param	item
	@param	meta
	@param	value

	@return
*/
gboolean kiazma_metadata_collector_get_next ( KiazmaMetadataCollector *item, UINT64 *meta, gchar **value ) {
	if ( gtk_tree_model_iter_next ( GTK_TREE_MODEL ( item->list_model ), &( item->current ) ) ) {
		gtk_tree_model_get ( GTK_TREE_MODEL ( item->list_model ), &( item->current ), 1, value, 2, meta, -1 );
		return TRUE;
	}
	else
		return FALSE;
}

/**
*/
void kiazma_metadata_collector_reset ( KiazmaMetadataCollector *item ) {
	gtk_tree_store_clear ( item->list_model );
}
