/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_QUERY_EDITOR_H
#define KIAZMA_QUERY_EDITOR_H

#include "libkiazma.h"

#define KIAZMA_QUERY_EDITOR_TYPE			( kiazma_query_editor_get_type () )
#define KIAZMA_QUERY_EDITOR(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_QUERY_EDITOR_TYPE, KiazmaQueryEditor ) )
#define KIAZMA_QUERY_EDITOR_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_QUERY_EDITOR_TYPE, KiazmaQueryEditorClass ) )
#define IS_KIAZMA_QUERY_EDITOR(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_QUERY_EDITOR_TYPE ) )
#define IS_KIAZMA_QUERY_EDITOR_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_QUERY_EDITOR_TYPE ) )

typedef enum {
	KIAZME_QUERY_EDITOR_EASY,
	KIAZME_QUERY_EDITOR_EXPERT
} KiazmaQueryEditorMode;

typedef struct _KiazmaQueryEditor			KiazmaQueryEditor;
typedef struct _KiazmaQueryEditorClass			KiazmaQueryEditorClass;

struct _KiazmaQueryEditor {
	GtkDialog		main_win;
	GtkWidget		*modes_notebook;

	struct {
		GtkWidget	*selection;
		GtkWidget	*included;
		GtkWidget	*excluded;
		GtkWidget	*possible;
	} easy_mode_panel;

	struct {
		GtkWidget	*expressions;
	} expert_mode_panel;
};

struct _KiazmaQueryEditorClass {
	GtkDialogClass				parent_class;
	void ( *kiazma_query_editor )		( KiazmaQueryEditor *synp );
};

GType		kiazma_query_editor_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_query_editor_new				( KiazmaQueryEditorMode default_mode );
void		kiazma_query_editor_reset			( KiazmaQueryEditor *editor );
void		kiazma_query_editor_set_query			( KiazmaQueryEditor *editor, gchar *query );
gchar*		kiazma_query_editor_get_query			( KiazmaQueryEditor *editor );

#endif /* KIAZMA_QUERY_EDITOR_H */
