/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_MAIN_H
#define KIAZMA_MAIN_H

#define _GNU_SOURCE			1
#define _FILE_OFFSET_BITS		64

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <libintl.h>

#include <gtk/gtk.h>
#include <glib.h>

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>

#include <libhyppo.h>

#ifdef _
#undef _
#endif
#define	_(s)                            gettext(s)

#include "kiazma.h"

#include "kiazma_oms.h"

#include "kiazma_widget.h"
#include "kiazma_icon.h"
#include "kiazma_button_stock.h"
#include "kiazma_permissions.h"
#include "kiazma_hour.h"
#include "kiazma_time.h"
#include "kiazma_shortcut_editor.h"
#include "kiazma_uidlist.h"
#include "kiazma_gidlist.h"
#include "kiazma_enumeration_combo.h"
#include "kiazma_icon_stacked_view.h"
#include "kiazma_aligned.h"
#include "kiazma_frame.h"
#include "kiazma_spinner.h"
#include "kiazma_metadata_selector.h"
#include "kiazma_metadata_wrapper.h"
#include "kiazma_metadata_chooser.h"
#include "kiazma_metadata_set_chooser.h"
#include "kiazma_buttoned_box.h"
#include "kiazma_drawing_area.h"
#include "kiazma_metadata_collector.h"
#include "kiazma_metadata_set_collector.h"
#include "kiazma_query_editor.h"
#include "kiazma_input_dialog.h"

#endif /* KIAZMA_MAIN_H */
