/*  Synapse 0.1
 *  Copyright (C) 2006 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef SYNAPSE_MAIN_H
#define SYNAPSE_MAIN_H

#define _GNU_SOURCE			1
#define _FILE_OFFSET_BITS		64

#include <stdio.h>
#include <features.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>
#include <attr/xattr.h>
#include <sys/time.h>
#include <time.h>
#include <pwd.h>
#include <grp.h>
#include <dlfcn.h>

/**
	@bug	Per oscure motivazioni non riesco ad accedere ad alcune
		definizioni in limits.h, che dunque copio ed incollo qui.
		Sarebbe opportuno capire il motivo di tale scarsa
		collaborazione del preprocessore...
*/
#define LLONG_MAX	9223372036854775807LL
#define LLONG_MIN	(-LLONG_MAX - 1LL)
#define ULLONG_MAX	18446744073709551615ULL
#include <limits.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glib.h>
#include <libxfcegui4/libxfcegui4.h>

#include <libhyppo.h>
#include <libkiazma.h>

#ifdef _
#undef _
#endif
#define	_(s)                            gettext(s)

#define	SYNAPSE_IMAGES_PATH			"/usr/local/share/synapse/"

/**
	Larghezza di default della finestra primaria
*/
#define MAIN_WINDOW_WIDTH			600
/**
	Altezza di default della finestra primaria
*/
#define MAIN_WINDOW_HEIGHT			500

/**
	Path di default ove montare automaticamente il filesystem
*/
#define DEFAULT_PATH_TO_MOUNT			"/mnt/hyppo"

#define ICON_VIEW_NAME_COL			0
#define ICON_VIEW_ICON_COL			1
#define ICON_VIEW_ID_COL			2

/**
	Lunghezza massima dei nomi dei tabs
*/
#define MAX_TAB_NAME				20

/**
	Lunghezza massima del nome human readable di un metadato
*/
#define MAX_LENGHT_FOR_METADATA_NAME		200

#define MIN_LENGHT_FOR_KEYWORD_SEARCH		1

/**
	 @todo	Correggere questa definizione quando verranno aggiunti altri
		tipi di metadato, qualora ce ne fosse qualcuno fondamentale
*/
#define FUNDAMENTAL_METADATA_TO_SHOW		META_MIME

/**
	Attualmente questo e' uguale alla costante HYPPO_MAX_VALUE_SIZE
	definita in hyppocampus.h. Non includo quel file per ovvi motivi,
	e va considerato tra l'altro che questo limite nella dimensione dei
	valori assegnati ai metadati dovrebbe essere eliminato presto...
*/
#define MAX_VALUE_SIZE				256

/**
	Path relativa alla home directory dell'utente ove reperire i files di configurazione legati a Synapse
*/
#define DEFAULT_PATH_FOR_CONFIG_FILE		".synapse/"

#define DEFAULT_EXTERNAL_INSTALLER_NAME		"synapse_plugin_installer"
#define INSTALLER_PATH_MAX_LEN			100

/**
	Tipi di shortcut contemplate ed ammesse nel pannello di configurazione
*/
typedef enum {
	S_ADD_FILE,										/**< Shortcut per l'aggiunta di nuovi files nel filesystem Hyppocampus */
	S_REMOVE_FILE,										/**< Shortcut per eliminare un file */
	S_FILE_INFO,										/**< Shortcut per visualizzare il pannello delle informazioni del file selezionato */
	S_SELECT_ALL,										/**< Shortcut per selezionare tutti i files mostrati in un dato momento */

	S_OPEN_NEW_TAB,										/**< Shortcut per aprire una nuova tab */
	S_CLOSE_CURRENT_TAB,									/**< Shortcut per chiudere la tab corrente */
	S_PREV_TAB,										/**< Shortcut per switchare sulla tab precedente */
	S_NEXT_TAB,										/**< Shortcut per switchare sulla tab successiva */

	S_SWITCH_ADDRESS_BAR,									/**< Keyboard shortcut to switch the focus to the query bar */
	S_SWITCH_KEYWORD_SEARCH,								/**< Keyboard shortcut to switch the focus to the keywords search bar */
	S_HISTORY,										/**< Keyboard shortcut to open the history list */

	S_BOOKMARK_THIS,

	S_PREFERENCES_PANEL,
	S_QUERY_EDITOR,

	S_MAX_SHORTCUTS										/**< Tappo della enum */
} ShortcutsTypes;

/**
	Struttura descrittiva di una tab
*/
typedef struct {
	gchar			*query;								/**< Query correntemente usata e visualizzata */
	gchar			label [ MAX_TAB_NAME ];						/**< Label della tab */
	GtkWidget		*button;							/**< Pulsante posizionato sulla linguetta che permette di accedere alla tab */
	GtkTreeStore		*icons;								/**< Modello che ospita gli elementi correntemente visualizzati */
	GtkWidget		*view;								/**< Struttura grafica usata per ordinare le icone mostrate */
	gchar			*status;							/**< Stringa correntemente stampata nella barra di stato per la tab */
} PageDesc;

/**
	Struttura riassuntiva di una shortcut. In Configurations::shortcut si
	trova un array composto di strutture di questo tipo, per cui ad un
	dato indice e' presente la descrizione della shortcut corrispettiva
	secondo la enumerazione in ShortcutsTypes
*/
typedef struct {
	GdkModifierType		modifier;							/**< Identificativo del modifier (Alt, Ctrl, Shift...) usato per la shortcut */
	guint			key;								/**< Codice identificativo del pulsante che, se premuto insieme al rispettivo modifier, provoca l'esecuzione della shortcut */
} KShortcut;

/**
	Struttura descrittiva degli elementi fondamentali dell'applicazione:
	qui sono riassunti tutti gli elementi grafici (e non) fondamentali
*/
typedef struct {
	GtkWidget		*main_win;							/**< La finestra principale dell'applicazione */
	GtkWidget		*main_box;							/**< La GtkBox principale, in cui si trovano gli altri elementi divisi in toolbar / icon view / status bar */
	GtkWidget		*main_menu;							/**< Qui viene mantenuto il riferimento al menu contestuale generico */

	UINT64			current_file;
	GtkWidget		*element_menu;							/**< Qui viene mantenuto il riferimento al menu contestuale specifico per i files */

	GtkWidget		*toolbar;							/**< Toolbar, l'elemento che appare in alto nell'applicazione */
	GtkWidget		*query_text;							/**< La barra in cui vengono immesse le query. Essendo una GtkComboBoxEntry contiene anche la history delle query eseguite */
	GtkWidget		*query_clear;							/**< Pulsante per la cancellazione della query corrente */
	GtkWidget		*query_start;							/**< */

	GtkWidget		*keywords_text;							/**< */
	GtkEntryCompletion	*keywords_list;							/**< */

	GtkWidget		*notebook;							/**< Widget multi pagina che contiene i vari tab */
	GList			*tabs;								/**< Lista delle tab aperte */
	PageDesc		*running;							/**< Puntatore alla tab correntemente selezionata */

	GtkWidget		*status;							/**< Barra di stato, ospita qualche informazione generica */
	GtkWidget		*progress;							/**< Barra di progressione, viene usata come indice del tempo trascorso durante l'esecuzione di una query */

	GtkWidget		*composer;							/**< La finestra principale per l'editor di query */
	GtkWidget		*editor;							/**< L'editor grafico di query */

	GtkTooltips		*tooltips_group;						/**< */
	GtkAccelGroup		*accel_group;							/**< */

	GtkIconTheme		*icons_theme;
} GraphicTemplate;

/*
	main.c
*/

extern GraphicTemplate		Graph;
extern char			*MountedPath;
extern gchar			ReverseTranslations [ METADATA_END ] [ MAX_LENGHT_FOR_METADATA_NAME ];

inline void	update_status_bar			( gchar *string );
inline void	update_status_progress			( int parts, int completed );
gboolean	button_press_event			( GtkWidget *icon_view, GdkEventButton *ev, gpointer data );
gboolean	wrapper_view_open_file			( GtkWidget *icon_view, GtkTreePath *path, gpointer data );
gboolean	key_press_event				( GtkWidget *icon_view, GdkEventKey *ev, gpointer data );

/*
	tabs.c
*/

void		create_tab			();
gboolean	notebook_page_switched		( GtkNotebook *notebook, GtkNotebookPage *page, guint pos, gpointer data );
gboolean	update_tab_query		( GtkComboBox *combo, gpointer data );
void		remove_tab			( PageDesc *tab );
void		free_page_desc_for_tab		( gpointer tab, gpointer data );

/*
	query.c
*/

gboolean	clear_query			( GtkButton *button, gpointer data );
void		run_query			( gchar *query );
void		start_query			();
gboolean	do_collective_query		( GtkMenuItem *item, gpointer data );
gboolean	prev_query			( GtkButton *button, gpointer data );
gboolean	next_query			( GtkButton *button, gpointer data );

/*
	conf.c
*/

#define MAX_TERMINAL_COMMAND_STRING_LEN		100

/**
	Struttura che contiene tutte le configurazioni dell'applicazione
*/
typedef struct {
	gboolean		ask_remove_confirm;						/**< TRUE se deve essere richiesta la conferma dell'utente prima di rimuovere uno o piu' files */
	gboolean		show_tooltips;

	KShortcut		shortcuts [ S_MAX_SHORTCUTS ];					/**< Array delle shortcut abilitate */

	gboolean		enable_actions;
	gchar			action_in_terminal_command [ MAX_TERMINAL_COMMAND_STRING_LEN ];
} Configurations;

extern Configurations		Confs;

void		show_preferences		();
void		load_config			();

/*
	utils.c
*/
inline void		fileid_by_path			( GtkTreePath *path, UINT64 *fileid );
inline void		path_by_id			( UINT64 fileid, gchar *filename );
void			init_reverse_translations	();
inline UINT64		reverse_translation		( gchar *string );
inline GtkEntry*	query_label_reference		();
inline size_t		dirent_buf_size			( DIR *dirp );
void			set_tooltip			( GtkWidget *item, gchar *text, ShortcutsTypes shortcut );
inline void		enable_tooltips			();
gchar*			get_system_path			( gchar *file );

/*
	keyword_search.c
*/

gboolean		incremental_keyword_search	( GtkEntry *entry, gpointer user_data );
gboolean		open_file_selected_by_keyword	( GtkEntryCompletion *widget, GtkTreeModel *model, GtkTreeIter *iter, gpointer user_data );

/*
	bookmarks.c
*/

extern GBookmarkFile		*Bookmarks;
extern gchar			**Uris;

void			read_bookmarks			();
void			add_current_to_bookmarks	();
GtkWidget*		do_bookmarks_menu		();

/*
	actions.c
*/

typedef struct {
	UINT64			meta;
	gchar			*value;
} ActionConstraintDesc;

typedef struct {
	UINT64			current_file;
	gchar			*name;
	GList			*constraints;
	gchar			*command;
	gboolean		in_terminal;
} ActionDesc;

void			load_actions			();
void			add_menu_actions		( GtkWidget *menu, UINT64 fileid, GList *metas );
GList*			action_get_all			();
void			action_destroy_list		( GList *list );
void			action_destroy			( ActionDesc *garbage );
void			action_destroy_constraints	( ActionDesc *action );
GList*			action_duplicate_list		( GList *list );
void			action_replace			( GList *nuova );
void			save_actions_to_file		();
GList*			read_actions_from_file		( GIOChannel *file );
void			write_action_to_file		( ActionDesc *act, FILE *file );
void			close_actions			();

/*
	history.c
*/

void			load_history			();
void			save_in_history			( gchar *query );
gchar*			history_last			();

/*
	widgets.c
*/

#define SYNAPSE_FILE_PANEL_TYPE			( synapse_file_panel_get_type () )
#define SYNAPSE_FILE_PANEL(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), SYNAPSE_FILE_PANEL_TYPE, SynapseFilePanel ) )
#define SYNAPSE_FILE_PANEL_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), SYNAPSE_FILE_PANEL_TYPE, SynapseFilePanelClass ) )
#define IS_SYNAPSE_FILE_PANEL(obj)		( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), SYNAPSE_FILE_PANEL_TYPE ) )
#define IS_SYNAPSE_FILE_PANEL_CLASS(klass)	( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), SYNAPSE_FILE_PANEL_TYPE ) )

typedef struct _SynapseFilePanel	SynapseFilePanel;
typedef struct _SynapseFilePanelClass	SynapseFilePanelClass;

struct _SynapseFilePanel {
	GtkDialog		main_win;
	UINT64			file;
	int			mimetype;
	GList			*attrs;
	GtkWidget		*system_meta;
	GtkWidget		*general_meta;
	GtkWidget		*mime_meta;
	GtkWidget		*other_meta;
	GtkWidget		*mime_adder;
	GtkWidget		*other_adder;
};

struct _SynapseFilePanelClass {
	GtkDialogClass			parent_class;
	void ( *synapse_file_panel )	( SynapseFilePanel *synp );
};

GType		synapse_file_panel_get_type	();
GtkWidget*	synapse_file_panel_new		( UINT64 fileid );
void		synapse_file_panel_destroy	( SynapseFilePanel *panel );

#endif /* SYNAPSE_MAIN_H */
