#    $Id: irclog_confclass.py,v 1.5 2001/12/16 15:55:51 tilk Exp $
#    tilkIRClog
#    Copyright (C) 2001  Marek "Tilk" Materzok
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import irclog_configuration

import os
import time

class ConfClass:
    def __init__(self):
	self.conffile = "%s/irclog_configuration.py" % irclog_configuration.directory
	self.confts = os.stat(self.conffile)[8]
	self.prvtime = time.time()
	self.confdict = {}
	self.wasupdated = None
	self.update()
	self.locked = None

    def lock(self):
	self.locked = 1

    def unlock(self):
	self.locked = None

    def update(self):
	execfile (self.conffile, self.confdict)

    def newconfig(self):
	if self.wasupdated:
	    self.wasupdated = None
	    return 1
	return None

    def __getattr__(self,name):
	curtime = time.time()
	if curtime - self.__dict__["prvtime"] > 60 and not self.__dict__["locked"]:
	    self.__dict__["prvtime"] = curtime
	    ts = os.stat(self.conffile)[8]
	    if ts > self.__dict__["confts"]:
		self.__dict__["confts"] = ts
		self.update()
		self.__dict__["wasupdated"] = 1
	if self.__dict__["confdict"].has_key(name):
	    return self.__dict__["confdict"][name]
	return None

irclog_config = ConfClass()

