# $Id: irclog_configuration.py,v 1.12 2002/07/02 07:37:11 tilk Exp $
# WARNING: tilkirclog doesn't check config file for errors!

# Logger configuration

# directory with scripts, must be writable
directory = "/path/to/irclog"
# list of servers (tuples ("server",port) or ("server",port,"password")) 
servers = [("server1",6667),("server2",6667,"password")]
# sequence of nicks to use (when using services, first will be autorecovered)
nicks = ["nick1","nick2"]
# channels, in which tilkirclog will log traffic (please use lowercase!)
channels = ["#chan1","#chan2"]
# default ident
ident = "ident"
# vhost to use (None to disable)
vhost = "vhost"
# the away message for tilkIRClog (it will always be away!)
awaymsg = "Away"
# realname for tilkIRClog
realname = "TilkIRClog"
# quit message
quitmsg = "No more logging :>"
# password for admin commands
password = "password"
# encoding of password; can be "plain", "MD5" or "SHA1"
pass_hash = "plain"
# hostmask allowed to use admin commands (can be more than one!)
adminhosts = ["Admin*!*you@*.you.com"]
# can be "left", "right" or None
indent_nick = "right"
# on which line we should wrap text? (None = disable)
line_wrap = 76
# timestamp each line? ("dmyhms", "dmhms", "hms", "hm" or None)
timestamp = "hms"
# ignorelist
ignorelist = ["ChanServ", "OperServ", "NickServ"]
# format messages like MIRC? 1 or None
mircformat = None
# decode colors? 1 or None
decodecolors = 1

# Mailsender configuration

# e-mails to which send logs
emails = {"private": ["your@mail"], "#chan1": ["mail@one","mail@two"], "#chan2": ["your@mail","mail@two"]}
# sendmail command
sendmail = "/usr/sbin/sendmail -t"
# an e-mail, from which logs come from
srcmail = "your@mail"
# To: header of all outgoing logs (None - no To: line, "public" - receivers
#  in To: header, all other - content of To: header)
dstmail = None
# hour, at which mail is sended (0..23) must be integer
sendhour = 5
# subject ( %(n)s is name of channel, %(d)s is current date)
subject = "New IRClog from %(n)s (%(d)s)"
# output charset (used only when logs not gzipped)
charset = "iso-8859-1"
# Default compression ("ZIP", "GZ", "BZ2" or None)
compress = "GZ"
# Compression for certain emails
compmail = {"mail@one": "ZIP", "mail@two": None}
# Archivize which logs?
archivize = ["private", "#chan2"]
# How to compress archivized logs?
comparch = "BZ2"
# Directory for archives
archdir = directory + "/archives/"

# Services configuration

# use services or not (1 or None)
use_services = None
# nickserv name
nickserv = "NickServ"
# chanserv name
chanserv = "ChanServ"
# password for Services
services_password = "services_pass"
# services privileges at channels 10 = sop, 5 = op, 3 = voice
serv_privs = {"#chan1": 5, "#chan2": 3}
