// Combination_attributes.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/graphics/base/Combination_attributes.hpp>
#include <tovero/graphics/base/Color.hpp>
#include <tovero/graphics/base/Shader.hpp>

using namespace Roan_trail::Tovero_graphics;

//
// Constructors/copy
//

Combination_attributes::Combination_attributes()
  : m_shader(0),
    m_material_code(0),
    m_color(0),
    m_is_part(false),
    m_children_inherit(false)
{
}

Combination_attributes::Combination_attributes(Shader *shader,
                                               int material_code,
                                               Color *color,
                                               bool is_part,
                                               bool children_inherit)
  : m_shader(shader),
    m_material_code(material_code),
    m_color(color),
    m_is_part(is_part),
    m_children_inherit(children_inherit)
{
  if (m_shader)
  {
    m_shader->reference();
  }
  if (m_color)
  {
    m_color->reference();
  }
}


Combination_attributes::Combination_attributes(const Combination_attributes& attributes)
  : Reference_counting_base(attributes),
    m_shader(0),
    m_material_code(attributes.m_material_code),
    m_color(0),
    m_is_part(attributes.m_is_part),
    m_children_inherit(attributes.m_children_inherit)
{
  set_shader(attributes.m_shader);
  set_color(attributes.m_color);
}

Combination_attributes& Combination_attributes::operator=(const Combination_attributes& attributes)
{
  if (this != &attributes)
  {
    Reference_counting_base::operator=(attributes);
    set_shader(attributes.m_shader);
    m_material_code = attributes.m_material_code;
    set_color(attributes.m_color);
    m_is_part = attributes.m_is_part;
    m_children_inherit = attributes.m_children_inherit;
  }

  return *this;
}

//
// Accessors/mutators
//

void Combination_attributes::set_shader(Shader* shader)
{
  if (m_shader != shader)
  {
    if (shader)
    {
      shader->reference();
    }
    if (m_shader)
    {
      m_shader->unreference();
    }
    m_shader = shader;
  }
}

void Combination_attributes::set_color(Color* color)
{
  if (m_color != color)
  {
    if (color)
    {
      color->reference();
    }
    if (m_color)
    {
      m_color->unreference();
    }
    m_color = color;
  }
}

//
// Protected member functions
//

//
//   Destructor
//

Combination_attributes::~Combination_attributes()
{
  if (m_color)
  {
    m_color->unreference();
  }
  if (m_shader)
  {
    m_shader->unreference();
  }
}
