// Light_shader.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.
//
// Based on: ./src/liboptical/sh_light.c from BRL-CAD (version 7.20.4)
// source:
//
//   Copyright (c) 1998-2011 United States Government as represented by
//   the U.S. Army Research Laboratory.
//
//   This library is free software; you can redistribute it and/or
//   modify it under the terms of the GNU Lesser General Public License
//   version 2.1 as published by the Free Software Foundation.
//
//   This library is distributed in the hope that it will be useful, but
//   WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the GNU Lesser General Public
//   License along with this file; see the file named COPYING for more
//   information.

#include <tovero/graphics/base/Light_shader.hpp>
#include <tovero/math/geometry/Angle.hpp>
#include <tovero/math/geometry/Unit_vector.hpp>
#include <tovero/math/geometry/Unitless.hpp>
#include <string>

using std::string;
using Roan_trail::Tovero_math::Angle;
using Roan_trail::Tovero_math::Unit_vector;
using Roan_trail::Tovero_math::Unitless;
using namespace Roan_trail::Tovero_graphics;

//
// Constructors/copy
//

Light_shader::Light_shader(const string& name)
  : Shader(name),
    m_target_direction(Unit_vector(Unitless(0.0), Unitless(0.0), Unitless(0.0))),
    m_intensity(1.0),
    m_beam_dispersion_angle(180.0 * Angle::degree),
    m_fraction(1.0),
    m_shadow_ray_count(1),
    m_is_infinite(false),
    m_is_visible(true)
{
}

Light_shader::Light_shader(const Unit_vector& target_direction,
                           const Unitless& intensity,
                           const Angle& beam_dispersion_angle,
                           const Unitless& fraction,
                           int shadow_ray_count,
                           bool infinite,
                           bool visible,
                           const string& name)
  : Shader(name),
    m_target_direction(target_direction),
    m_intensity(intensity),
    m_beam_dispersion_angle(beam_dispersion_angle),
    m_fraction(fraction),
    m_shadow_ray_count(shadow_ray_count),
    m_is_infinite(infinite),
    m_is_visible(visible)
{
}

Light_shader::Light_shader(const Light_shader& shader)
  : Shader(shader)
{
  m_target_direction = shader.m_target_direction;
  m_intensity = shader.m_intensity;
  m_beam_dispersion_angle = shader.m_beam_dispersion_angle;
  m_fraction = shader.m_fraction;
  m_shadow_ray_count = shader.m_shadow_ray_count;
  m_is_infinite = shader.m_is_infinite;
  m_is_visible = shader.m_is_visible;
}

Light_shader& Light_shader::operator=(const Light_shader& shader)
{
  if (this != &shader)
  {
    m_target_direction = shader.m_target_direction;
    m_intensity = shader.m_intensity;
    m_beam_dispersion_angle = shader.m_beam_dispersion_angle;
    m_fraction = shader.m_fraction;
    m_shadow_ray_count = shader.m_shadow_ray_count;
    m_is_infinite = shader.m_is_infinite;
    m_is_visible = shader.m_is_visible;

    Shader::operator=(shader);
  }

  return *this;
}
