// Operation.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/graphics/base/Operation.hpp>
#include <tovero/graphics/base/Combination_attributes.hpp>
#include <tovero/math/geometry/Solid_operand.hpp>
#include <tovero/math/geometry/Solid_operation.hpp>
#include <tovero/math/geometry/Solid_operator.hpp>
#include <tovero/support/Reference_counting_list.hpp>
#include <string>

using std::string;
using Roan_trail::Tovero_support::Reference_counting_list;
using Roan_trail::Tovero_math::Solid_operand;
using Roan_trail::Tovero_math::Solid_operation;
using Roan_trail::Tovero_math::Solid_operator;
using namespace Roan_trail::Tovero_graphics;

//
// Constructor/copy
//

Operation::Operation(Solid_operand& left_operand,
                     Solid_operand& right_operand,
                     Solid_operator::Solid_operator_type op,
                     Combination_attributes* attributes, // referenced, not const
                     const string& name)
  : Solid_operation(left_operand,
                    right_operand,
                    op,
                    name),
    m_attributes(attributes)
{
  if (m_attributes)
  {
    m_attributes->reference();
  }
}

Operation::Operation(const Operation& o)
  : Solid_operation(o)
{
  set_attributes(o.m_attributes);
}

Operation& Operation::operator=(const Operation& o)
{
  if (this != &o)
  {
    Solid_operation::operator=(o);
    set_attributes(o.m_attributes);
  }

  return *this;
}

//
// Accessors/mutators
//

void Operation::set_attributes(Combination_attributes* attributes)
{
  if (m_attributes != attributes)
  {
    if (attributes)
    {
      attributes->reference();
    }
    if (m_attributes)
    {
      m_attributes->unreference();
    }
    m_attributes = attributes;
  }
}

//
// Protected member functions
//

//
//   Destructor
//

Operation::~Operation()
{
  if (m_attributes)
  {
    m_attributes->unreference();
  }
}

