// Operation.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Solid composed of a boolean operation of two other solids

#ifndef TOVERO_GRAPHICS_OPERATION_HPP_
#define TOVERO_GRAPHICS_OPERATION_HPP_

#include <tovero/math/geometry/Solid_operation.hpp>
#include <tovero/math/geometry/Solid_operator.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Solid_operand;
  }

  namespace Tovero_graphics
  {
    class Combination_attributes;

    class Operation : public Tovero_math::Solid_operation
    {
    public:
      // constructor/copy
      Operation(Tovero_math::Solid_operand& left_operand, // Note: referenced, not const
                Tovero_math::Solid_operand& right_operand, // Note: referenced, not const
                Tovero_math::Solid_operator::Solid_operator_type op
                = Tovero_math::Solid_operator::union_op, // (check_code_ignore)
                Combination_attributes* attributes = 0, // Note: referenced, not const
                const std::string& name = "");
      Operation(const Operation& o);
      Operation& operator=(const Operation& o);
      virtual Solid* clone_solid() const { return new Operation(*this); }
      // accessors/mutators
      // Note: referenced, not returned as const:
      Combination_attributes* attributes() const { return m_attributes; }
      void set_attributes(Combination_attributes* attributes);
      // other
      virtual std::string solid_class() const { return "Operation"; }
    protected:
      // destructor
      virtual ~Operation();
    private:
      Combination_attributes* m_attributes;
    };
  }
}

#endif // TOVERO_GRAPHICS_OPERATION_HPP_
