// Toon_shader.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_GRAPHICS_TOON_SHADER_HPP_
#define TOVERO_GRAPHICS_TOON_SHADER_HPP_

#include <tovero/graphics/base/Shader.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Toon_shader : public Shader
    {
    public:
      // constructors/copy
      Toon_shader(const std::string& name = "");
      //   Note: let compiler generate copy constructor and operator=
      // visitor
      virtual Shader_visitor::Visit_result accept(Shader_visitor& visitor) const { return visitor.visit(*this); }
    protected:
      virtual ~Toon_shader() {}
    };

  }
}

#endif // TOVERO_GRAPHICS_TOON_SHADER_HPP_
