// BC_combination_attributes.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Class to convert back and forth between Tovero combination
// attributes and BRL-CAD combination attributes

#ifndef TOVERO_GRAPHICS_BC_COMBINATION_ATTRIBUTES_HPP_
#define TOVERO_GRAPHICS_BC_COMBINATION_ATTRIBUTES_HPP_

#include <tovero/graphics/brlcad/BC_shader.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class BC_shader;
    class Combination_attributes;

    class BC_combination_attributes
    {
    public:
      // constructor/destructor
      //   construct from Tovero combination attributes
      BC_combination_attributes(Combination_attributes& attributes);
      //   construct from BRL-CAD combination attributes
      BC_combination_attributes(const std::string& shader,
                                int material,
                                const unsigned char* color,
                                bool is_region,
                                bool children_inherit);
      ~BC_combination_attributes();
      // accessors
      //   BRL-CAD combination attributes
      const std::string& shader_name() const { return m_BC_shader->shader_name(); }
      const std::string& shader_args() const { return m_BC_shader->shader_args(); }
      const int material() const { return m_material; }
      bool is_region() const { return m_is_region; }
      bool children_inherit() const { return m_children_inherit; }
      void copy_color(unsigned char color[3]) const;
      //   Tovero combination attributes
      //     reference counted, not returned as const:
      Combination_attributes* attributes() const { return m_attributes; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      int m_material;
      unsigned char *m_color;
      bool m_is_region;
      bool m_children_inherit;
      //
      Combination_attributes* m_attributes;
      BC_shader* m_BC_shader;
    };
  }
};

#endif // TOVERO_GRAPHICS_BC_COMBINATION_ATTRIBUTES_HPP_
