// BC_shader.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Class to convert back and forth between Tovero and BRL-CAD shaders

#ifndef TOVERO_GRAPHICS_BC_SHADER_HPP_
#define TOVERO_GRAPHICS_BC_SHADER_HPP_

#include <tovero/graphics/base/Shader_visitor.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Cook_shader;
    class Light_shader;
    class Phong_shader;
    class Shader;
    class Toon_shader;

    class BC_shader : public Shader_visitor
    {
    public:
      // constructor
      explicit BC_shader(Shader& shader_args); // reference counted, not const
      explicit BC_shader(const std::string& shader_args);
      virtual ~BC_shader();
      // accessors/mutators
      Shader* shader() const { return m_shader; } // reference counted, not returned as const
      const std::string& shader_name() const { return m_shader_name; }
      const std::string& shader_args() const { return m_shader_args; }
      // visitor
      virtual Shader_visitor::Visit_result visit(const Cook_shader& shader);
      virtual Shader_visitor::Visit_result visit(const Light_shader& shader);
      virtual Shader_visitor::Visit_result visit(const Phong_shader& shader);
      virtual Shader_visitor::Visit_result visit(const Toon_shader& shader);
    private:
      std::string m_shader_name;
      std::string m_shader_args;
      Shader* m_shader;
      // shader parsers
      void mf_parse_cook_shader(const std::string& shader_args);
      void mf_parse_light_shader(const std::string& shader_args);
      void mf_parse_phong_shader(const std::string& shader_args);
      void mf_parse_toon_shader(const std::string& shader_args);
    };
  }
}

#endif // TOVERO_GRAPHICS_BC_SHADER_HPP_
