#!/usr/bin/ruby
#
# whale.rb
#
# Copyright 2012-2013 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#   (1) Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
#
#   (2) Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in
#   the documentation and/or other materials provided with the
#   distribution.
#
#   (3) The name of the author may not be used to
#   endorse or promote products derived from this software without
#   specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

#
# Command line argument processing first
#

mode = ARGV[0]

if mode == 'edit'
  raytrace = false
elsif mode == 'render' or mode == nil
  raytrace = true
else
  abort "error, if an argument is supplied, it must be edit or render"
end

# These load the extension libraries
require 'libtovero_support_rb_0'
require 'libtovero_math_rb_0'
require 'libtovero_graphics_rb_0'

# These are like "using namespace" in C++
include Libtovero_support_rb_0
include Libtovero_math_rb_0
include Libtovero_graphics_rb_0

$shapes = Array.new

load 'whale_data.rb'

# Note: consistently setting the name of graphical entities makes
# it easier to work with the model in BRL-CAD, if necessary
combo = Combination.new
combo.name = "megaptera"

$shapes.each { |shape| combo.add_member(SolidMember.new(shape)) }

BC_DB = BCDatabase.new;
sl = BC_DB.top_solids;
sl << combo

database_file = "whale.g"

error = ErrorParam.new
success = BC_DB.write(database_file, true, error)
if (not success)
  puts("Could not write #{database_file}:")
  puts error.base.to_s
else
  if raytrace
    # display raytraced model
    command = "rt -A0.1 -l7 -w1024 -n1024 -C0/0/50 -a265 -e160 #{database_file} megaptera"
  else
    command = "mged #{database_file}"
  end

  %x[#{command}]
end
