#!/usr/bin/ruby
#
# whale_data.rb
#
# Copyright 2012-2013 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#   (1) Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
#
#   (2) Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in
#   the documentation and/or other materials provided with the
#   distribution.
#
#   (3) The name of the author may not be used to
#   endorse or promote products derived from this software without
#   specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

normals = VectorArray.new
face_normals = TriangleFaceArray.new

m = Distance::meter

# shape_1

shape1_vertices = PointArray.new
shape1_vertices << Point.new(-1.362, -0.038, 0.074, m)
shape1_vertices << Point.new(-1.188, -0.038, 0.14, m)
shape1_vertices << Point.new(-1.252, 0.033, 0.098, m)
shape1_vertices << Point.new(-1.362, 0.032, 0.023, m)
shape1_vertices << Point.new(-1.188, 0.094, 0.043, m)
shape1_vertices << Point.new(-1.252, 0.076, -0.037, m)
shape1_vertices << Point.new(-1.362, 0.005, -0.06, m)
shape1_vertices << Point.new(-1.188, 0.044, -0.113, m)
shape1_vertices << Point.new(-1.252, -0.038, -0.121, m)
shape1_vertices << Point.new(-1.362, -0.081, -0.06, m)
shape1_vertices << Point.new(-1.188, -0.12, -0.113, m)
shape1_vertices << Point.new(-1.252, -0.152, -0.037, m)
shape1_vertices << Point.new(-1.362, -0.108, 0.023, m)
shape1_vertices << Point.new(-1.188, -0.17, 0.043, m)
shape1_vertices << Point.new(-1.252, -0.109, 0.098, m)
shape1_vertices << Point.new(-1.029, 0.025, 0.162, m)
shape1_vertices << Point.new(-1.029, 0.095, 0.111, m)
shape1_vertices << Point.new(-0.881, 0.147, 0.061, m)
shape1_vertices << Point.new(-0.494, 0.176, 0.07, m)
shape1_vertices << Point.new(-0.663, 0.138, 0.125, m)
shape1_vertices << Point.new(-0.28, 0.147, 0.136, m)
shape1_vertices << Point.new(-0.065, 0.094, 0.183, m)
shape1_vertices << Point.new(-0.436, 0.095, 0.185, m)
shape1_vertices << Point.new(-0.28, 0.033, 0.219, m)
shape1_vertices << Point.new(-0.494, -0.038, 0.227, m)
shape1_vertices << Point.new(-0.663, 0.025, 0.208, m)
shape1_vertices << Point.new(-0.881, -0.038, 0.196, m)
shape1_vertices << Point.new(-0.123, -0.038, 0.229, m)
shape1_vertices << Point.new(0.103, 0.032, 0.206, m)
shape1_vertices << Point.new(0.321, 0.076, 0.159, m)
shape1_vertices << Point.new(0.628, 0.044, 0.113, m)
shape1_vertices << Point.new(0.469, 0.005, 0.169, m)
shape1_vertices << Point.new(0.692, -0.038, 0.121, m)
shape1_vertices << Point.new(0.628, -0.12, 0.113, m)
shape1_vertices << Point.new(0.469, -0.081, 0.169, m)
shape1_vertices << Point.new(0.321, -0.152, 0.159, m)
shape1_vertices << Point.new(-0.065, -0.17, 0.183, m)
shape1_vertices << Point.new(0.103, -0.108, 0.206, m)
shape1_vertices << Point.new(-0.28, -0.109, 0.219, m)
shape1_vertices << Point.new(-1.029, 0.134, -0.011, m)
shape1_vertices << Point.new(-1.029, 0.108, -0.093, m)
shape1_vertices << Point.new(-0.881, 0.076, -0.159, m)
shape1_vertices << Point.new(-0.494, 0.094, -0.183, m)
shape1_vertices << Point.new(-0.663, 0.134, -0.13, m)
shape1_vertices << Point.new(-0.28, 0.147, -0.136, m)
shape1_vertices << Point.new(-0.065, 0.176, -0.07, m)
shape1_vertices << Point.new(-0.436, 0.177, -0.071, m)
shape1_vertices << Point.new(-0.153, 0.267, 0, m)
shape1_vertices << Point.new(-0.663, 0.177, 0.003, m)
shape1_vertices << Point.new(-0.123, 0.177, 0.071, m)
shape1_vertices << Point.new(0.103, 0.177, -0.003, m)
shape1_vertices << Point.new(0.321, 0.147, -0.061, m)
shape1_vertices << Point.new(0.628, 0.094, -0.043, m)
shape1_vertices << Point.new(0.469, 0.134, 0.011, m)
shape1_vertices << Point.new(0.692, 0.076, 0.037, m)
shape1_vertices << Point.new(0.469, 0.108, 0.093, m)
shape1_vertices << Point.new(0.103, 0.134, 0.13, m)
shape1_vertices << Point.new(-1.029, 0.005, -0.169, m)
shape1_vertices << Point.new(-1.029, -0.081, -0.169, m)
shape1_vertices << Point.new(-0.881, -0.152, -0.159, m)
shape1_vertices << Point.new(-0.494, -0.17, -0.183, m)
shape1_vertices << Point.new(-0.663, -0.108, -0.206, m)
shape1_vertices << Point.new(-0.28, -0.109, -0.219, m)
shape1_vertices << Point.new(-0.065, -0.038, -0.227, m)
shape1_vertices << Point.new(-0.436, -0.038, -0.229, m)
shape1_vertices << Point.new(-0.28, 0.033, -0.219, m)
shape1_vertices << Point.new(-0.663, 0.032, -0.206, m)
shape1_vertices << Point.new(-0.123, 0.095, -0.185, m)
shape1_vertices << Point.new(0.103, 0.025, -0.208, m)
shape1_vertices << Point.new(0.321, -0.038, -0.196, m)
shape1_vertices << Point.new(0.628, -0.038, -0.14, m)
shape1_vertices << Point.new(0.469, 0.025, -0.162, m)
shape1_vertices << Point.new(0.692, 0.033, -0.098, m)
shape1_vertices << Point.new(0.469, 0.095, -0.111, m)
shape1_vertices << Point.new(0.103, 0.138, -0.125, m)
shape1_vertices << Point.new(-1.029, -0.184, -0.093, m)
shape1_vertices << Point.new(-1.029, -0.21, -0.011, m)
shape1_vertices << Point.new(-0.881, -0.223, 0.061, m)
shape1_vertices << Point.new(-0.494, -0.252, 0.07, m)
shape1_vertices << Point.new(-0.663, -0.253, 0.003, m)
shape1_vertices << Point.new(-0.28, -0.267, 0, m)
shape1_vertices << Point.new(-0.065, -0.252, -0.07, m)
shape1_vertices << Point.new(-0.436, -0.253, -0.071, m)
shape1_vertices << Point.new(-0.28, -0.223, -0.136, m)
shape1_vertices << Point.new(-0.663, -0.21, -0.13, m)
shape1_vertices << Point.new(-0.123, -0.171, -0.185, m)
shape1_vertices << Point.new(0.103, -0.214, -0.125, m)
shape1_vertices << Point.new(0.321, -0.223, -0.061, m)
shape1_vertices << Point.new(0.628, -0.17, -0.043, m)
shape1_vertices << Point.new(0.469, -0.171, -0.111, m)
shape1_vertices << Point.new(0.692, -0.109, -0.098, m)
shape1_vertices << Point.new(0.469, -0.101, -0.162, m)
shape1_vertices << Point.new(0.103, -0.101, -0.208, m)
shape1_vertices << Point.new(-1.029, -0.171, 0.111, m)
shape1_vertices << Point.new(-1.188, -0.038, 0.14, m)
shape1_vertices << Point.new(-1.029, -0.101, 0.162, m)
shape1_vertices << Point.new(-0.881, -0.038, 0.196, m)
shape1_vertices << Point.new(-0.494, -0.038, 0.227, m)
shape1_vertices << Point.new(-0.663, -0.101, 0.208, m)
shape1_vertices << Point.new(-0.436, -0.171, 0.185, m)
shape1_vertices << Point.new(-0.28, -0.223, 0.136, m)
shape1_vertices << Point.new(-0.663, -0.214, 0.125, m)
shape1_vertices << Point.new(-0.123, -0.253, 0.071, m)
shape1_vertices << Point.new(0.103, -0.21, 0.13, m)
shape1_vertices << Point.new(0.469, -0.184, 0.093, m)
shape1_vertices << Point.new(0.692, -0.152, 0.037, m)
shape1_vertices << Point.new(0.469, -0.21, 0.011, m)
shape1_vertices << Point.new(0.103, -0.253, -0.003, m)
shape1_vertices << Point.new(0.888, 0.005, 0.06, m)
shape1_vertices << Point.new(0.892, 0.032, -0.023, m)
shape1_vertices << Point.new(0.886, -0.038, -0.074, m)
shape1_vertices << Point.new(0.892, -0.108, -0.023, m)
shape1_vertices << Point.new(0.888, -0.081, 0.06, m)
shape1_vertices << Point.new(0.692, -0.038, 0.121, m)
shape1_vertices << Point.new(-1.362, -0.038, 0.074, m)
shape1_vertices << Point.new(-0.123, -0.038, 0.229, m)
shape1_vertices << Point.new(-1.401, 0.004, 0.014, m)
shape1_vertices << Point.new(-1.423, -0.038, 0, m)
shape1_vertices << Point.new(-1.401, -0.038, 0.044, m)
shape1_vertices << Point.new(-1.401, -0.012, -0.036, m)
shape1_vertices << Point.new(-1.401, -0.064, -0.036, m)
shape1_vertices << Point.new(-1.423, -0.038, 0, m)
shape1_vertices << Point.new(-1.401, -0.012, -0.036, m)
shape1_vertices << Point.new(-1.401, -0.08, 0.014, m)
shape1_vertices << Point.new(-1.401, -0.038, 0.044, m)
shape1_vertices << Point.new(-0.791, 0.082, 0.167, m)
shape1_vertices << Point.new(0.231, -0.038, 0.206, m)
shape1_vertices << Point.new(0.469, -0.081, 0.169, m)
shape1_vertices << Point.new(0.231, -0.038, 0.206, m)
shape1_vertices << Point.new(-0.791, 0.156, -0.064, m)
shape1_vertices << Point.new(0.231, 0.156, 0.064, m)
shape1_vertices << Point.new(-0.791, -0.038, -0.206, m)
shape1_vertices << Point.new(0.231, 0.082, -0.167, m)
shape1_vertices << Point.new(-0.791, -0.232, -0.064, m)
shape1_vertices << Point.new(0.231, -0.158, -0.167, m)
shape1_vertices << Point.new(-0.791, -0.158, 0.167, m)
shape1_vertices << Point.new(0.231, -0.232, 0.064, m)
shape1_vertices << Point.new(1.346, -0.038, 0, m)
shape1_vertices << Point.new(1.346, -0.038, 0, m)
shape1_vertices << Point.new(0.888, -0.081, 0.06, m)
shape1_vertices << Point.new(-1.37, 0.001, 0.055, m)
shape1_vertices << Point.new(-1.37, 0.026, -0.021, m)
shape1_vertices << Point.new(-1.37, -0.038, -0.068, m)
shape1_vertices << Point.new(-1.37, -0.102, -0.021, m)
shape1_vertices << Point.new(-1.37, -0.077, 0.055, m)
#
shape1_faces = TriangleFaceArray.new
shape1_faces << TriangleFace.new(124, 123, 144)
shape1_faces << TriangleFace.new(123, 120, 143)
shape1_faces << TriangleFace.new(120, 122, 142)
shape1_faces << TriangleFace.new(122, 116, 141)
shape1_faces << TriangleFace.new(116, 118, 140)
shape1_faces << TriangleFace.new(144, 114, 124)
shape1_faces << TriangleFace.new(143, 12, 123)
shape1_faces << TriangleFace.new(142, 9, 120)
shape1_faces << TriangleFace.new(141, 6, 122)
shape1_faces << TriangleFace.new(140, 3, 116)
shape1_faces << TriangleFace.new(123, 12, 144)
shape1_faces << TriangleFace.new(120, 9, 143)
shape1_faces << TriangleFace.new(122, 6, 142)
shape1_faces << TriangleFace.new(116, 3, 141)
shape1_faces << TriangleFace.new(118, 0, 140)
shape1_faces << TriangleFace.new(32, 139, 108)
shape1_faces << TriangleFace.new(105, 111, 112)
shape1_faces << TriangleFace.new(90, 110, 111)
shape1_faces << TriangleFace.new(72, 109, 110)
shape1_faces << TriangleFace.new(54, 108, 109)
shape1_faces << TriangleFace.new(80, 107, 102)
shape1_faces << TriangleFace.new(87, 106, 107)
shape1_faces << TriangleFace.new(105, 104, 106)
shape1_faces << TriangleFace.new(35, 103, 104)
shape1_faces << TriangleFace.new(100, 102, 103)
shape1_faces << TriangleFace.new(77, 101, 93)
shape1_faces << TriangleFace.new(100, 99, 101)
shape1_faces << TriangleFace.new(38, 98, 99)
shape1_faces << TriangleFace.new(96, 95, 98)
shape1_faces << TriangleFace.new(14, 93, 95)
shape1_faces << TriangleFace.new(62, 92, 85)
shape1_faces << TriangleFace.new(69, 91, 92)
shape1_faces << TriangleFace.new(90, 89, 91)
shape1_faces << TriangleFace.new(87, 86, 89)
shape1_faces << TriangleFace.new(83, 85, 86)
shape1_faces << TriangleFace.new(59, 84, 75)
shape1_faces << TriangleFace.new(83, 82, 84)
shape1_faces << TriangleFace.new(80, 79, 82)
shape1_faces << TriangleFace.new(77, 76, 79)
shape1_faces << TriangleFace.new(11, 75, 76)
shape1_faces << TriangleFace.new(44, 74, 67)
shape1_faces << TriangleFace.new(51, 73, 74)
shape1_faces << TriangleFace.new(72, 71, 73)
shape1_faces << TriangleFace.new(69, 68, 71)
shape1_faces << TriangleFace.new(65, 67, 68)
shape1_faces << TriangleFace.new(41, 66, 57)
shape1_faces << TriangleFace.new(65, 64, 66)
shape1_faces << TriangleFace.new(62, 61, 64)
shape1_faces << TriangleFace.new(59, 58, 61)
shape1_faces << TriangleFace.new(8, 57, 58)
shape1_faces << TriangleFace.new(20, 56, 49)
shape1_faces << TriangleFace.new(29, 55, 56)
shape1_faces << TriangleFace.new(54, 53, 55)
shape1_faces << TriangleFace.new(51, 50, 53)
shape1_faces << TriangleFace.new(47, 49, 50)
shape1_faces << TriangleFace.new(17, 48, 39)
shape1_faces << TriangleFace.new(47, 46, 48)
shape1_faces << TriangleFace.new(44, 43, 46)
shape1_faces << TriangleFace.new(41, 40, 43)
shape1_faces << TriangleFace.new(5, 39, 40)
shape1_faces << TriangleFace.new(38, 37, 115)
shape1_faces << TriangleFace.new(35, 34, 37)
shape1_faces << TriangleFace.new(32, 31, 127)
shape1_faces << TriangleFace.new(29, 28, 31)
shape1_faces << TriangleFace.new(23, 27, 28)
shape1_faces << TriangleFace.new(26, 25, 15)
shape1_faces << TriangleFace.new(23, 22, 25)
shape1_faces << TriangleFace.new(20, 19, 22)
shape1_faces << TriangleFace.new(17, 16, 19)
shape1_faces << TriangleFace.new(2, 15, 16)
shape1_faces << TriangleFace.new(14, 114, 144)
shape1_faces << TriangleFace.new(12, 14, 144)
shape1_faces << TriangleFace.new(11, 12, 143)
shape1_faces << TriangleFace.new(9, 11, 143)
shape1_faces << TriangleFace.new(8, 9, 142)
shape1_faces << TriangleFace.new(6, 8, 142)
shape1_faces << TriangleFace.new(5, 6, 141)
shape1_faces << TriangleFace.new(3, 5, 141)
shape1_faces << TriangleFace.new(2, 3, 140)
shape1_faces << TriangleFace.new(0, 2, 140)
shape1_faces << TriangleFace.new(137, 108, 139)
shape1_faces << TriangleFace.new(138, 112, 111)
shape1_faces << TriangleFace.new(138, 111, 110)
shape1_faces << TriangleFace.new(138, 110, 109)
shape1_faces << TriangleFace.new(137, 109, 108)
shape1_faces << TriangleFace.new(136, 102, 107)
shape1_faces << TriangleFace.new(136, 107, 106)
shape1_faces << TriangleFace.new(136, 106, 104)
shape1_faces << TriangleFace.new(136, 104, 103)
shape1_faces << TriangleFace.new(136, 103, 102)
shape1_faces << TriangleFace.new(135, 93, 101)
shape1_faces << TriangleFace.new(135, 101, 99)
shape1_faces << TriangleFace.new(135, 99, 98)
shape1_faces << TriangleFace.new(135, 98, 95)
shape1_faces << TriangleFace.new(135, 95, 93)
shape1_faces << TriangleFace.new(134, 85, 92)
shape1_faces << TriangleFace.new(134, 92, 91)
shape1_faces << TriangleFace.new(134, 91, 89)
shape1_faces << TriangleFace.new(134, 89, 86)
shape1_faces << TriangleFace.new(134, 86, 85)
shape1_faces << TriangleFace.new(133, 75, 84)
shape1_faces << TriangleFace.new(133, 84, 82)
shape1_faces << TriangleFace.new(133, 82, 79)
shape1_faces << TriangleFace.new(133, 79, 76)
shape1_faces << TriangleFace.new(133, 76, 75)
shape1_faces << TriangleFace.new(132, 67, 74)
shape1_faces << TriangleFace.new(132, 74, 73)
shape1_faces << TriangleFace.new(132, 73, 71)
shape1_faces << TriangleFace.new(132, 71, 68)
shape1_faces << TriangleFace.new(132, 68, 67)
shape1_faces << TriangleFace.new(131, 57, 66)
shape1_faces << TriangleFace.new(131, 66, 64)
shape1_faces << TriangleFace.new(131, 64, 61)
shape1_faces << TriangleFace.new(131, 61, 58)
shape1_faces << TriangleFace.new(131, 58, 57)
shape1_faces << TriangleFace.new(130, 49, 56)
shape1_faces << TriangleFace.new(130, 56, 55)
shape1_faces << TriangleFace.new(130, 55, 53)
shape1_faces << TriangleFace.new(130, 53, 50)
shape1_faces << TriangleFace.new(130, 50, 49)
shape1_faces << TriangleFace.new(129, 39, 48)
shape1_faces << TriangleFace.new(129, 48, 46)
shape1_faces << TriangleFace.new(129, 46, 43)
shape1_faces << TriangleFace.new(129, 43, 40)
shape1_faces << TriangleFace.new(129, 40, 39)
shape1_faces << TriangleFace.new(128, 115, 37)
shape1_faces << TriangleFace.new(128, 37, 34)
shape1_faces << TriangleFace.new(126, 127, 31)
shape1_faces << TriangleFace.new(126, 31, 28)
shape1_faces << TriangleFace.new(126, 28, 27)
shape1_faces << TriangleFace.new(125, 15, 25)
shape1_faces << TriangleFace.new(125, 25, 22)
shape1_faces << TriangleFace.new(125, 22, 19)
shape1_faces << TriangleFace.new(125, 19, 16)
shape1_faces << TriangleFace.new(125, 16, 15)
shape1_faces << TriangleFace.new(124, 121, 123)
shape1_faces << TriangleFace.new(123, 121, 120)
shape1_faces << TriangleFace.new(120, 121, 122)
shape1_faces << TriangleFace.new(119, 117, 116)
shape1_faces << TriangleFace.new(116, 117, 118)
shape1_faces << TriangleFace.new(30, 32, 108)
shape1_faces << TriangleFace.new(33, 105, 112)
shape1_faces << TriangleFace.new(88, 90, 111)
shape1_faces << TriangleFace.new(70, 72, 110)
shape1_faces << TriangleFace.new(52, 54, 109)
shape1_faces << TriangleFace.new(78, 80, 102)
shape1_faces << TriangleFace.new(81, 87, 107)
shape1_faces << TriangleFace.new(88, 105, 106)
shape1_faces << TriangleFace.new(33, 35, 104)
shape1_faces << TriangleFace.new(36, 100, 103)
shape1_faces << TriangleFace.new(13, 77, 93)
shape1_faces << TriangleFace.new(78, 100, 101)
shape1_faces << TriangleFace.new(36, 38, 99)
shape1_faces << TriangleFace.new(97, 96, 98)
shape1_faces << TriangleFace.new(94, 14, 95)
shape1_faces << TriangleFace.new(60, 62, 85)
shape1_faces << TriangleFace.new(63, 69, 92)
shape1_faces << TriangleFace.new(70, 90, 91)
shape1_faces << TriangleFace.new(88, 87, 89)
shape1_faces << TriangleFace.new(81, 83, 86)
shape1_faces << TriangleFace.new(10, 59, 75)
shape1_faces << TriangleFace.new(60, 83, 84)
shape1_faces << TriangleFace.new(81, 80, 82)
shape1_faces << TriangleFace.new(78, 77, 79)
shape1_faces << TriangleFace.new(13, 11, 76)
shape1_faces << TriangleFace.new(42, 44, 67)
shape1_faces << TriangleFace.new(45, 51, 74)
shape1_faces << TriangleFace.new(52, 72, 73)
shape1_faces << TriangleFace.new(70, 69, 71)
shape1_faces << TriangleFace.new(63, 65, 68)
shape1_faces << TriangleFace.new(7, 41, 57)
shape1_faces << TriangleFace.new(42, 65, 66)
shape1_faces << TriangleFace.new(63, 62, 64)
shape1_faces << TriangleFace.new(60, 59, 61)
shape1_faces << TriangleFace.new(10, 8, 58)
shape1_faces << TriangleFace.new(18, 20, 49)
shape1_faces << TriangleFace.new(21, 29, 56)
shape1_faces << TriangleFace.new(30, 54, 55)
shape1_faces << TriangleFace.new(52, 51, 53)
shape1_faces << TriangleFace.new(45, 47, 50)
shape1_faces << TriangleFace.new(4, 17, 39)
shape1_faces << TriangleFace.new(18, 47, 48)
shape1_faces << TriangleFace.new(45, 44, 46)
shape1_faces << TriangleFace.new(42, 41, 43)
shape1_faces << TriangleFace.new(7, 5, 40)
shape1_faces << TriangleFace.new(97, 38, 115)
shape1_faces << TriangleFace.new(36, 35, 37)
shape1_faces << TriangleFace.new(33, 113, 34)
shape1_faces << TriangleFace.new(30, 29, 31)
shape1_faces << TriangleFace.new(21, 23, 28)
shape1_faces << TriangleFace.new(1, 26, 15)
shape1_faces << TriangleFace.new(24, 23, 25)
shape1_faces << TriangleFace.new(21, 20, 22)
shape1_faces << TriangleFace.new(18, 17, 19)
shape1_faces << TriangleFace.new(4, 2, 16)
shape1_faces << TriangleFace.new(14, 94, 114)
shape1_faces << TriangleFace.new(11, 13, 12)
shape1_faces << TriangleFace.new(8, 10, 9)
shape1_faces << TriangleFace.new(5, 7, 6)
shape1_faces << TriangleFace.new(2, 4, 3)
shape1_faces << TriangleFace.new(33, 112, 113)
shape1_faces << TriangleFace.new(88, 111, 105)
shape1_faces << TriangleFace.new(70, 110, 90)
shape1_faces << TriangleFace.new(52, 109, 72)
shape1_faces << TriangleFace.new(30, 108, 54)
shape1_faces << TriangleFace.new(81, 107, 80)
shape1_faces << TriangleFace.new(88, 106, 87)
shape1_faces << TriangleFace.new(33, 104, 105)
shape1_faces << TriangleFace.new(36, 103, 35)
shape1_faces << TriangleFace.new(78, 102, 100)
shape1_faces << TriangleFace.new(78, 101, 77)
shape1_faces << TriangleFace.new(36, 99, 100)
shape1_faces << TriangleFace.new(97, 98, 38)
shape1_faces << TriangleFace.new(94, 95, 96)
shape1_faces << TriangleFace.new(13, 93, 14)
shape1_faces << TriangleFace.new(63, 92, 62)
shape1_faces << TriangleFace.new(70, 91, 69)
shape1_faces << TriangleFace.new(88, 89, 90)
shape1_faces << TriangleFace.new(81, 86, 87)
shape1_faces << TriangleFace.new(60, 85, 83)
shape1_faces << TriangleFace.new(60, 84, 59)
shape1_faces << TriangleFace.new(81, 82, 83)
shape1_faces << TriangleFace.new(78, 79, 80)
shape1_faces << TriangleFace.new(13, 76, 77)
shape1_faces << TriangleFace.new(10, 75, 11)
shape1_faces << TriangleFace.new(45, 74, 44)
shape1_faces << TriangleFace.new(52, 73, 51)
shape1_faces << TriangleFace.new(70, 71, 72)
shape1_faces << TriangleFace.new(63, 68, 69)
shape1_faces << TriangleFace.new(42, 67, 65)
shape1_faces << TriangleFace.new(42, 66, 41)
shape1_faces << TriangleFace.new(63, 64, 65)
shape1_faces << TriangleFace.new(60, 61, 62)
shape1_faces << TriangleFace.new(10, 58, 59)
shape1_faces << TriangleFace.new(7, 57, 8)
shape1_faces << TriangleFace.new(21, 56, 20)
shape1_faces << TriangleFace.new(30, 55, 29)
shape1_faces << TriangleFace.new(52, 53, 54)
shape1_faces << TriangleFace.new(45, 50, 51)
shape1_faces << TriangleFace.new(18, 49, 47)
shape1_faces << TriangleFace.new(18, 48, 17)
shape1_faces << TriangleFace.new(45, 46, 47)
shape1_faces << TriangleFace.new(42, 43, 44)
shape1_faces << TriangleFace.new(7, 40, 41)
shape1_faces << TriangleFace.new(4, 39, 5)
shape1_faces << TriangleFace.new(36, 37, 38)
shape1_faces << TriangleFace.new(33, 34, 35)
shape1_faces << TriangleFace.new(30, 31, 32)
shape1_faces << TriangleFace.new(21, 28, 29)
shape1_faces << TriangleFace.new(24, 27, 23)
shape1_faces << TriangleFace.new(24, 25, 26)
shape1_faces << TriangleFace.new(21, 22, 23)
shape1_faces << TriangleFace.new(18, 19, 20)
shape1_faces << TriangleFace.new(4, 16, 17)
shape1_faces << TriangleFace.new(1, 15, 2)
shape1_faces << TriangleFace.new(12, 13, 14)
shape1_faces << TriangleFace.new(9, 10, 11)
shape1_faces << TriangleFace.new(6, 7, 8)
shape1_faces << TriangleFace.new(3, 4, 5)
shape1_faces << TriangleFace.new(0, 1, 2)

whale_shape1 = TriangleMesh.new(
     TriangleFace::Direction_none,
     shape1_vertices,
     shape1_faces,
     normals,
     face_normals,
     false,
     false)

$shapes << whale_shape1

# shape_2

shape2_vertices = PointArray.new
shape2_vertices << Point.new(-0.662, -0.005, 0.199, m)
shape2_vertices << Point.new(-0.612, -0.01, 0.242, m)
shape2_vertices << Point.new(-0.69, 0.006, 0.216, m)
shape2_vertices << Point.new(-0.658, 0.004, 0.268, m)
shape2_vertices << Point.new(-0.662, 0.017, 0.199, m)
shape2_vertices << Point.new(-0.612, 0.017, 0.242, m)
shape2_vertices << Point.new(-0.635, 0.006, 0.182, m)
shape2_vertices << Point.new(-0.565, 0.004, 0.215, m)
shape2_vertices << Point.new(-0.587, -0.011, 0.273, m)
shape2_vertices << Point.new(-0.64, 0.003, 0.303, m)
shape2_vertices << Point.new(-0.587, 0.017, 0.273, m)
shape2_vertices << Point.new(-0.534, 0.003, 0.244, m)
shape2_vertices << Point.new(-0.557, -0.015, 0.316, m)
shape2_vertices << Point.new(-0.613, 0.001, 0.348, m)
shape2_vertices << Point.new(-0.557, 0.017, 0.316, m)
shape2_vertices << Point.new(-0.501, 0.001, 0.284, m)
shape2_vertices << Point.new(-0.536, -0.017, 0.359, m)
shape2_vertices << Point.new(-0.589, 0, 0.39, m)
shape2_vertices << Point.new(-0.536, 0.017, 0.359, m)
shape2_vertices << Point.new(-0.482, 0, 0.328, m)
shape2_vertices << Point.new(-0.481, -0.015, 0.442, m)
shape2_vertices << Point.new(-0.539, 0.001, 0.476, m)
shape2_vertices << Point.new(-0.481, 0.017, 0.442, m)
shape2_vertices << Point.new(-0.423, 0.001, 0.409, m)
shape2_vertices << Point.new(-0.437, -0.013, 0.532, m)
shape2_vertices << Point.new(-0.49, 0.002, 0.562, m)
shape2_vertices << Point.new(-0.437, 0.017, 0.532, m)
shape2_vertices << Point.new(-0.384, 0.002, 0.501, m)
shape2_vertices << Point.new(-0.379, -0.017, 0.619, m)
shape2_vertices << Point.new(-0.437, 0, 0.653, m)
shape2_vertices << Point.new(-0.379, 0.017, 0.619, m)
shape2_vertices << Point.new(-0.32, 0, 0.585, m)
shape2_vertices << Point.new(-0.332, -0.012, 0.709, m)
shape2_vertices << Point.new(-0.387, 0.002, 0.74, m)
shape2_vertices << Point.new(-0.332, 0.017, 0.709, m)
shape2_vertices << Point.new(-0.278, 0.002, 0.678, m)
shape2_vertices << Point.new(-0.277, -0.016, 0.797, m)
shape2_vertices << Point.new(-0.335, 0.001, 0.83, m)
shape2_vertices << Point.new(-0.277, 0.017, 0.797, m)
shape2_vertices << Point.new(-0.22, 0.001, 0.763, m)
shape2_vertices << Point.new(-0.25, -0.01, 0.84, m)
shape2_vertices << Point.new(-0.31, 0.003, 0.874, m)
shape2_vertices << Point.new(-0.25, 0.017, 0.84, m)
shape2_vertices << Point.new(-0.191, 0.003, 0.805, m)
shape2_vertices << Point.new(-0.227, -0.012, 0.885, m)
shape2_vertices << Point.new(-0.284, 0.003, 0.918, m)
shape2_vertices << Point.new(-0.227, 0.017, 0.885, m)
shape2_vertices << Point.new(-0.17, 0.003, 0.852, m)
shape2_vertices << Point.new(-0.212, -0.01, 0.933, m)
shape2_vertices << Point.new(-0.254, 0.004, 0.957, m)
shape2_vertices << Point.new(-0.212, 0.017, 0.933, m)
shape2_vertices << Point.new(-0.17, 0.004, 0.909, m)
shape2_vertices << Point.new(-0.216, -0.001, 0.993, m)
shape2_vertices << Point.new(-0.224, 0.008, 0.998, m)
shape2_vertices << Point.new(-0.216, 0.017, 0.993, m)
shape2_vertices << Point.new(-0.208, 0.008, 0.989, m)
#
shape2_faces = TriangleFaceArray.new
shape2_faces << TriangleFace.new(55, 54, 53)
shape2_faces << TriangleFace.new(53, 52, 55)
shape2_faces << TriangleFace.new(4, 6, 0)
shape2_faces << TriangleFace.new(0, 2, 4)
shape2_faces << TriangleFace.new(52, 48, 55)
shape2_faces << TriangleFace.new(51, 55, 48)
shape2_faces << TriangleFace.new(55, 51, 54)
shape2_faces << TriangleFace.new(50, 54, 51)
shape2_faces << TriangleFace.new(54, 50, 53)
shape2_faces << TriangleFace.new(49, 53, 50)
shape2_faces << TriangleFace.new(53, 49, 52)
shape2_faces << TriangleFace.new(48, 52, 49)
shape2_faces << TriangleFace.new(48, 44, 51)
shape2_faces << TriangleFace.new(47, 51, 44)
shape2_faces << TriangleFace.new(51, 47, 50)
shape2_faces << TriangleFace.new(46, 50, 47)
shape2_faces << TriangleFace.new(50, 46, 49)
shape2_faces << TriangleFace.new(45, 49, 46)
shape2_faces << TriangleFace.new(49, 45, 48)
shape2_faces << TriangleFace.new(44, 48, 45)
shape2_faces << TriangleFace.new(44, 40, 47)
shape2_faces << TriangleFace.new(43, 47, 40)
shape2_faces << TriangleFace.new(47, 43, 46)
shape2_faces << TriangleFace.new(42, 46, 43)
shape2_faces << TriangleFace.new(46, 42, 45)
shape2_faces << TriangleFace.new(41, 45, 42)
shape2_faces << TriangleFace.new(45, 41, 44)
shape2_faces << TriangleFace.new(40, 44, 41)
shape2_faces << TriangleFace.new(40, 36, 43)
shape2_faces << TriangleFace.new(39, 43, 36)
shape2_faces << TriangleFace.new(43, 39, 42)
shape2_faces << TriangleFace.new(38, 42, 39)
shape2_faces << TriangleFace.new(42, 38, 41)
shape2_faces << TriangleFace.new(37, 41, 38)
shape2_faces << TriangleFace.new(41, 37, 40)
shape2_faces << TriangleFace.new(36, 40, 37)
shape2_faces << TriangleFace.new(36, 32, 39)
shape2_faces << TriangleFace.new(35, 39, 32)
shape2_faces << TriangleFace.new(39, 35, 38)
shape2_faces << TriangleFace.new(34, 38, 35)
shape2_faces << TriangleFace.new(38, 34, 37)
shape2_faces << TriangleFace.new(33, 37, 34)
shape2_faces << TriangleFace.new(37, 33, 36)
shape2_faces << TriangleFace.new(32, 36, 33)
shape2_faces << TriangleFace.new(32, 28, 35)
shape2_faces << TriangleFace.new(31, 35, 28)
shape2_faces << TriangleFace.new(35, 31, 34)
shape2_faces << TriangleFace.new(30, 34, 31)
shape2_faces << TriangleFace.new(34, 30, 33)
shape2_faces << TriangleFace.new(29, 33, 30)
shape2_faces << TriangleFace.new(33, 29, 32)
shape2_faces << TriangleFace.new(28, 32, 29)
shape2_faces << TriangleFace.new(28, 24, 31)
shape2_faces << TriangleFace.new(27, 31, 24)
shape2_faces << TriangleFace.new(31, 27, 30)
shape2_faces << TriangleFace.new(26, 30, 27)
shape2_faces << TriangleFace.new(30, 26, 29)
shape2_faces << TriangleFace.new(25, 29, 26)
shape2_faces << TriangleFace.new(29, 25, 28)
shape2_faces << TriangleFace.new(24, 28, 25)
shape2_faces << TriangleFace.new(24, 20, 27)
shape2_faces << TriangleFace.new(23, 27, 20)
shape2_faces << TriangleFace.new(27, 23, 26)
shape2_faces << TriangleFace.new(22, 26, 23)
shape2_faces << TriangleFace.new(26, 22, 25)
shape2_faces << TriangleFace.new(21, 25, 22)
shape2_faces << TriangleFace.new(25, 21, 24)
shape2_faces << TriangleFace.new(20, 24, 21)
shape2_faces << TriangleFace.new(20, 16, 23)
shape2_faces << TriangleFace.new(19, 23, 16)
shape2_faces << TriangleFace.new(23, 19, 22)
shape2_faces << TriangleFace.new(18, 22, 19)
shape2_faces << TriangleFace.new(22, 18, 21)
shape2_faces << TriangleFace.new(17, 21, 18)
shape2_faces << TriangleFace.new(21, 17, 20)
shape2_faces << TriangleFace.new(16, 20, 17)
shape2_faces << TriangleFace.new(16, 12, 19)
shape2_faces << TriangleFace.new(15, 19, 12)
shape2_faces << TriangleFace.new(19, 15, 18)
shape2_faces << TriangleFace.new(14, 18, 15)
shape2_faces << TriangleFace.new(18, 14, 17)
shape2_faces << TriangleFace.new(13, 17, 14)
shape2_faces << TriangleFace.new(17, 13, 16)
shape2_faces << TriangleFace.new(12, 16, 13)
shape2_faces << TriangleFace.new(12, 8, 15)
shape2_faces << TriangleFace.new(11, 15, 8)
shape2_faces << TriangleFace.new(15, 11, 14)
shape2_faces << TriangleFace.new(10, 14, 11)
shape2_faces << TriangleFace.new(14, 10, 13)
shape2_faces << TriangleFace.new(9, 13, 10)
shape2_faces << TriangleFace.new(13, 9, 12)
shape2_faces << TriangleFace.new(8, 12, 9)
shape2_faces << TriangleFace.new(8, 1, 11)
shape2_faces << TriangleFace.new(7, 11, 1)
shape2_faces << TriangleFace.new(11, 7, 10)
shape2_faces << TriangleFace.new(5, 10, 7)
shape2_faces << TriangleFace.new(10, 5, 9)
shape2_faces << TriangleFace.new(3, 9, 5)
shape2_faces << TriangleFace.new(9, 3, 8)
shape2_faces << TriangleFace.new(1, 8, 3)
shape2_faces << TriangleFace.new(1, 0, 7)
shape2_faces << TriangleFace.new(6, 7, 0)
shape2_faces << TriangleFace.new(7, 6, 5)
shape2_faces << TriangleFace.new(4, 5, 6)
shape2_faces << TriangleFace.new(5, 4, 3)
shape2_faces << TriangleFace.new(2, 3, 4)
shape2_faces << TriangleFace.new(3, 2, 1)
shape2_faces << TriangleFace.new(0, 1, 2)

whale_shape2 = TriangleMesh.new(
     TriangleFace::Direction_none,
     shape2_vertices,
     shape2_faces,
     normals,
     face_normals,
     false,
     false)

$shapes << whale_shape2

# shape_3

shape3_vertices = PointArray.new
shape3_vertices << Point.new(-0.611, -0.01, -0.242, m)
shape3_vertices << Point.new(-0.662, -0.005, -0.199, m)
shape3_vertices << Point.new(-0.69, 0.006, -0.216, m)
shape3_vertices << Point.new(-0.658, 0.004, -0.268, m)
shape3_vertices << Point.new(-0.662, 0.017, -0.199, m)
shape3_vertices << Point.new(-0.611, 0.017, -0.242, m)
shape3_vertices << Point.new(-0.634, 0.006, -0.183, m)
shape3_vertices << Point.new(-0.565, 0.004, -0.215, m)
shape3_vertices << Point.new(-0.587, -0.011, -0.273, m)
shape3_vertices << Point.new(-0.64, 0.003, -0.303, m)
shape3_vertices << Point.new(-0.587, 0.017, -0.273, m)
shape3_vertices << Point.new(-0.534, 0.003, -0.244, m)
shape3_vertices << Point.new(-0.557, -0.015, -0.316, m)
shape3_vertices << Point.new(-0.613, 0.001, -0.348, m)
shape3_vertices << Point.new(-0.557, 0.017, -0.316, m)
shape3_vertices << Point.new(-0.501, 0.001, -0.284, m)
shape3_vertices << Point.new(-0.536, -0.017, -0.359, m)
shape3_vertices << Point.new(-0.589, 0, -0.39, m)
shape3_vertices << Point.new(-0.536, 0.017, -0.359, m)
shape3_vertices << Point.new(-0.482, 0, -0.328, m)
shape3_vertices << Point.new(-0.481, -0.015, -0.442, m)
shape3_vertices << Point.new(-0.539, 0.001, -0.476, m)
shape3_vertices << Point.new(-0.481, 0.017, -0.442, m)
shape3_vertices << Point.new(-0.423, 0.001, -0.409, m)
shape3_vertices << Point.new(-0.437, -0.013, -0.532, m)
shape3_vertices << Point.new(-0.49, 0.002, -0.562, m)
shape3_vertices << Point.new(-0.437, 0.017, -0.532, m)
shape3_vertices << Point.new(-0.384, 0.002, -0.501, m)
shape3_vertices << Point.new(-0.378, -0.017, -0.619, m)
shape3_vertices << Point.new(-0.437, 0, -0.653, m)
shape3_vertices << Point.new(-0.378, 0.017, -0.619, m)
shape3_vertices << Point.new(-0.32, 0, -0.585, m)
shape3_vertices << Point.new(-0.332, -0.012, -0.709, m)
shape3_vertices << Point.new(-0.387, 0.002, -0.741, m)
shape3_vertices << Point.new(-0.332, 0.017, -0.709, m)
shape3_vertices << Point.new(-0.278, 0.002, -0.678, m)
shape3_vertices << Point.new(-0.277, -0.016, -0.797, m)
shape3_vertices << Point.new(-0.335, 0.001, -0.83, m)
shape3_vertices << Point.new(-0.277, 0.017, -0.797, m)
shape3_vertices << Point.new(-0.22, 0.001, -0.763, m)
shape3_vertices << Point.new(-0.25, -0.01, -0.84, m)
shape3_vertices << Point.new(-0.31, 0.003, -0.874, m)
shape3_vertices << Point.new(-0.25, 0.017, -0.84, m)
shape3_vertices << Point.new(-0.191, 0.003, -0.805, m)
shape3_vertices << Point.new(-0.227, -0.012, -0.885, m)
shape3_vertices << Point.new(-0.284, 0.003, -0.918, m)
shape3_vertices << Point.new(-0.227, 0.017, -0.885, m)
shape3_vertices << Point.new(-0.17, 0.003, -0.852, m)
shape3_vertices << Point.new(-0.212, -0.01, -0.933, m)
shape3_vertices << Point.new(-0.254, 0.004, -0.958, m)
shape3_vertices << Point.new(-0.212, 0.017, -0.933, m)
shape3_vertices << Point.new(-0.17, 0.004, -0.909, m)
shape3_vertices << Point.new(-0.216, -0.001, -0.993, m)
shape3_vertices << Point.new(-0.224, 0.008, -0.998, m)
shape3_vertices << Point.new(-0.216, 0.017, -0.993, m)
shape3_vertices << Point.new(-0.208, 0.008, -0.989, m)
#
shape3_faces = TriangleFaceArray.new
shape3_faces << TriangleFace.new(54, 55, 53)
shape3_faces << TriangleFace.new(52, 53, 55)
shape3_faces << TriangleFace.new(6, 4, 1)
shape3_faces << TriangleFace.new(2, 1, 4)
shape3_faces << TriangleFace.new(48, 52, 55)
shape3_faces << TriangleFace.new(55, 51, 48)
shape3_faces << TriangleFace.new(51, 55, 54)
shape3_faces << TriangleFace.new(54, 50, 51)
shape3_faces << TriangleFace.new(50, 54, 53)
shape3_faces << TriangleFace.new(53, 49, 50)
shape3_faces << TriangleFace.new(49, 53, 52)
shape3_faces << TriangleFace.new(52, 48, 49)
shape3_faces << TriangleFace.new(44, 48, 51)
shape3_faces << TriangleFace.new(51, 47, 44)
shape3_faces << TriangleFace.new(47, 51, 50)
shape3_faces << TriangleFace.new(50, 46, 47)
shape3_faces << TriangleFace.new(46, 50, 49)
shape3_faces << TriangleFace.new(49, 45, 46)
shape3_faces << TriangleFace.new(45, 49, 48)
shape3_faces << TriangleFace.new(48, 44, 45)
shape3_faces << TriangleFace.new(40, 44, 47)
shape3_faces << TriangleFace.new(47, 43, 40)
shape3_faces << TriangleFace.new(43, 47, 46)
shape3_faces << TriangleFace.new(46, 42, 43)
shape3_faces << TriangleFace.new(42, 46, 45)
shape3_faces << TriangleFace.new(45, 41, 42)
shape3_faces << TriangleFace.new(41, 45, 44)
shape3_faces << TriangleFace.new(44, 40, 41)
shape3_faces << TriangleFace.new(36, 40, 43)
shape3_faces << TriangleFace.new(43, 39, 36)
shape3_faces << TriangleFace.new(39, 43, 42)
shape3_faces << TriangleFace.new(42, 38, 39)
shape3_faces << TriangleFace.new(38, 42, 41)
shape3_faces << TriangleFace.new(41, 37, 38)
shape3_faces << TriangleFace.new(37, 41, 40)
shape3_faces << TriangleFace.new(40, 36, 37)
shape3_faces << TriangleFace.new(32, 36, 39)
shape3_faces << TriangleFace.new(39, 35, 32)
shape3_faces << TriangleFace.new(35, 39, 38)
shape3_faces << TriangleFace.new(38, 34, 35)
shape3_faces << TriangleFace.new(34, 38, 37)
shape3_faces << TriangleFace.new(37, 33, 34)
shape3_faces << TriangleFace.new(33, 37, 36)
shape3_faces << TriangleFace.new(36, 32, 33)
shape3_faces << TriangleFace.new(28, 32, 35)
shape3_faces << TriangleFace.new(35, 31, 28)
shape3_faces << TriangleFace.new(31, 35, 34)
shape3_faces << TriangleFace.new(34, 30, 31)
shape3_faces << TriangleFace.new(30, 34, 33)
shape3_faces << TriangleFace.new(33, 29, 30)
shape3_faces << TriangleFace.new(29, 33, 32)
shape3_faces << TriangleFace.new(32, 28, 29)
shape3_faces << TriangleFace.new(24, 28, 31)
shape3_faces << TriangleFace.new(31, 27, 24)
shape3_faces << TriangleFace.new(27, 31, 30)
shape3_faces << TriangleFace.new(30, 26, 27)
shape3_faces << TriangleFace.new(26, 30, 29)
shape3_faces << TriangleFace.new(29, 25, 26)
shape3_faces << TriangleFace.new(25, 29, 28)
shape3_faces << TriangleFace.new(28, 24, 25)
shape3_faces << TriangleFace.new(20, 24, 27)
shape3_faces << TriangleFace.new(27, 23, 20)
shape3_faces << TriangleFace.new(23, 27, 26)
shape3_faces << TriangleFace.new(26, 22, 23)
shape3_faces << TriangleFace.new(22, 26, 25)
shape3_faces << TriangleFace.new(25, 21, 22)
shape3_faces << TriangleFace.new(21, 25, 24)
shape3_faces << TriangleFace.new(24, 20, 21)
shape3_faces << TriangleFace.new(16, 20, 23)
shape3_faces << TriangleFace.new(23, 19, 16)
shape3_faces << TriangleFace.new(19, 23, 22)
shape3_faces << TriangleFace.new(22, 18, 19)
shape3_faces << TriangleFace.new(18, 22, 21)
shape3_faces << TriangleFace.new(21, 17, 18)
shape3_faces << TriangleFace.new(17, 21, 20)
shape3_faces << TriangleFace.new(20, 16, 17)
shape3_faces << TriangleFace.new(12, 16, 19)
shape3_faces << TriangleFace.new(19, 15, 12)
shape3_faces << TriangleFace.new(15, 19, 18)
shape3_faces << TriangleFace.new(18, 14, 15)
shape3_faces << TriangleFace.new(14, 18, 17)
shape3_faces << TriangleFace.new(17, 13, 14)
shape3_faces << TriangleFace.new(13, 17, 16)
shape3_faces << TriangleFace.new(16, 12, 13)
shape3_faces << TriangleFace.new(8, 12, 15)
shape3_faces << TriangleFace.new(15, 11, 8)
shape3_faces << TriangleFace.new(11, 15, 14)
shape3_faces << TriangleFace.new(14, 10, 11)
shape3_faces << TriangleFace.new(10, 14, 13)
shape3_faces << TriangleFace.new(13, 9, 10)
shape3_faces << TriangleFace.new(9, 13, 12)
shape3_faces << TriangleFace.new(12, 8, 9)
shape3_faces << TriangleFace.new(0, 8, 11)
shape3_faces << TriangleFace.new(11, 7, 0)
shape3_faces << TriangleFace.new(7, 11, 10)
shape3_faces << TriangleFace.new(10, 5, 7)
shape3_faces << TriangleFace.new(5, 10, 9)
shape3_faces << TriangleFace.new(9, 3, 5)
shape3_faces << TriangleFace.new(3, 9, 8)
shape3_faces << TriangleFace.new(8, 0, 3)
shape3_faces << TriangleFace.new(1, 0, 7)
shape3_faces << TriangleFace.new(7, 6, 1)
shape3_faces << TriangleFace.new(6, 7, 5)
shape3_faces << TriangleFace.new(5, 4, 6)
shape3_faces << TriangleFace.new(4, 5, 3)
shape3_faces << TriangleFace.new(3, 2, 4)
shape3_faces << TriangleFace.new(2, 3, 0)
shape3_faces << TriangleFace.new(0, 1, 2)

whale_shape3 = TriangleMesh.new(
     TriangleFace::Direction_none,
     shape3_vertices,
     shape3_faces,
     normals,
     face_normals,
     false,
     false)

$shapes << whale_shape3

# shape_4

shape4_vertices = PointArray.new
shape4_vertices << Point.new(1.258, -0.033, 0, m)
shape4_vertices << Point.new(1.277, -0.035, 0.058, m)
shape4_vertices << Point.new(1.353, -0.051, 0, m)
shape4_vertices << Point.new(1.379, -0.051, 0.058, m)
shape4_vertices << Point.new(1.258, -0.068, 0, m)
shape4_vertices << Point.new(1.277, -0.066, 0.058, m)
shape4_vertices << Point.new(1.162, -0.051, 0, m)
shape4_vertices << Point.new(1.175, -0.051, 0.058, m)
shape4_vertices << Point.new(1.295, -0.037, 0.114, m)
shape4_vertices << Point.new(1.385, -0.05, 0.114, m)
shape4_vertices << Point.new(1.295, -0.064, 0.114, m)
shape4_vertices << Point.new(1.204, -0.05, 0.114, m)
shape4_vertices << Point.new(1.314, -0.039, 0.182, m)
shape4_vertices << Point.new(1.393, -0.05, 0.182, m)
shape4_vertices << Point.new(1.314, -0.062, 0.182, m)
shape4_vertices << Point.new(1.235, -0.05, 0.182, m)
shape4_vertices << Point.new(1.331, -0.041, 0.23, m)
shape4_vertices << Point.new(1.396, -0.05, 0.23, m)
shape4_vertices << Point.new(1.331, -0.06, 0.23, m)
shape4_vertices << Point.new(1.266, -0.05, 0.23, m)
shape4_vertices << Point.new(1.354, -0.042, 0.282, m)
shape4_vertices << Point.new(1.403, -0.05, 0.282, m)
shape4_vertices << Point.new(1.354, -0.058, 0.282, m)
shape4_vertices << Point.new(1.305, -0.05, 0.282, m)
shape4_vertices << Point.new(1.37, -0.044, 0.332, m)
shape4_vertices << Point.new(1.405, -0.05, 0.332, m)
shape4_vertices << Point.new(1.37, -0.056, 0.332, m)
shape4_vertices << Point.new(1.335, -0.05, 0.332, m)
shape4_vertices << Point.new(1.386, -0.045, 0.374, m)
shape4_vertices << Point.new(1.408, -0.05, 0.374, m)
shape4_vertices << Point.new(1.386, -0.055, 0.374, m)
shape4_vertices << Point.new(1.365, -0.05, 0.374, m)
shape4_vertices << Point.new(1.403, -0.046, 0.402, m)
shape4_vertices << Point.new(1.421, -0.05, 0.402, m)
shape4_vertices << Point.new(1.403, -0.054, 0.402, m)
shape4_vertices << Point.new(1.386, -0.05, 0.402, m)
shape4_vertices << Point.new(1.419, -0.047, 0.409, m)
shape4_vertices << Point.new(1.423, -0.05, 0.409, m)
shape4_vertices << Point.new(1.419, -0.053, 0.409, m)
shape4_vertices << Point.new(1.416, -0.05, 0.409, m)
#
shape4_faces = TriangleFaceArray.new
shape4_faces << TriangleFace.new(39, 38, 37)
shape4_faces << TriangleFace.new(37, 36, 39)
shape4_faces << TriangleFace.new(4, 6, 0)
shape4_faces << TriangleFace.new(0, 2, 4)
shape4_faces << TriangleFace.new(36, 32, 39)
shape4_faces << TriangleFace.new(35, 39, 32)
shape4_faces << TriangleFace.new(39, 35, 38)
shape4_faces << TriangleFace.new(34, 38, 35)
shape4_faces << TriangleFace.new(38, 34, 37)
shape4_faces << TriangleFace.new(33, 37, 34)
shape4_faces << TriangleFace.new(37, 33, 36)
shape4_faces << TriangleFace.new(32, 36, 33)
shape4_faces << TriangleFace.new(32, 28, 35)
shape4_faces << TriangleFace.new(31, 35, 28)
shape4_faces << TriangleFace.new(35, 31, 34)
shape4_faces << TriangleFace.new(30, 34, 31)
shape4_faces << TriangleFace.new(34, 30, 33)
shape4_faces << TriangleFace.new(29, 33, 30)
shape4_faces << TriangleFace.new(33, 29, 32)
shape4_faces << TriangleFace.new(28, 32, 29)
shape4_faces << TriangleFace.new(28, 24, 31)
shape4_faces << TriangleFace.new(27, 31, 24)
shape4_faces << TriangleFace.new(31, 27, 30)
shape4_faces << TriangleFace.new(26, 30, 27)
shape4_faces << TriangleFace.new(30, 26, 29)
shape4_faces << TriangleFace.new(25, 29, 26)
shape4_faces << TriangleFace.new(29, 25, 28)
shape4_faces << TriangleFace.new(24, 28, 25)
shape4_faces << TriangleFace.new(24, 20, 27)
shape4_faces << TriangleFace.new(23, 27, 20)
shape4_faces << TriangleFace.new(27, 23, 26)
shape4_faces << TriangleFace.new(22, 26, 23)
shape4_faces << TriangleFace.new(26, 22, 25)
shape4_faces << TriangleFace.new(21, 25, 22)
shape4_faces << TriangleFace.new(25, 21, 24)
shape4_faces << TriangleFace.new(20, 24, 21)
shape4_faces << TriangleFace.new(20, 16, 23)
shape4_faces << TriangleFace.new(19, 23, 16)
shape4_faces << TriangleFace.new(23, 19, 22)
shape4_faces << TriangleFace.new(18, 22, 19)
shape4_faces << TriangleFace.new(22, 18, 21)
shape4_faces << TriangleFace.new(17, 21, 18)
shape4_faces << TriangleFace.new(21, 17, 20)
shape4_faces << TriangleFace.new(16, 20, 17)
shape4_faces << TriangleFace.new(16, 12, 19)
shape4_faces << TriangleFace.new(15, 19, 12)
shape4_faces << TriangleFace.new(19, 15, 18)
shape4_faces << TriangleFace.new(14, 18, 15)
shape4_faces << TriangleFace.new(18, 14, 17)
shape4_faces << TriangleFace.new(13, 17, 14)
shape4_faces << TriangleFace.new(17, 13, 16)
shape4_faces << TriangleFace.new(12, 16, 13)
shape4_faces << TriangleFace.new(12, 8, 15)
shape4_faces << TriangleFace.new(11, 15, 8)
shape4_faces << TriangleFace.new(15, 11, 14)
shape4_faces << TriangleFace.new(10, 14, 11)
shape4_faces << TriangleFace.new(14, 10, 13)
shape4_faces << TriangleFace.new(9, 13, 10)
shape4_faces << TriangleFace.new(13, 9, 12)
shape4_faces << TriangleFace.new(8, 12, 9)
shape4_faces << TriangleFace.new(8, 1, 11)
shape4_faces << TriangleFace.new(7, 11, 1)
shape4_faces << TriangleFace.new(11, 7, 10)
shape4_faces << TriangleFace.new(5, 10, 7)
shape4_faces << TriangleFace.new(10, 5, 9)
shape4_faces << TriangleFace.new(3, 9, 5)
shape4_faces << TriangleFace.new(9, 3, 8)
shape4_faces << TriangleFace.new(1, 8, 3)
shape4_faces << TriangleFace.new(1, 0, 7)
shape4_faces << TriangleFace.new(6, 7, 0)
shape4_faces << TriangleFace.new(7, 6, 5)
shape4_faces << TriangleFace.new(4, 5, 6)
shape4_faces << TriangleFace.new(5, 4, 3)
shape4_faces << TriangleFace.new(2, 3, 4)
shape4_faces << TriangleFace.new(3, 2, 1)
shape4_faces << TriangleFace.new(0, 1, 2)

whale_shape4 = TriangleMesh.new(
     TriangleFace::Direction_none,
     shape4_vertices,
     shape4_faces,
     normals,
     face_normals,
     false,
     false)

$shapes << whale_shape4

# shape_5

shape5_vertices = PointArray.new
shape5_vertices << Point.new(1.277, -0.035, -0.058, m)
shape5_vertices << Point.new(1.258, -0.033, 0, m)
shape5_vertices << Point.new(1.353, -0.051, 0, m)
shape5_vertices << Point.new(1.379, -0.051, -0.058, m)
shape5_vertices << Point.new(1.258, -0.068, 0, m)
shape5_vertices << Point.new(1.277, -0.066, -0.058, m)
shape5_vertices << Point.new(1.162, -0.051, 0, m)
shape5_vertices << Point.new(1.175, -0.051, -0.058, m)
shape5_vertices << Point.new(1.295, -0.037, -0.114, m)
shape5_vertices << Point.new(1.385, -0.05, -0.114, m)
shape5_vertices << Point.new(1.295, -0.064, -0.114, m)
shape5_vertices << Point.new(1.204, -0.05, -0.114, m)
shape5_vertices << Point.new(1.314, -0.039, -0.182, m)
shape5_vertices << Point.new(1.393, -0.05, -0.182, m)
shape5_vertices << Point.new(1.314, -0.062, -0.182, m)
shape5_vertices << Point.new(1.235, -0.05, -0.182, m)
shape5_vertices << Point.new(1.331, -0.041, -0.23, m)
shape5_vertices << Point.new(1.396, -0.05, -0.23, m)
shape5_vertices << Point.new(1.331, -0.06, -0.23, m)
shape5_vertices << Point.new(1.266, -0.05, -0.23, m)
shape5_vertices << Point.new(1.354, -0.042, -0.282, m)
shape5_vertices << Point.new(1.403, -0.05, -0.282, m)
shape5_vertices << Point.new(1.354, -0.058, -0.282, m)
shape5_vertices << Point.new(1.305, -0.05, -0.282, m)
shape5_vertices << Point.new(1.37, -0.044, -0.332, m)
shape5_vertices << Point.new(1.405, -0.05, -0.332, m)
shape5_vertices << Point.new(1.37, -0.056, -0.332, m)
shape5_vertices << Point.new(1.335, -0.05, -0.332, m)
shape5_vertices << Point.new(1.386, -0.045, -0.374, m)
shape5_vertices << Point.new(1.408, -0.05, -0.374, m)
shape5_vertices << Point.new(1.386, -0.055, -0.374, m)
shape5_vertices << Point.new(1.365, -0.05, -0.374, m)
shape5_vertices << Point.new(1.403, -0.046, -0.402, m)
shape5_vertices << Point.new(1.421, -0.05, -0.402, m)
shape5_vertices << Point.new(1.403, -0.054, -0.402, m)
shape5_vertices << Point.new(1.386, -0.05, -0.402, m)
shape5_vertices << Point.new(1.419, -0.047, -0.409, m)
shape5_vertices << Point.new(1.423, -0.05, -0.409, m)
shape5_vertices << Point.new(1.419, -0.053, -0.409, m)
shape5_vertices << Point.new(1.416, -0.05, -0.409, m)
#
shape5_faces = TriangleFaceArray.new
shape5_faces << TriangleFace.new(38, 39, 37)
shape5_faces << TriangleFace.new(36, 37, 39)
shape5_faces << TriangleFace.new(6, 4, 1)
shape5_faces << TriangleFace.new(2, 1, 4)
shape5_faces << TriangleFace.new(32, 36, 39)
shape5_faces << TriangleFace.new(39, 35, 32)
shape5_faces << TriangleFace.new(35, 39, 38)
shape5_faces << TriangleFace.new(38, 34, 35)
shape5_faces << TriangleFace.new(34, 38, 37)
shape5_faces << TriangleFace.new(37, 33, 34)
shape5_faces << TriangleFace.new(33, 37, 36)
shape5_faces << TriangleFace.new(36, 32, 33)
shape5_faces << TriangleFace.new(28, 32, 35)
shape5_faces << TriangleFace.new(35, 31, 28)
shape5_faces << TriangleFace.new(31, 35, 34)
shape5_faces << TriangleFace.new(34, 30, 31)
shape5_faces << TriangleFace.new(30, 34, 33)
shape5_faces << TriangleFace.new(33, 29, 30)
shape5_faces << TriangleFace.new(29, 33, 32)
shape5_faces << TriangleFace.new(32, 28, 29)
shape5_faces << TriangleFace.new(24, 28, 31)
shape5_faces << TriangleFace.new(31, 27, 24)
shape5_faces << TriangleFace.new(27, 31, 30)
shape5_faces << TriangleFace.new(30, 26, 27)
shape5_faces << TriangleFace.new(26, 30, 29)
shape5_faces << TriangleFace.new(29, 25, 26)
shape5_faces << TriangleFace.new(25, 29, 28)
shape5_faces << TriangleFace.new(28, 24, 25)
shape5_faces << TriangleFace.new(20, 24, 27)
shape5_faces << TriangleFace.new(27, 23, 20)
shape5_faces << TriangleFace.new(23, 27, 26)
shape5_faces << TriangleFace.new(26, 22, 23)
shape5_faces << TriangleFace.new(22, 26, 25)
shape5_faces << TriangleFace.new(25, 21, 22)
shape5_faces << TriangleFace.new(21, 25, 24)
shape5_faces << TriangleFace.new(24, 20, 21)
shape5_faces << TriangleFace.new(16, 20, 23)
shape5_faces << TriangleFace.new(23, 19, 16)
shape5_faces << TriangleFace.new(19, 23, 22)
shape5_faces << TriangleFace.new(22, 18, 19)
shape5_faces << TriangleFace.new(18, 22, 21)
shape5_faces << TriangleFace.new(21, 17, 18)
shape5_faces << TriangleFace.new(17, 21, 20)
shape5_faces << TriangleFace.new(20, 16, 17)
shape5_faces << TriangleFace.new(12, 16, 19)
shape5_faces << TriangleFace.new(19, 15, 12)
shape5_faces << TriangleFace.new(15, 19, 18)
shape5_faces << TriangleFace.new(18, 14, 15)
shape5_faces << TriangleFace.new(14, 18, 17)
shape5_faces << TriangleFace.new(17, 13, 14)
shape5_faces << TriangleFace.new(13, 17, 16)
shape5_faces << TriangleFace.new(16, 12, 13)
shape5_faces << TriangleFace.new(8, 12, 15)
shape5_faces << TriangleFace.new(15, 11, 8)
shape5_faces << TriangleFace.new(11, 15, 14)
shape5_faces << TriangleFace.new(14, 10, 11)
shape5_faces << TriangleFace.new(10, 14, 13)
shape5_faces << TriangleFace.new(13, 9, 10)
shape5_faces << TriangleFace.new(9, 13, 12)
shape5_faces << TriangleFace.new(12, 8, 9)
shape5_faces << TriangleFace.new(0, 8, 11)
shape5_faces << TriangleFace.new(11, 7, 0)
shape5_faces << TriangleFace.new(7, 11, 10)
shape5_faces << TriangleFace.new(10, 5, 7)
shape5_faces << TriangleFace.new(5, 10, 9)
shape5_faces << TriangleFace.new(9, 3, 5)
shape5_faces << TriangleFace.new(3, 9, 8)
shape5_faces << TriangleFace.new(8, 0, 3)
shape5_faces << TriangleFace.new(1, 0, 7)
shape5_faces << TriangleFace.new(7, 6, 1)
shape5_faces << TriangleFace.new(6, 7, 5)
shape5_faces << TriangleFace.new(5, 4, 6)
shape5_faces << TriangleFace.new(4, 5, 3)
shape5_faces << TriangleFace.new(3, 2, 4)
shape5_faces << TriangleFace.new(2, 3, 0)
shape5_faces << TriangleFace.new(0, 1, 2)

whale_shape5 = TriangleMesh.new(
     TriangleFace::Direction_none,
     shape5_vertices,
     shape5_faces,
     normals,
     face_normals,
     false,
     false)

$shapes << whale_shape5
